/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.ItemCheatingMode;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ItemListOrdering;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.client.SearchArgument;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

import java.awt.*;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class ItemListOverlay extends Widget {
    
    private static final String SPACE = " ", EMPTY = "";
    private static final Comparator<class_1799> ASCENDING_COMPARATOR;
    private static List<class_1792> searchBlacklisted = Lists.newArrayList();
    
    static {
        ASCENDING_COMPARATOR = (itemStack, t1) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.equals(ItemListOrdering.name))
                return tryGetItemStackName(itemStack).compareToIgnoreCase(tryGetItemStackName(t1));
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.equals(ItemListOrdering.item_groups)) {
                List<class_1761> itemGroups = Arrays.asList(class_1761.field_7921);
                return itemGroups.indexOf(itemStack.method_7909().method_7859()) - itemGroups.indexOf(t1.method_7909().method_7859());
            }
            return 0;
        };
    }
    
    private final List<SearchArgument[]> lastSearchArgument;
    private List<class_1799> currentDisplayed;
    private List<Widget> widgets;
    private int width, height, page;
    private Rectangle rectangle, listArea;
    
    public ItemListOverlay(int page) {
        this.currentDisplayed = Lists.newArrayList();
        this.width = 0;
        this.height = 0;
        this.page = page;
        this.lastSearchArgument = Lists.newArrayList();
    }
    
    public static List<String> tryGetItemStackToolTip(class_1799 itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.method_7909()))
            try {
                return itemStack.method_7950(class_310.method_1551().field_1724, class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934).stream().map(class_2561::method_10863).collect(Collectors.toList());
            } catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.method_7909());
            }
        return Collections.singletonList(tryGetItemStackName(itemStack));
    }
    
    public static String tryGetItemStackName(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909()))
            try {
                return stack.method_7964().method_10863();
            } catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        try {
            return class_1074.method_4662("item." + class_2378.field_11142.method_10221(stack.method_7909()).toString().replace(":", "."));
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return "ERROR";
    }
    
    public static boolean filterItem(class_1799 itemStack, List<SearchArgument[]> arguments) {
        if (arguments.isEmpty())
            return true;
        AtomicReference<String> mod = null, tooltips = null, name = null;
        for(SearchArgument[] arguments1 : arguments) {
            boolean b = true;
            for(SearchArgument argument : arguments1) {
                if (argument.getArgumentType().equals(SearchArgument.ArgumentType.ALWAYS))
                    return true;
                if (argument.getArgumentType().equals(SearchArgument.ArgumentType.MOD))
                    if (argument.getFunction(!argument.isInclude()).apply(fillMod(itemStack, mod))) {
                        b = false;
                        break;
                    }
                if (argument.getArgumentType().equals(SearchArgument.ArgumentType.TOOLTIP))
                    if (argument.getFunction(!argument.isInclude()).apply(fillTooltip(itemStack, tooltips))) {
                        b = false;
                        break;
                    }
                if (argument.getArgumentType().equals(SearchArgument.ArgumentType.TEXT))
                    if (argument.getFunction(!argument.isInclude()).apply(fillName(itemStack, name))) {
                        b = false;
                        break;
                    }
            }
            if (b)
                return true;
        }
        return false;
    }
    
    private static String fillMod(class_1799 itemStack, AtomicReference<String> mod) {
        if (mod == null)
            mod = new AtomicReference<>(ClientHelper.getInstance().getModFromItem(itemStack.method_7909()).toLowerCase(Locale.ROOT));
        return mod.get();
    }
    
    private static String fillTooltip(class_1799 itemStack, AtomicReference<String> mod) {
        if (mod == null)
            mod = new AtomicReference<>(tryGetItemStackToolTip(itemStack, false).stream().collect(Collectors.joining("")).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        return mod.get();
    }
    
    private static String fillName(class_1799 itemStack, AtomicReference<String> mod) {
        if (mod == null)
            mod = new AtomicReference<>(tryGetItemStackName(itemStack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        return mod.get();
    }
    
    public int getFullTotalSlotsPerPage() {
        return width * height;
    }
    
    @Override
    public void render(int int_1, int int_2, float float_1) {
        class_308.method_1450();
        widgets.forEach(widget -> widget.render(int_1, int_2, float_1));
        class_746 player = minecraft.field_1724;
        if (rectangle.contains(ClientUtils.getMouseLocation()) && ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets())
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(class_1074.method_4662("text.rei.delete_items")));
    }
    
    public void updateList(DisplayHelper.DisplayBoundsHandler boundsHandler, Rectangle rectangle, int page, String searchTerm, boolean processSearchTerm) {
        this.rectangle = rectangle;
        this.page = page;
        this.widgets = Lists.newLinkedList();
        calculateListSize(rectangle);
        if (currentDisplayed.isEmpty() || processSearchTerm)
            currentDisplayed = processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getItemRegisterer().getItemList(), new ArrayList<>(ScreenHelper.inventoryStacks));
        int startX = (int) rectangle.getCenterX() - width * 9;
        int startY = (int) rectangle.getCenterY() - height * 9;
        this.listArea = new Rectangle((int) startX, (int) startY, width * 18, height * 18);
        int fitSlotsPerPage = getTotalFitSlotsPerPage(startX, startY, listArea);
        int j = page * fitSlotsPerPage;
        for(int yy = 0; yy < height; yy++) {
            for(int xx = 0; xx < width; xx++) {
                int x = startX + xx * 18, y = startY + yy * 18;
                if (!canBeFit(x, y, listArea))
                    continue;
                j++;
                if (j > currentDisplayed.size())
                    break;
                widgets.add(new SlotWidget(x, y, Collections.singletonList(currentDisplayed.get(j - 1)), false, true, true) {
                    @Override
                    protected void queueTooltip(class_1799 itemStack, float delta) {
                        class_746 player = minecraft.field_1724;
                        if (!ClientHelper.getInstance().isCheating() || player.field_7514.method_7399().method_7960())
                            super.queueTooltip(itemStack, delta);
                    }
                    
                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int button) {
                        if (isCurrentRendererItem() && isHighlighted(mouseX, mouseY)) {
                            if (ClientHelper.getInstance().isCheating()) {
                                if (getCurrentItemStack() != null && !getCurrentItemStack().method_7960()) {
                                    class_1799 cheatedStack = getCurrentItemStack().method_7972();
                                    if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.REI_LIKE)
                                        cheatedStack.method_7939(button != 1 ? 1 : cheatedStack.method_7914());
                                    else if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.JEI_LIKE)
                                        cheatedStack.method_7939(button != 0 ? 1 : cheatedStack.method_7914());
                                    else
                                        cheatedStack.method_7939(1);
                                    return ClientHelper.getInstance().tryCheatingStack(cheatedStack);
                                }
                            } else if (button == 0)
                                return ClientHelper.getInstance().executeRecipeKeyBind(getCurrentItemStack().method_7972());
                            else if (button == 1)
                                return ClientHelper.getInstance().executeUsageKeyBind(getCurrentItemStack().method_7972());
                        }
                        return false;
                    }
                });
            }
            if (j > currentDisplayed.size())
                break;
        }
    }
    
    public int getTotalPage() {
        int fitSlotsPerPage = getTotalFitSlotsPerPage(listArea.x, listArea.y, listArea);
        if (fitSlotsPerPage > 0)
            return class_3532.method_15386(getCurrentDisplayed().size() / fitSlotsPerPage);
        return 0;
    }
    
    public int getTotalFitSlotsPerPage(int startX, int startY, Rectangle listArea) {
        int slots = 0;
        for(int x = 0; x < width; x++)
            for(int y = 0; y < height; y++)
                if (canBeFit(startX + x * 18, startY + y * 18, listArea))
                    slots++;
        return slots;
    }
    
    public boolean canBeFit(int left, int top, Rectangle listArea) {
        for(DisplayHelper.DisplayBoundsHandler sortedBoundsHandler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(minecraft.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(!RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel, left, top, minecraft.field_1755, listArea);
            if (fit != class_1269.field_5811)
                return fit == class_1269.field_5812;
        }
        return true;
    }
    
    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        for(Widget widget : widgets)
            if (widget.keyPressed(int_1, int_2, int_3))
                return true;
        return false;
    }
    
    public Rectangle getListArea() {
        return listArea;
    }
    
    public List<class_1799> getCurrentDisplayed() {
        return currentDisplayed;
    }
    
    private List<class_1799> processSearchTerm(String searchTerm, List<class_1799> ol, List<class_1799> inventoryItems) {
        lastSearchArgument.clear();
        List<class_1799> os = new LinkedList<>(ol);
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering != ItemListOrdering.registry)
            os = ol.stream().sorted(ASCENDING_COMPARATOR).collect(Collectors.toList());
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending)
            Collections.reverse(os);
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens(searchTerm, "|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            String[] split = StringUtils.split(s);
            SearchArgument[] arguments = new SearchArgument[split.length];
            for(int i = 0; i < split.length; i++) {
                String s1 = split[i];
                if (s1.startsWith("@-") || s1.startsWith("-@"))
                    arguments[i] = new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false);
                else if (s1.startsWith("@"))
                    arguments[i] = new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true);
                else if (s1.startsWith("#-") || s1.startsWith("-#"))
                    arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false);
                else if (s1.startsWith("#"))
                    arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true);
                else if (s1.startsWith("-"))
                    arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false);
                else
                    arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TEXT, s1, true);
            }
            if (arguments.length > 0)
                lastSearchArgument.add(arguments);
            else
                lastSearchArgument.add(new SearchArgument[]{SearchArgument.ALWAYS});
        });
        List<class_1799> stacks = Collections.emptyList();
        if (lastSearchArgument.isEmpty())
            stacks = Collections.unmodifiableList(os);
        else
            stacks = Collections.unmodifiableList(os.stream().filter(itemStack -> filterItem(itemStack, lastSearchArgument)).collect(Collectors.toList()));
        if (!RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() || stacks.isEmpty() || inventoryItems.isEmpty())
            return stacks;
        List<class_1799> workingItems = Lists.newArrayList(RecipeHelper.getInstance().findCraftableByItems(inventoryItems));
        return stacks.stream().filter(itemStack -> workingItems.stream().anyMatch(stack -> stack.method_7962(itemStack))).collect(Collectors.toList());
    }
    
    public List<SearchArgument[]> getLastSearchArgument() {
        return lastSearchArgument;
    }
    
    public void calculateListSize(Rectangle rect) {
        int xOffset = 0, yOffset = 0;
        width = 0;
        height = 0;
        while (true) {
            xOffset += 18;
            if (height == 0)
                width++;
            if (xOffset + 19 > rect.width) {
                xOffset = 0;
                yOffset += 18;
                height++;
            }
            if (yOffset + 19 > rect.height)
                break;
        }
    }
    
    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (rectangle.contains(double_1, double_2)) {
            class_746 player = minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets())
                return false;
            for(Widget widget : children())
                if (widget.mouseClicked(double_1, double_2, int_1))
                    return true;
        }
        return false;
    }
    
    @Override
    public List<Widget> children() {
        return widgets;
    }
    
}
