/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.widget;

import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.ScreenHelper;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1860;
import java.awt.*;
import java.util.Optional;
import java.util.function.Supplier;

public class SpeedCraftingButtonWidget extends ButtonWidget {
    
    private final Supplier<RecipeDisplay> displaySupplier;
    private final SpeedCraftFunctional functional;
    private String extraTooltip;
    
    public SpeedCraftingButtonWidget(Rectangle rectangle, String text, SpeedCraftFunctional functional, Supplier<RecipeDisplay> displaySupplier) {
        super(rectangle, text);
        this.displaySupplier = displaySupplier;
        this.functional = functional;
        Optional<class_1860> recipe = displaySupplier.get().getRecipe();
        extraTooltip = recipe.isPresent() ? class_1074.method_4662("text.rei.recipe_id", class_124.field_1080.toString(), recipe.get().method_8114().toString()) : "";
    }
    
    @Override
    public void onPressed() {
        minecraft.method_1507(ScreenHelper.getLastContainerScreen());
        ScreenHelper.getLastOverlay().init();
        functional.performAutoCraft(ScreenHelper.getLastContainerScreen(), displaySupplier.get());
    }
    
    @Override
    public void render(int mouseX, int mouseY, float delta) {
        this.enabled = functional != null && functional.acceptRecipe(ScreenHelper.getLastContainerScreen(), displaySupplier.get());
        super.render(mouseX, mouseY, delta);
    }
    
    @Override
    public Optional<String> getTooltips() {
        if (this.minecraft.field_1690.field_1827)
            if (enabled)
                return Optional.ofNullable(class_1074.method_4662("text.speed_craft.move_items") + extraTooltip);
            else
                return Optional.ofNullable(class_1074.method_4662("text.speed_craft.failed_move_items") + extraTooltip);
        if (enabled)
            return Optional.ofNullable(class_1074.method_4662("text.speed_craft.move_items"));
        else
            return Optional.ofNullable(class_1074.method_4662("text.speed_craft.failed_move_items"));
    }
}
