/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.mixin;

import com.google.common.collect.Lists;
import me.shedaniel.rei.plugin.BrewingRecipe;
import me.shedaniel.rei.plugin.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_1792;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Arrays;
import java.util.List;

@Mixin(class_1845.class)
public class MixinBrewingRecipeRegistry {
    
    private static final List<BrewingRecipe> SELF_ITEM_RECIPES = Lists.newArrayList();
    private static final List<class_1842> REGISTERED_POTION_TYPES = Lists.newArrayList();
    private static final List<class_1856> SELF_POTION_TYPES = Lists.newArrayList();
    
    @Inject(method = "registerPotionType", at = @At("RETURN"))
    private static void method_8080(class_1792 item_1, CallbackInfo ci) {
        if (item_1 instanceof class_1812)
            SELF_POTION_TYPES.add(class_1856.method_8091(new class_1935[]{item_1}));
    }
    
    @Inject(method = "registerItemRecipe", at = @At("RETURN"))
    private static void method_8071(class_1792 item_1, class_1792 item_2, class_1792 item_3, CallbackInfo ci) {
        if (item_1 instanceof class_1812 && item_3 instanceof class_1812)
            SELF_ITEM_RECIPES.add(new BrewingRecipe(item_1, class_1856.method_8091(new class_1935[]{item_2}), item_3));
    }
    
    @Inject(method = "registerPotionRecipe", at = @At("RETURN"))
    private static void registerPotionRecipe(class_1842 potion_1, class_1792 item_1, class_1842 potion_2, CallbackInfo ci) {
        if (!REGISTERED_POTION_TYPES.contains(potion_1))
            rei_registerPotionType(potion_1);
        if (!REGISTERED_POTION_TYPES.contains(potion_2))
            rei_registerPotionType(potion_2);
        SELF_POTION_TYPES.stream().map(class_1856::method_8105).forEach(itemStacks -> Arrays.stream(itemStacks).forEach(stack -> {
            DefaultPlugin.registerBrewingDisplay(new DefaultBrewingDisplay(class_1844.method_8061(stack.method_7972(), potion_1), class_1856.method_8091(new class_1935[]{item_1}), class_1844.method_8061(stack.method_7972(), potion_2)));
        }));
    }
    
    private static void rei_registerPotionType(class_1842 potion) {
        REGISTERED_POTION_TYPES.add(potion);
        SELF_ITEM_RECIPES.forEach(recipe -> {
            DefaultPlugin.registerBrewingDisplay(new DefaultBrewingDisplay(class_1844.method_8061(recipe.input.method_7854(), potion), recipe.ingredient, class_1844.method_8061(recipe.output.method_7854(), potion)));
        });
    }
    
}
