/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import com.mojang.blaze3d.platform.GlStateManager;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.renderables.RecipeRenderer;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import java.awt.*;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class DefaultSmokingCategory implements RecipeCategory<DefaultSmokingDisplay> {
    
    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.SMOKING;
    }
    
    @Override
    public Renderer getIcon() {
        return Renderable.fromItemStack(new class_1799(class_2246.field_16334));
    }
    
    @Override
    public String getCategoryName() {
        return class_1074.method_4662("category.rei.smoking");
    }
    
    @Override
    public RecipeRenderer getSimpleRenderer(DefaultSmokingDisplay recipe) {
        return Renderable.fromRecipe(() -> Arrays.asList(recipe.getInput().get(0)), recipe::getOutput);
    }
    
    @Override
    public List<Widget> setupDisplay(Supplier<DefaultSmokingDisplay> recipeDisplaySupplier, Rectangle bounds) {
        Point startPoint = new Point((int) bounds.getCenterX() - 41, (int) bounds.getCenterY() - 27);
        List<Widget> widgets = new LinkedList<>(Arrays.asList(new RecipeBaseWidget(bounds) {
            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                GlStateManager.color4f(1.0F, 1.0F, 1.0F, 1.0F);
                class_308.method_1450();
                class_310.method_1551().method_1531().method_4618(DefaultPlugin.getDisplayTexture());
                blit(startPoint.x, startPoint.y, 0, 54, 82, 54);
                int height = class_3532.method_15384((System.currentTimeMillis() / 250 % 14d) / 1f);
                blit(startPoint.x + 2, startPoint.y + 21 + (14 - height), 82, 77 + (14 - height), 14, height);
                int width = class_3532.method_15384((System.currentTimeMillis() / 250 % 24d) / 1f);
                blit(startPoint.x + 24, startPoint.y + 18, 82, 91, width, 17);
            }
        }));
        List<List<class_1799>> input = recipeDisplaySupplier.get().getInput();
        widgets.add(new SlotWidget(startPoint.x + 1, startPoint.y + 1, input.get(0), true, true, true));
        widgets.add(new SlotWidget(startPoint.x + 1, startPoint.y + 37, recipeDisplaySupplier.get().getFuel(), true, true, true) {
            @Override
            protected List<String> getExtraToolTips(class_1799 stack) {
                return Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662("category.rei.smelting.fuel"));
            }
        });
        widgets.add(new SlotWidget(startPoint.x + 61, startPoint.y + 19, recipeDisplaySupplier.get().getOutput(), false, true, true));
        return widgets;
    }
    
}
