/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;

public class BaseBoundsHandlerImpl
implements BaseBoundsHandler {
    private static final Function<? super Rectangle, Long> RECTANGLE_LONG_FUNCTION = r -> (long)r.x + 1000L * (long)r.y + 1000000L * (long)r.width + 1000000000L * (long)r.height;
    private static final Comparator<class_3545<class_3545<Class<?>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>> LIST_PAIR_COMPARATOR;
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER;
    private long lastArea = -1L;
    private List<class_3545<class_3545<Class<?>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>> list = Lists.newArrayList();

    @Override
    public Class getBaseSupportedClass() {
        return class_437.class;
    }

    @Override
    public Rectangle getLeftBounds(class_437 screen) {
        return new Rectangle();
    }

    @Override
    public Rectangle getRightBounds(class_437 screen) {
        return new Rectangle();
    }

    @Override
    public float getPriority() {
        return -5.0f;
    }

    @Override
    public class_1269 isInZone(boolean isOnRightSide, double mouseX, double mouseY) {
        for (Rectangle zone : this.getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false)) {
            if (!zone.contains(mouseX, mouseY)) continue;
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        long current = this.getStringFromCurrent(isOnRightSide);
        if (this.lastArea == current) {
            return false;
        }
        this.lastArea = current;
        return true;
    }

    private DisplayHelper.DisplayBoundsHandler getHandler() {
        return RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
    }

    private long getStringFromCurrent(boolean isOnRightSide) {
        return this.getLongFromAreas(isOnRightSide ? this.getHandler().getRightBounds(class_310.method_1551().field_1755) : this.getHandler().getLeftBounds(class_310.method_1551().field_1755), this.getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false));
    }

    @Override
    public class_1269 canItemSlotWidgetFit(boolean isOnRightSide, int left, int top, class_437 screen, Rectangle fullBounds) {
        for (Rectangle currentExclusionZone : this.getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false)) {
            if (left + 18 < currentExclusionZone.x || top + 18 < currentExclusionZone.y || left > currentExclusionZone.x + currentExclusionZone.width || top > currentExclusionZone.y + currentExclusionZone.height) continue;
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public List<Rectangle> getCurrentExclusionZones(Class<? extends class_437> currentScreenClass, boolean isOnRightSide, boolean sort) {
        ArrayList rectangles = Lists.newArrayList();
        for (class_3545<class_3545<Class<?>, Float>, BaseBoundsHandler.ExclusionZoneSupplier> pair : this.list) {
            if (!((Class)((class_3545)pair.method_15442()).method_15442()).isAssignableFrom(currentScreenClass)) continue;
            rectangles.addAll(((BaseBoundsHandler.ExclusionZoneSupplier)pair.method_15441()).apply(isOnRightSide));
        }
        if (sort) {
            rectangles.sort(RECTANGLE_COMPARER);
        }
        return rectangles;
    }

    @Override
    public void registerExclusionZones(Class<? extends class_437> screenClass, BaseBoundsHandler.ExclusionZoneSupplier supplier) {
        this.list.add(new class_3545((Object)new class_3545(screenClass, (Object)Float.valueOf(0.0f)), (Object)supplier));
    }

    public long getLongFromAreas(Rectangle rectangle, List<Rectangle> exclusionZones) {
        long a = RECTANGLE_LONG_FUNCTION.apply(rectangle);
        for (Rectangle exclusionZone : exclusionZones) {
            a -= RECTANGLE_LONG_FUNCTION.apply(exclusionZone).longValue();
        }
        return a;
    }

    static {
        RECTANGLE_COMPARER = Comparator.comparingLong(RECTANGLE_LONG_FUNCTION::apply);
        Comparator<class_3545> comparator = Comparator.comparingDouble(value -> ((Float)((class_3545)value.method_15442()).method_15441()).floatValue());
        LIST_PAIR_COMPARATOR = comparator.reversed();
    }
}

