/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;

public class DisplayHelperImpl
implements DisplayHelper {
    private static final Comparator<DisplayHelper.DisplayBoundsHandler> BOUNDS_HANDLER_COMPARATOR;
    private static final DisplayHelper.DisplayBoundsHandler EMPTY;
    private List<DisplayHelper.DisplayBoundsHandler> screenDisplayBoundsHandlers = Lists.newArrayList();
    private Map<Class, DisplayHelper.DisplayBoundsHandler> handlerCache = Maps.newHashMap();
    private Map<Class, List<DisplayHelper.DisplayBoundsHandler>> handlerSortedCache = Maps.newHashMap();
    private BaseBoundsHandler baseBoundsHandler;
    private Class tempScreen;

    @Override
    public List<DisplayHelper.DisplayBoundsHandler> getSortedBoundsHandlers(Class screenClass) {
        if (this.handlerSortedCache.containsKey(screenClass)) {
            return this.handlerSortedCache.get(screenClass);
        }
        this.tempScreen = screenClass;
        this.handlerSortedCache.put(screenClass, this.screenDisplayBoundsHandlers.stream().filter(this::filterResponsible).sorted(BOUNDS_HANDLER_COMPARATOR).collect(Collectors.toList()));
        return this.handlerSortedCache.get(screenClass);
    }

    @Override
    public List<DisplayHelper.DisplayBoundsHandler> getAllBoundsHandlers() {
        return this.screenDisplayBoundsHandlers;
    }

    @Override
    public DisplayHelper.DisplayBoundsHandler getResponsibleBoundsHandler(Class screenClass) {
        if (this.handlerCache.containsKey(screenClass)) {
            return this.handlerCache.get(screenClass);
        }
        this.tempScreen = screenClass;
        this.handlerCache.put(screenClass, this.screenDisplayBoundsHandlers.stream().filter(this::filterResponsible).sorted(BOUNDS_HANDLER_COMPARATOR).findAny().orElse(EMPTY));
        return this.handlerCache.get(screenClass);
    }

    public boolean filterResponsible(DisplayHelper.DisplayBoundsHandler handler) {
        return handler.getBaseSupportedClass().isAssignableFrom(this.tempScreen);
    }

    @Override
    public void registerBoundsHandler(DisplayHelper.DisplayBoundsHandler handler) {
        this.screenDisplayBoundsHandlers.add(handler);
    }

    @Override
    public BaseBoundsHandler getBaseBoundsHandler() {
        return this.baseBoundsHandler;
    }

    public void setBaseBoundsHandler(BaseBoundsHandler baseBoundsHandler) {
        this.baseBoundsHandler = baseBoundsHandler;
    }

    public void resetCache() {
        this.handlerCache.clear();
        this.handlerSortedCache.clear();
    }

    static {
        EMPTY = new DisplayHelper.DisplayBoundsHandler(){

            @Override
            public Class getBaseSupportedClass() {
                return null;
            }

            public Rectangle getLeftBounds(Object screen) {
                return new Rectangle();
            }

            public Rectangle getRightBounds(Object screen) {
                return new Rectangle();
            }

            @Override
            public float getPriority() {
                return -10.0f;
            }
        };
        Comparator<DisplayHelper.DisplayBoundsHandler> comparator = Comparator.comparingDouble(DisplayHelper.DisplayBoundsHandler::getPriority);
        BOUNDS_HANDLER_COMPARATOR = comparator.reversed();
    }
}

