/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.DisplaySettings;
import me.shedaniel.rei.api.DisplayVisibility;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.PluginFunction;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.BaseBoundsHandlerImpl;
import me.shedaniel.rei.client.DisplayHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;

public class RecipeHelperImpl
implements RecipeHelper {
    private static final Comparator<DisplayVisibilityHandler> VISIBILITY_HANDLER_COMPARATOR;
    private static final Comparator<class_1860> RECIPE_COMPARATOR;
    public final List<RecipeFunction> recipeFunctions = Lists.newArrayList();
    private final AtomicInteger recipeCount = new AtomicInteger();
    private final Map<class_2960, List<RecipeDisplay>> recipeCategoryListMap = Maps.newHashMap();
    private final Map<class_2960, DisplaySettings> categoryDisplaySettingsMap = Maps.newHashMap();
    private final List<RecipeCategory> categories = Lists.newArrayList();
    private final Map<class_2960, ButtonAreaSupplier> speedCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<class_2960, List<SpeedCraftFunctional>> speedCraftFunctionalMap = Maps.newHashMap();
    private final Map<class_2960, List<List<class_1799>>> categoryWorkingStations = Maps.newHashMap();
    private final List<DisplayVisibilityHandler> displayVisibilityHandlers = Lists.newArrayList();
    private final List<LiveRecipeGenerator> liveRecipeGenerators = Lists.newArrayList();
    private class_1863 recipeManager;

    @Override
    public List<class_1799> findCraftableByItems(List<class_1799> inventoryItems) {
        ArrayList<class_1799> craftables = new ArrayList<class_1799>();
        for (List<RecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (RecipeDisplay recipeDisplay : value) {
                int slotsCraftable = 0;
                List<List<class_1799>> requiredInput = recipeDisplay.getRequiredItems();
                block2: for (List<class_1799> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    boolean slotDone = false;
                    for (class_1799 possibleType : inventoryItems) {
                        for (class_1799 slotPossible : slot) {
                            if (!class_1799.method_7984((class_1799)slotPossible, (class_1799)possibleType)) continue;
                            ++slotsCraftable;
                            slotDone = true;
                            break;
                        }
                        if (!slotDone) continue;
                        continue block2;
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredItems().size()) continue;
                craftables.addAll(recipeDisplay.getOutput());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void registerCategory(RecipeCategory category) {
        this.categories.add(category);
        this.categoryDisplaySettingsMap.put(category.getIdentifier(), category.getDisplaySettings());
        this.recipeCategoryListMap.put(category.getIdentifier(), Lists.newLinkedList());
        this.categoryWorkingStations.put(category.getIdentifier(), Lists.newLinkedList());
    }

    @Override
    public void registerWorkingStations(class_2960 category, List<class_1799> ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations));
    }

    @Override
    public void registerWorkingStations(class_2960 category, class_1799 ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations).stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    @Override
    public List<List<class_1799>> getWorkingStations(class_2960 category) {
        return this.categoryWorkingStations.get(category);
    }

    @Override
    public void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(display);
    }

    private void registerDisplay(class_2960 categoryIdentifier, RecipeDisplay display, int index) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(index, display);
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getRecipesFor(class_1799 stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<class_2960, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            for (RecipeDisplay recipeDisplay : entry.getValue()) {
                for (class_1799 outputStack : recipeDisplay.getOutput()) {
                    if (!(category2.checkTags() ? class_1799.method_7973((class_1799)stack, (class_1799)outputStack) : class_1799.method_7984((class_1799)stack, (class_1799)outputStack))) continue;
                    ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getRecipeFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    private RecipeCategory getCategory(class_2960 identifier) {
        return this.categories.stream().filter(category -> category.getIdentifier().equals((Object)identifier)).findFirst().orElse(null);
    }

    @Override
    public class_1863 getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getUsagesFor(class_1799 stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<class_2960, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            block1: for (RecipeDisplay recipeDisplay : entry.getValue()) {
                boolean found = false;
                for (List<class_1799> input : recipeDisplay.getInput()) {
                    for (class_1799 itemStack : input) {
                        if (!(category2.checkTags() ? class_1799.method_7973((class_1799)itemStack, (class_1799)stack) : class_1799.method_7984((class_1799)itemStack, (class_1799)stack))) continue;
                        ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getUsageFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    @Override
    public List<RecipeCategory> getAllCategories() {
        return new LinkedList<RecipeCategory>(this.categories);
    }

    @Override
    public Optional<ButtonAreaSupplier> getSpeedCraftButtonArea(RecipeCategory category) {
        if (!this.speedCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return Optional.ofNullable(bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.speedCraftAreaSupplierMap.get(category.getIdentifier()));
    }

    @Override
    public void registerSpeedCraftButtonArea(class_2960 category, ButtonAreaSupplier rectangle) {
        if (rectangle == null) {
            if (this.speedCraftAreaSupplierMap.containsKey(category)) {
                this.speedCraftAreaSupplierMap.remove(category);
            }
        } else {
            this.speedCraftAreaSupplierMap.put(category, rectangle);
        }
    }

    @Override
    public void registerDefaultSpeedCraftButtonArea(class_2960 category) {
        this.registerSpeedCraftButtonArea(category, bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
    }

    @Override
    public List<SpeedCraftFunctional> getSpeedCraftFunctional(RecipeCategory category) {
        if (this.speedCraftFunctionalMap.get(category.getIdentifier()) == null) {
            return Lists.newArrayList();
        }
        return this.speedCraftFunctionalMap.get(category.getIdentifier());
    }

    @Override
    public void registerSpeedCraftFunctional(class_2960 category, SpeedCraftFunctional functional) {
        LinkedList list = this.speedCraftFunctionalMap.containsKey(category) ? new LinkedList(this.speedCraftFunctionalMap.get(category)) : Lists.newLinkedList();
        list.add(functional);
        this.speedCraftFunctionalMap.put(category, list);
    }

    public void recipesLoaded(class_1863 recipeManager) {
        this.recipeCount.set(0);
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.speedCraftAreaSupplierMap.clear();
        this.categoryWorkingStations.clear();
        this.speedCraftFunctionalMap.clear();
        this.categoryDisplaySettingsMap.clear();
        this.recipeFunctions.clear();
        this.displayVisibilityHandlers.clear();
        this.liveRecipeGenerators.clear();
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        BaseBoundsHandlerImpl baseBoundsHandler = new BaseBoundsHandlerImpl();
        RoughlyEnoughItemsCore.getDisplayHelper().registerBoundsHandler(baseBoundsHandler);
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).setBaseBoundsHandler(baseBoundsHandler);
        long startTime = System.currentTimeMillis();
        LinkedList<REIPluginEntry> plugins = new LinkedList<REIPluginEntry>(RoughlyEnoughItemsCore.getPlugins());
        plugins.sort((first, second) -> second.getPriority() - first.getPriority());
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Loading %d plugins: %s", (Object)plugins.size(), (Object)plugins.stream().map(REIPluginEntry::getPluginIdentifier).map(class_2960::toString).collect(Collectors.joining(", ")));
        Collections.reverse(plugins);
        RoughlyEnoughItemsCore.getItemRegisterer().getModifiableItemList().clear();
        PluginDisabler pluginDisabler = RoughlyEnoughItemsCore.getPluginDisabler();
        plugins.forEach(plugin -> {
            class_2960 identifier = plugin.getPluginIdentifier();
            try {
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_ITEMS)) {
                    plugin.registerItems(RoughlyEnoughItemsCore.getItemRegisterer());
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_CATEGORIES)) {
                    plugin.registerPluginCategories(this);
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_RECIPE_DISPLAYS)) {
                    plugin.registerRecipeDisplays(this);
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_BOUNDS)) {
                    plugin.registerBounds(RoughlyEnoughItemsCore.getDisplayHelper());
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_OTHERS)) {
                    plugin.registerOthers(this);
                }
            }
            catch (Exception e) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] " + identifier.toString() + " plugin failed to load!", (Throwable)e);
            }
        });
        if (!this.recipeFunctions.isEmpty()) {
            List<class_1860> allSortedRecipes = this.getAllSortedRecipes();
            Collections.reverse(allSortedRecipes);
            this.recipeFunctions.forEach(recipeFunction -> {
                try {
                    allSortedRecipes.stream().filter(recipe -> recipeFunction.recipeFilter.test((class_1860)recipe)).forEach(t -> this.registerDisplay(recipeFunction.category, (RecipeDisplay)recipeFunction.mappingFunction.apply(t), 0));
                }
                catch (Exception e) {
                    RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to add recipes!", (Throwable)e);
                }
            });
        }
        if (this.getDisplayVisibilityHandlers().isEmpty()) {
            this.registerRecipeVisibilityHandler(new DisplayVisibilityHandler(){

                @Override
                public DisplayVisibility handleDisplay(RecipeCategory category, RecipeDisplay display) {
                    return DisplayVisibility.ALWAYS_VISIBLE;
                }

                @Override
                public float getPriority() {
                    return -1.0f;
                }
            });
        }
        this.categoryDisplaySettingsMap.clear();
        this.categories.forEach(category -> this.categoryDisplaySettingsMap.put(category.getIdentifier(), category.getDisplaySettings()));
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        ScreenHelper.getOptionalOverlay().ifPresent(overlay -> {
            overlay.shouldReInit = true;
        });
        long usedTime = System.currentTimeMillis() - startTime;
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Registered %d stack entries, %d recipes displays, %d bounds handler, %d visibility handlers and %d categories (%s) in %d ms.", (Object)RoughlyEnoughItemsCore.getItemRegisterer().getItemList().size(), (Object)this.recipeCount.get(), (Object)RoughlyEnoughItemsCore.getDisplayHelper().getAllBoundsHandlers().size(), (Object)this.getDisplayVisibilityHandlers().size(), (Object)this.categories.size(), (Object)String.join((CharSequence)", ", this.categories.stream().map(RecipeCategory::getCategoryName).collect(Collectors.toList())), (Object)usedTime);
    }

    @Override
    public int getRecipeCount() {
        return this.recipeCount.get();
    }

    @Override
    public List<class_1860> getAllSortedRecipes() {
        return this.getRecipeManager().method_8126().stream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getAllRecipes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        this.categories.forEach(recipeCategory -> {
            List list;
            if (this.recipeCategoryListMap.containsKey(recipeCategory.getIdentifier()) && !(list = this.recipeCategoryListMap.get(recipeCategory.getIdentifier()).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList())).isEmpty()) {
                map.put(recipeCategory, list);
            }
        });
        return map;
    }

    @Override
    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.add(visibilityHandler);
    }

    @Override
    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.remove(visibilityHandler);
    }

    @Override
    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers() {
        return Collections.unmodifiableList(this.displayVisibilityHandlers);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display, boolean respectConfig) {
        return this.isDisplayVisible(display);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display) {
        RecipeCategory category = this.getCategory(display.getRecipeCategory());
        List list = this.getDisplayVisibilityHandlers().stream().sorted(VISIBILITY_HANDLER_COMPARATOR).collect(Collectors.toList());
        for (DisplayVisibilityHandler displayVisibilityHandler : list) {
            try {
                DisplayVisibility visibility = displayVisibilityHandler.handleDisplay(category, display);
                if (visibility == DisplayVisibility.PASS) continue;
                return visibility == DisplayVisibility.ALWAYS_VISIBLE || visibility == DisplayVisibility.CONFIG_OPTIONAL;
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to check if the recipe is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Class<T> recipeClass, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipe -> recipeClass.isAssignableFrom(recipe.getClass()), mappingFunction));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Function<class_1860, Boolean> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter::apply, mappingFunction));
    }

    @Override
    public <T extends class_1860<?>> void registerRecipes(class_2960 category, Predicate<class_1860> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter, mappingFunction));
    }

    @Override
    public Optional<DisplaySettings> getCachedCategorySettings(class_2960 category) {
        return this.categoryDisplaySettingsMap.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).equals((Object)category)).map(Map.Entry::getValue).findAny();
    }

    @Override
    public void registerLiveRecipeGenerator(LiveRecipeGenerator liveRecipeGenerator) {
        this.liveRecipeGenerators.add(liveRecipeGenerator);
    }

    static {
        RECIPE_COMPARATOR = (o1, o2) -> {
            int int_1 = o1.method_8114().method_12836().compareTo(o2.method_8114().method_12836());
            if (int_1 == 0) {
                int_1 = o1.method_8114().method_12832().compareTo(o2.method_8114().method_12832());
            }
            return int_1;
        };
        Comparator<DisplayVisibilityHandler> comparator = Comparator.comparingDouble(DisplayVisibilityHandler::getPriority);
        VISIBILITY_HANDLER_COMPARATOR = comparator.reversed();
    }

    private class RecipeFunction {
        class_2960 category;
        Predicate<class_1860> recipeFilter;
        Function mappingFunction;

        public RecipeFunction(class_2960 category, Predicate<class_1860> recipeFilter, Function<?, RecipeDisplay> mappingFunction) {
            this.category = category;
            this.recipeFilter = recipeFilter;
            this.mappingFunction = mappingFunction;
        }
    }
}

