/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.client.Weather;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.CraftableToggleButtonWidget;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SearchFieldWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.listeners.ContainerScreenHooks;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import org.apache.logging.log4j.util.TriConsumer;

public class ContainerScreenOverlay
extends class_362
implements class_4068 {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    public static String searchTerm = "";
    private static int page = 0;
    private static ItemListOverlay itemListOverlay;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private Rectangle rectangle;
    private class_1041 window;
    private CraftableToggleButtonWidget toggleButtonWidget;
    private ButtonWidget buttonLeft;
    private ButtonWidget buttonRight;

    public static ItemListOverlay getItemListOverlay() {
        return itemListOverlay;
    }

    public void init() {
        this.init(false);
    }

    public void init(boolean setPage) {
        this.shouldReInit = false;
        this.children().clear();
        this.window = class_310.method_1551().field_1704;
        final DisplayHelper.DisplayBoundsHandler boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        this.rectangle = RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755);
        itemListOverlay = new ItemListOverlay(page);
        this.widgets.add(itemListOverlay);
        itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, false);
        this.buttonLeft = new ButtonWidget(this.rectangle.x, this.rectangle.y + 5, 16, 16, (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                page--;
                if (page < 0) {
                    page = ContainerScreenOverlay.this.getTotalPage();
                }
                itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0]));
            }

            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }
        };
        this.widgets.add(this.buttonLeft);
        this.buttonRight = new ButtonWidget(this.rectangle.x + this.rectangle.width - 18, this.rectangle.y + 5, 16, 16, (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                page++;
                if (page > ContainerScreenOverlay.this.getTotalPage()) {
                    page = 0;
                }
                itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0]));
            }

            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }
        };
        this.widgets.add(this.buttonRight);
        if (setPage) {
            page = class_3532.method_15340((int)page, (int)0, (int)this.getTotalPage());
        }
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.method_4486() - 30 : 10, 10, 20, 20, ""){

            @Override
            public void onPressed() {
                if (class_437.hasShiftDown()) {
                    ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                    return;
                }
                RoughlyEnoughItemsCore.getConfigManager().openConfigScreen((class_437)ScreenHelper.getLastContainerScreen());
            }

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                class_308.method_1450();
                if (ClientHelper.getInstance().isCheating() && RoughlyEnoughItemsCore.hasOperatorPermission()) {
                    if (RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                        3.fill((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + 20), (int)(this.getBounds().y + 20), (int)721354752);
                    } else {
                        3.fill((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + 20), (int)(this.getBounds().y + 20), (int)1476440063);
                    }
                }
                class_310.method_1551().method_1531().method_4618(CHEST_GUI_TEXTURE);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(this.getBounds().x + 3, this.getBounds().y + 3, 0, 0, 14, 14);
            }

            @Override
            public Optional<String> getTooltips() {
                String tooltips = class_1074.method_4662((String)"text.rei.config_tooltip", (Object[])new Object[0]);
                tooltips = tooltips + "\n  ";
                tooltips = !ClientHelper.getInstance().isCheating() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (!RoughlyEnoughItemsCore.hasOperatorPermission() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled_no_perms", (Object[])new Object[0]) : (RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0])));
                return Optional.ofNullable(tooltips);
            }

            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }
        });
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().showUtilsButtons) {
            this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.method_4486() - 55 : 35, 10, 20, 20, ""){

                @Override
                public void onPressed() {
                    class_310.method_1551().field_1724.method_3142(RoughlyEnoughItemsCore.getConfigManager().getConfig().gamemodeCommand.replaceAll("\\{gamemode}", ContainerScreenOverlay.this.getNextGameMode().method_8381()));
                }

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    this.text = ContainerScreenOverlay.this.getGameModeShortText(ContainerScreenOverlay.this.getCurrentGameMode());
                    super.render(mouseX, mouseY, delta);
                }

                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662((String)"text.rei.gamemode_button.tooltip", (Object[])new Object[]{ContainerScreenOverlay.this.getGameModeText(ContainerScreenOverlay.this.getNextGameMode())}));
                }

                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
            int xxx = RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? this.window.method_4486() - 30 : 10;
            for (final Weather weather : Weather.values()) {
                this.widgets.add(new ButtonWidget(xxx, 35, 20, 20, ""){

                    @Override
                    public void onPressed() {
                        class_310.method_1551().field_1724.method_3142(RoughlyEnoughItemsCore.getConfigManager().getConfig().weatherCommand.replaceAll("\\{weather}", weather.name().toLowerCase()));
                    }

                    @Override
                    public void render(int mouseX, int mouseY, float delta) {
                        super.render(mouseX, mouseY, delta);
                        class_308.method_1450();
                        class_310.method_1551().method_1531().method_4618(CHEST_GUI_TEXTURE);
                        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.blit(this.getBounds().x + 3, this.getBounds().y + 3, weather.getId() * 14, 14, 14, 14);
                    }

                    @Override
                    public Optional<String> getTooltips() {
                        return Optional.ofNullable(class_1074.method_4662((String)"text.rei.weather_button.tooltip", (Object[])new Object[]{class_1074.method_4662((String)weather.getTranslateKey(), (Object[])new Object[0])}));
                    }

                    @Override
                    public boolean changeFocus(boolean boolean_1) {
                        return false;
                    }
                });
                xxx += RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel ? -25 : 25;
            }
        }
        this.widgets.add(new ClickableLabelWidget(this.rectangle.x + this.rectangle.width / 2, this.rectangle.y + 10, "", this.getTotalPage() > 0){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                page = class_3532.method_15340((int)page, (int)0, (int)ContainerScreenOverlay.this.getTotalPage());
                this.text = String.format("%s/%s", page + 1, ContainerScreenOverlay.this.getTotalPage() + 1);
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.go_back_first_page", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                page = 0;
                itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
            }

            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }
        });
        this.buttonRight.enabled = this.getTotalPage() > 0;
        this.buttonLeft.enabled = this.buttonRight.enabled;
        if (ScreenHelper.searchField == null) {
            ScreenHelper.searchField = new SearchFieldWidget(0, 0, 0, 0);
        }
        ScreenHelper.searchField.getBounds().setBounds(this.getTextFieldArea());
        this.widgets.add(ScreenHelper.searchField);
        ScreenHelper.searchField.setText(searchTerm);
        ScreenHelper.searchField.setChangedListener(s -> {
            searchTerm = s;
            itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, true);
        });
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton) {
            this.toggleButtonWidget = new CraftableToggleButtonWidget(this.getCraftableToggleArea()){

                @Override
                public void onPressed() {
                    RoughlyEnoughItemsCore.getConfigManager().toggleCraftableOnly();
                    itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, true);
                }

                @Override
                public void lateRender(int mouseX, int mouseY, float delta) {
                    this.blitOffset = 300;
                    super.lateRender(mouseX, mouseY, delta);
                }
            };
            this.widgets.add(this.toggleButtonWidget);
        } else {
            this.toggleButtonWidget = null;
        }
        itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, false);
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546()) {
            return Weather.THUNDER;
        }
        if (world.method_8401().method_156()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662((String)("text.rei.short_gamemode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662((String)("selectWorld.gameMode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private class_1934 getNextGameMode() {
        try {
            class_1934 current = this.getCurrentGameMode();
            int next = current.method_8379() + 1;
            if (next > 3) {
                next = 0;
            }
            return class_1934.method_8384((int)next);
        }
        catch (Exception e) {
            return class_1934.field_9218;
        }
    }

    private class_1934 getCurrentGameMode() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId()).method_2958();
    }

    private Rectangle getTextFieldArea() {
        int widthRemoved;
        int n = widthRemoved = RoughlyEnoughItemsCore.getConfigManager().getConfig().enableCraftableOnlyButton ? 22 : 2;
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().sideSearchField) {
            return new Rectangle(this.rectangle.x + 2, this.window.method_4502() - 22, this.rectangle.width - 6 - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, this.window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.bounds.x, this.window.method_4502() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft(), this.window.method_4502() - 22, ScreenHelper.getLastContainerScreenHooks().rei_getContainerWidth() - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle searchBoxArea = this.getTextFieldArea();
        searchBoxArea.setLocation(searchBoxArea.x + searchBoxArea.width + 4, searchBoxArea.y - 1);
        searchBoxArea.setSize(20, 20);
        return searchBoxArea;
    }

    private String getCheatModeText() {
        return class_1074.method_4662((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void render(int mouseX, int mouseY, float delta) {
        List<class_1799> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler() != null && RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler().shouldRecalculateArea(!RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel, this.rectangle)) {
            this.shouldReInit = true;
        }
        if (this.shouldReInit) {
            this.init(true);
        } else if (RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() && (!this.hasSameListContent(new LinkedList<class_1799>(ScreenHelper.inventoryStacks), currentStacks) || currentStacks.size() != ScreenHelper.inventoryStacks.size())) {
            ScreenHelper.inventoryStacks = ClientHelper.getInstance().getInventoryItemsTypes();
            DisplayHelper.DisplayBoundsHandler boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
            itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, true);
        }
        if (class_310.method_1551().field_1755 instanceof class_465 && SearchFieldWidget.isSearching) {
            class_308.method_1450();
            this.blitOffset = 200;
            ContainerScreenHooks hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
            int left = hooks.rei_getContainerLeft();
            int top = hooks.rei_getContainerTop();
            for (class_1735 slot : ((class_465)class_310.method_1551().field_1755).method_17577().field_7761) {
                if (slot.method_7681()) {
                    if (ItemListOverlay.filterItem(slot.method_7677(), itemListOverlay.getLastSearchArgument())) continue;
                }
                this.fillGradient(left + slot.field_7873, top + slot.field_7872, left + slot.field_7873 + 16, top + slot.field_7872 + 16, -601874400, -601874400);
            }
            this.blitOffset = 0;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_1450();
        this.renderWidgets(mouseX, mouseY, delta);
    }

    public void lateRender(int mouseX, int mouseY, float delta) {
        class_437 currentScreen;
        ScreenHelper.searchField.laterRender(mouseX, mouseY, delta);
        if (this.toggleButtonWidget != null) {
            this.toggleButtonWidget.lateRender(mouseX, mouseY, delta);
        }
        if (!((currentScreen = class_310.method_1551().field_1755) instanceof RecipeViewingScreen) || !((RecipeViewingScreen)currentScreen).choosePageActivated) {
            QUEUED_TOOLTIPS.stream().filter(Objects::nonNull).forEach(this::renderTooltip);
        }
        QUEUED_TOOLTIPS.clear();
    }

    public void renderTooltip(QueuedTooltip tooltip) {
        if (tooltip.getConsumer() == null) {
            this.renderTooltip(tooltip.getText(), tooltip.getX(), tooltip.getY());
        } else {
            tooltip.getConsumer().accept(tooltip);
        }
    }

    public void renderTooltip(List<String> lines, int mouseX, int mouseY) {
        if (lines.isEmpty()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        int width = lines.stream().map(arg_0 -> ((class_327)font).method_1727(arg_0)).max(Integer::compareTo).get();
        int height = lines.size() <= 1 ? 8 : lines.size() * 10;
        ScreenHelper.drawHoveringWidget(mouseX, mouseY, (TriConsumer<Integer, Integer, Float>)((TriConsumer)(x, y, aFloat) -> {
            GlStateManager.disableRescaleNormal();
            class_308.method_1450();
            GlStateManager.disableLighting();
            this.blitOffset = 1000;
            this.fillGradient(x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864);
            this.fillGradient(x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864);
            this.fillGradient(x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864);
            this.fillGradient(x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864);
            this.fillGradient(x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864);
            this.fillGradient(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 0x505000FF, 1344798847);
            this.fillGradient(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 0x505000FF, 1344798847);
            this.fillGradient(x - 3, y - 3, x + width + 3, y - 3 + 1, 0x505000FF, 0x505000FF);
            this.fillGradient(x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847);
            int currentY = y;
            for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
                GlStateManager.disableDepthTest();
                font.method_1720((String)lines.get(lineIndex), (float)x.intValue(), (float)currentY, -1);
                GlStateManager.enableDepthTest();
                currentY += lineIndex == 0 ? 12 : 10;
            }
            this.blitOffset = 0;
            GlStateManager.enableLighting();
            class_308.method_1452();
            GlStateManager.enableRescaleNormal();
        }), width, height, 0.0f);
    }

    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        list1.sort((itemStack, t1) -> ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1)));
        list2.sort((itemStack, t1) -> ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1)));
        return list1.stream().map(ItemListOverlay::tryGetItemStackName).collect(Collectors.joining("")).equals(list2.stream().map(ItemListOverlay::tryGetItemStackName).collect(Collectors.joining("")));
    }

    public void addTooltip(QueuedTooltip queuedTooltip) {
        QUEUED_TOOLTIPS.add(queuedTooltip);
    }

    public void renderWidgets(int int_1, int int_2, float float_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return;
        }
        this.buttonRight.enabled = this.getTotalPage() > 0;
        this.buttonLeft.enabled = this.buttonRight.enabled;
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(int_1, int_2, float_1);
        });
        class_308.method_1450();
    }

    private int getTotalPage() {
        return itemListOverlay.getTotalPage();
    }

    public boolean mouseScrolled(double i, double j, double amount) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (this.isInside(ClientUtils.getMouseLocation())) {
            if (amount > 0.0 && this.buttonLeft.enabled) {
                this.buttonLeft.onPressed();
            } else if (amount < 0.0 && this.buttonRight.enabled) {
                this.buttonRight.onPressed();
            } else {
                return false;
            }
            return true;
        }
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(i, j, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible()) {
            for (class_364 class_3642 : this.widgets) {
                if (!class_3642.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        if (ClientHelper.getInstance().getHideKeyBinding().method_1417(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        class_1799 itemStack = null;
        if (class_310.method_1551().field_1755 instanceof class_465 && ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot() != null && !ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677().method_7960()) {
            itemStack = ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677();
        }
        if (itemStack != null && !itemStack.method_7960()) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            }
            if (ClientHelper.getInstance().getUsageKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
            }
        }
        return false;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.charTyped(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public List<? extends class_364> children() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.mouseClicked(double_1, double_2, int_1)) continue;
            this.setFocused(class_3642);
            if (int_1 == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean isInside(double mouseX, double mouseY) {
        if (!this.rectangle.contains(mouseX, mouseY)) {
            return false;
        }
        for (DisplayHelper.DisplayBoundsHandler handler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(class_310.method_1551().field_1755.getClass())) {
            class_1269 in = handler.isInZone(!RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel, mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }
}

