/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3611;

public interface EntryRegistry {
    
    /**
     * Gets the current unmodifiable item list
     *
     * @return an unmodifiable item list
     */
    List<Entry> getEntryList();
    
    /**
     * Gets the current modifiable item list
     *
     * @return an modifiable item list
     */
    @Deprecated
    List<Entry> getModifiableEntryList();
    
    /**
     * Gets all possible stacks from an item
     *
     * @param item the item to find
     * @return the array of possible stacks
     */
    class_1799[] getAllStacksFromItem(class_1792 item);
    
    /**
     * Registers an new stack to the item list
     *
     * @param afterItem the stack to put after
     * @param stack     the stack to register
     */
    void registerItemStack(class_1792 afterItem, class_1799 stack);
    
    void registerFluid(class_3611 fluid);
    
    /**
     * Registers multiple stacks to the item list
     *
     * @param afterItem the stack to put after
     * @param stacks    the stacks to register
     */
    default void registerItemStack(class_1792 afterItem, class_1799... stacks) {
        for (int i = stacks.length - 1; i >= 0; i--) {
            class_1799 stack = stacks[i];
            if (stack != null && !stack.method_7960())
                registerItemStack(afterItem, stack);
        }
    }
    
    /**
     * Registers multiple stacks to the item list
     *
     * @param stacks the stacks to register
     */
    default void registerItemStack(class_1799... stacks) {
        registerItemStack(null, stacks);
    }
    
    /**
     * Checks if a stack is already registered
     *
     * @param stack the stack to check
     * @return whether the stack has been registered
     */
    default boolean alreadyContain(class_1799 stack) {
        return getEntryList().stream().filter(entry -> entry.getEntryType() == Entry.Type.ITEM).anyMatch(entry -> class_1799.method_7973(stack, entry.getItemStack()));
    }
    
}
