/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.crafting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2960;

public class DefaultShapelessDisplay implements DefaultCraftingDisplay {
    
    private class_1867 display;
    private List<List<class_1799>> input;
    private List<class_1799> output;
    
    public DefaultShapelessDisplay(class_1867 recipe) {
        this.display = recipe;
        this.input = recipe.method_8117().stream().map(i -> Arrays.asList(i.method_8105())).collect(Collectors.toList());
        this.output = Collections.singletonList(recipe.method_8110());
    }
    
    @Override
    public Optional<class_1860<?>> getOptionalRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(display).map(class_1867::method_8114);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return input;
    }
    
    @Override
    public List<class_1799> getOutput() {
        return output;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return input;
    }
    
    @Override
    public int getWidth() {
        if (display.method_8117().size() > 4)
            return 3;
        return 2;
    }
    
    @Override
    public int getHeight() {
        if (display.method_8117().size() > 4)
            return 3;
        return 2;
    }
    
}
