/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import me.shedaniel.cloth.hooks.ClothClientHooks;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.SearchFieldWidget;
import me.shedaniel.rei.listeners.ContainerScreenHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.apache.logging.log4j.util.TriConsumer;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;

public class ScreenHelper implements ClientModInitializer {
    
    public static SearchFieldWidget searchField;
    public static List<class_1799> inventoryStacks = Lists.newArrayList();
    private static boolean overlayVisible = true;
    private static ContainerScreenOverlay overlay;
    private static class_465<?> lastContainerScreen = null;
    private static LinkedHashSet<class_437> lastRecipeScreen = Sets.newLinkedHashSetWithExpectedSize(5);
    
    public static void storeRecipeScreen(class_437 screen) {
        while (lastRecipeScreen.size() >= 5)
            lastRecipeScreen.remove(Iterables.get(lastRecipeScreen, 0));
        lastRecipeScreen.add(screen);
    }
    
    public static boolean hasLastRecipeScreen() {
        return !lastRecipeScreen.isEmpty();
    }
    
    public static class_437 getLastRecipeScreen() {
        class_437 screen = Iterables.getLast(lastRecipeScreen);
        lastRecipeScreen.remove(screen);
        return screen;
    }
    
    public static void clearData() {
        lastRecipeScreen.clear();
    }
    
    public static boolean isOverlayVisible() {
        return overlayVisible;
    }
    
    public static void toggleOverlayVisible() {
        overlayVisible = !overlayVisible;
    }
    
    public static Optional<ContainerScreenOverlay> getOptionalOverlay() {
        return Optional.ofNullable(overlay);
    }
    
    public static ContainerScreenOverlay getLastOverlay(boolean reset, boolean setPage) {
        if (overlay == null || reset) {
            overlay = new ContainerScreenOverlay();
            overlay.init(setPage);
        }
        return overlay;
    }
    
    public static ContainerScreenOverlay getLastOverlay() {
        return getLastOverlay(false, false);
    }
    
    public static class_465<?> getLastContainerScreen() {
        return lastContainerScreen;
    }
    
    public static void setLastContainerScreen(class_465<?> lastContainerScreen) {
        ScreenHelper.lastContainerScreen = lastContainerScreen;
    }
    
    public static ContainerScreenHooks getLastContainerScreenHooks() {
        return (ContainerScreenHooks) lastContainerScreen;
    }
    
    public static void drawHoveringWidget(int x, int y, TriConsumer<Integer, Integer, Float> consumer, int width, int height, float delta) {
        class_1041 window = class_310.method_1551().field_1704;
        drawHoveringWidget(window.method_4486(), window.method_4502(), x, y, consumer, width, height, delta);
    }
    
    public static void drawHoveringWidget(int screenWidth, int screenHeight, int x, int y, TriConsumer<Integer, Integer, Float> consumer, int width, int height, float delta) {
        int actualX = Math.max(x + 12, 6);
        int actualY = Math.min(y - height / 2, screenHeight - height - 6);
        if (actualX + width > screenWidth)
            actualX -= 24 + width;
        if (actualY < 6)
            actualY += 24;
        consumer.accept(actualX, actualY, delta);
    }
    
    public static boolean isDarkModeEnabled() {
        return RoughlyEnoughItemsCore.getConfigManager().getConfig().isUsingDarkTheme();
    }
    
    @Override
    public void onInitializeClient() {
        ClothClientHooks.SCREEN_INIT_PRE.register((client, screen, screenHooks) -> {
            if (lastContainerScreen != screen && screen instanceof class_465)
                lastContainerScreen = (class_465<?>) screen;
            return class_1269.field_5811;
        });
        ClientTickCallback.EVENT.register(minecraftClient -> {
            if (isOverlayVisible() && searchField != null)
                searchField.method_16896();
        });
    }
    
}
