/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.brewing;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DefaultBrewingDisplay implements RecipeDisplay {
    
    private class_1799 input, output;
    private class_1856 reactant;
    
    public DefaultBrewingDisplay(class_1799 input, class_1856 reactant, class_1799 output) {
        this.input = input;
        this.reactant = reactant;
        this.output = output;
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return Lists.newArrayList(Collections.singletonList(input), Arrays.asList(reactant.method_8105()));
    }
    
    @Override
    public List<class_1799> getOutput() {
        return Collections.singletonList(output);
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.BREWING;
    }
    
    public List<class_1799> getOutput(int slot) {
        List<class_1799> stack = new ArrayList<>();
        for (int i = 0; i < slot * 2; i++)
            stack.add(new class_1799(class_2246.field_10124));
        for (int i = 0; i < 6 - slot * 2; i++)
            stack.addAll(getOutput());
        return stack;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return Collections.singletonList(Collections.singletonList(class_1799.field_8037));
    }
}
