/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.server;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class InputSlotCrafter<C extends class_1263> implements RecipeGridAligner<Integer> {
    
    protected class_1703 craftingContainer;
    protected ContainerInfo containerInfo;
    protected class_1661 inventory;
    
    private InputSlotCrafter(class_1703 craftingContainer, ContainerInfo containerInfo) {
        this.craftingContainer = craftingContainer;
        this.containerInfo = containerInfo;
    }
    
    public static <C extends class_1263> void start(class_2960 category, class_1703 craftingContainer_1, class_3222 player, Map<Integer, List<class_1799>> map, boolean hasShift) {
        ContainerInfo containerInfo = ContainerInfoHandler.getContainerInfo(category, craftingContainer_1.getClass());
        new InputSlotCrafter<C>(craftingContainer_1, containerInfo).fillInputSlots(player, map, hasShift);
    }
    
    private void fillInputSlots(class_3222 player, Map<Integer, List<class_1799>> map, boolean hasShift) {
        this.inventory = player.field_7514;
        if (this.canReturnInputs() || player.method_7337()) {
            // Return the already placed items on the grid
            this.returnInputs();
            
            RecipeFinder recipeFinder = new RecipeFinder();
            recipeFinder.clear();
            for (class_1799 stack : player.field_7514.field_7547) {
                recipeFinder.addNormalItem(stack);
            }
            this.containerInfo.populateRecipeFinder(craftingContainer, recipeFinder);
            class_2371<class_1856> ingredients = class_2371.method_10211();
            map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).forEach(entry -> {
                ingredients.add(class_1856.method_8091(entry.getValue().stream().map(class_1799::method_7909).collect(Collectors.toList()).toArray(new class_1792[0])));
            });
            if (recipeFinder.findRecipe(ingredients, (IntList) null)) {
                this.fillInputSlots(recipeFinder, ingredients, hasShift);
            } else {
                this.returnInputs();
                craftingContainer.method_7623();
                throw new NullPointerException();
            }
            
            craftingContainer.method_7623();
        }
    }
    
    @Override
    public void acceptAlignedInput(Iterator<Integer> iterator_1, int int_1, int int_2, int int_3, int int_4) {
        class_1735 slot_1 = this.craftingContainer.method_7611(int_1);
        class_1799 itemStack_1 = net.minecraft.class_1662.method_7405((Integer) iterator_1.next());
        if (!itemStack_1.method_7960()) {
            for (int int_5 = 0; int_5 < int_2; ++int_5) {
                this.fillInputSlot(slot_1, itemStack_1);
            }
        }
    }
    
    protected void fillInputSlot(class_1735 slot_1, class_1799 itemStack_1) {
        int int_1 = this.inventory.method_7371(itemStack_1);
        if (int_1 != -1) {
            class_1799 itemStack_2 = this.inventory.method_5438(int_1).method_7972();
            if (!itemStack_2.method_7960()) {
                if (itemStack_2.method_7947() > 1) {
                    this.inventory.method_5434(int_1, 1);
                } else {
                    this.inventory.method_5441(int_1);
                }
                
                itemStack_2.method_7939(1);
                if (slot_1.method_7677().method_7960()) {
                    slot_1.method_7673(itemStack_2);
                } else {
                    slot_1.method_7677().method_7933(1);
                }
                
            }
        }
    }
    
    @SuppressWarnings("deprecation")
    protected void fillInputSlots(RecipeFinder recipeFinder, class_2371<class_1856> ingredients, boolean hasShift) {
        //        boolean boolean_2 = this.craftingContainer.matches(recipe_1);
        boolean boolean_2 = false;
        int int_1 = recipeFinder.countRecipeCrafts(ingredients, (IntList) null);
        int int_2;
        if (boolean_2) {
            for (int_2 = 0; int_2 < this.containerInfo.getCraftingHeight(craftingContainer) * this.containerInfo.getCraftingWidth(craftingContainer) + 1; ++int_2) {
                if (int_2 != this.containerInfo.getCraftingResultSlotIndex(craftingContainer)) {
                    class_1799 itemStack_1 = this.craftingContainer.method_7611(int_2).method_7677();
                    if (!itemStack_1.method_7960() && Math.min(int_1, itemStack_1.method_7914()) < itemStack_1.method_7947() + 1) {
                        return;
                    }
                }
            }
        }
        
        int_2 = this.getAmountToFill(hasShift, int_1, boolean_2);
        IntList intList_1 = new IntArrayList();
        if (recipeFinder.findRecipe(ingredients, intList_1, int_2)) {
            int int_4 = int_2;
            IntListIterator var8 = intList_1.iterator();
            
            while (var8.hasNext()) {
                int int_5 = (Integer) var8.next();
                int int_6 = RecipeFinder.getStackFromId(int_5).method_7914();
                if (int_6 < int_4) {
                    int_4 = int_6;
                }
            }
            
            if (recipeFinder.findRecipe(ingredients, intList_1, int_4)) {
                this.returnInputs();
                this.alignRecipeToGrid(this.containerInfo.getCraftingWidth(craftingContainer), this.containerInfo.getCraftingHeight(craftingContainer), this.containerInfo.getCraftingResultSlotIndex(craftingContainer), ingredients, intList_1.iterator(), int_4);
            }
        }
        
    }
    
    protected int getAmountToFill(boolean hasShift, int int_1, boolean boolean_2) {
        int int_2 = 1;
        if (hasShift) {
            int_2 = int_1;
        } else if (boolean_2) {
            int_2 = 64;
            for (int int_3 = 0; int_3 < this.containerInfo.getCraftingWidth(craftingContainer) * this.containerInfo.getCraftingHeight(craftingContainer) + 1; ++int_3) {
                if (int_3 != this.containerInfo.getCraftingResultSlotIndex(craftingContainer)) {
                    class_1799 itemStack_1 = this.craftingContainer.method_7611(int_3).method_7677();
                    if (!itemStack_1.method_7960() && int_2 > itemStack_1.method_7947()) {
                        int_2 = itemStack_1.method_7947();
                    }
                }
            }
            if (int_2 < 64) {
                ++int_2;
            }
        }
        return int_2;
    }
    
    protected void returnInputs() {
        for (int int_1 = 0; int_1 < this.containerInfo.getCraftingWidth(craftingContainer) * this.containerInfo.getCraftingHeight(craftingContainer) + 1; ++int_1) {
            if (int_1 != this.containerInfo.getCraftingResultSlotIndex(craftingContainer)) {
                this.returnSlot(int_1);
            }
        }
        
        this.containerInfo.clearCraftingSlots(craftingContainer);
    }
    
    protected void returnSlot(int int_1) {
        class_1799 itemStack_1 = this.craftingContainer.method_7611(int_1).method_7677();
        if (!itemStack_1.method_7960()) {
            for (; itemStack_1.method_7947() > 0; this.craftingContainer.method_7611(int_1).method_7671(1)) {
                int int_2 = this.inventory.method_7390(itemStack_1);
                if (int_2 == -1) {
                    int_2 = this.inventory.method_7376();
                }
                
                class_1799 itemStack_2 = itemStack_1.method_7972();
                itemStack_2.method_7939(1);
                if (!this.inventory.method_7367(int_2, itemStack_2)) {
                    throw new IllegalStateException("rei.rei.no.slot.in.inv");
                }
            }
        }
    }
    
    private boolean canReturnInputs() {
        List<class_1799> list_1 = Lists.newArrayList();
        int int_1 = this.getFreeInventorySlots();
        
        for (int int_2 = 0; int_2 < this.containerInfo.getCraftingWidth(craftingContainer) * this.containerInfo.getCraftingHeight(craftingContainer) + 1; ++int_2) {
            if (int_2 != this.containerInfo.getCraftingResultSlotIndex(craftingContainer)) {
                class_1799 itemStack_1 = this.craftingContainer.method_7611(int_2).method_7677().method_7972();
                if (!itemStack_1.method_7960()) {
                    int int_3 = this.inventory.method_7390(itemStack_1);
                    if (int_3 == -1 && list_1.size() <= int_1) {
                        Iterator var6 = list_1.iterator();
                        
                        while (var6.hasNext()) {
                            class_1799 itemStack_2 = (class_1799) var6.next();
                            if (itemStack_2.method_7962(itemStack_1) && itemStack_2.method_7947() != itemStack_2.method_7914() && itemStack_2.method_7947() + itemStack_1.method_7947() <= itemStack_2.method_7914()) {
                                itemStack_2.method_7933(itemStack_1.method_7947());
                                itemStack_1.method_7939(0);
                                break;
                            }
                        }
                        
                        if (!itemStack_1.method_7960()) {
                            if (list_1.size() >= int_1) {
                                return false;
                            }
                            
                            list_1.add(itemStack_1);
                        }
                    } else if (int_3 == -1) {
                        return false;
                    }
                }
            }
        }
        
        return true;
    }
    
    private int getFreeInventorySlots() {
        int int_1 = 0;
        Iterator var2 = this.inventory.field_7547.iterator();
        while (var2.hasNext()) {
            class_1799 itemStack_1 = (class_1799) var2.next();
            if (itemStack_1.method_7960()) {
                ++int_1;
            }
        }
        return int_1;
    }
    
}
