/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.rei.gui.renderers.EmptyRenderer;
import me.shedaniel.rei.gui.renderers.FluidRenderer;
import me.shedaniel.rei.gui.renderers.ItemStackRenderer;
import me.shedaniel.rei.gui.renderers.SimpleRecipeRenderer;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3611;

public abstract class Renderer
extends class_332 {
    public static ItemStackRenderer fromItemStackSupplier(Supplier<class_1799> supplier) {
        return Renderer.fromItemStacks(() -> Collections.singletonList(supplier.get()), true, null);
    }

    public static ItemStackRenderer fromItemStackSupplierNoCounts(Supplier<class_1799> supplier) {
        return Renderer.fromItemStacks(() -> Collections.singletonList(supplier.get()), false, null);
    }

    public static ItemStackRenderer fromItemStack(class_1799 stack) {
        return Renderer.fromItemStacks(() -> Collections.singletonList(stack), true, null);
    }

    public static FluidRenderer fromFluid(class_3611 fluid) {
        return Renderer.fromFluid(() -> fluid, null);
    }

    public static FluidRenderer fromFluid(final Supplier<class_3611> fluidSupplier, final @Nullable Function<class_3611, List<String>> extraTooltipSupplier) {
        return new FluidRenderer(){

            @Override
            public class_3611 getFluid() {
                return (class_3611)fluidSupplier.get();
            }

            @Override
            protected List<String> getExtraToolTips(class_3611 fluid) {
                if (extraTooltipSupplier == null) {
                    return super.getExtraToolTips(fluid);
                }
                List apply = (List)extraTooltipSupplier.apply(fluid);
                if (apply == null) {
                    return super.getExtraToolTips(fluid);
                }
                return apply;
            }
        };
    }

    public static ItemStackRenderer fromItemStackNoCounts(class_1799 stack) {
        return Renderer.fromItemStacks(() -> Collections.singletonList(stack), false, null);
    }

    public static EmptyRenderer empty() {
        return EmptyRenderer.INSTANCE;
    }

    public static SimpleRecipeRenderer fromRecipe(Supplier<List<List<class_1799>>> input, Supplier<List<class_1799>> output) {
        return new SimpleRecipeRenderer(input, output);
    }

    public static ItemStackRenderer fromItemStacks(List<class_1799> stacks) {
        return Renderer.fromItemStacks(() -> stacks, true, null);
    }

    public static ItemStackRenderer fromItemStacks(Supplier<List<class_1799>> stacksSupplier, boolean renderCounts, @Nullable Function<class_1799, List<String>> extraTooltipSupplier) {
        return Renderer.fromItemStacks(stacksSupplier, stack -> renderCounts ? null : "", extraTooltipSupplier);
    }

    public static ItemStackRenderer fromItemStacks(final Supplier<List<class_1799>> stacksSupplier, final Function<class_1799, String> countsFunction, final @Nullable Function<class_1799, List<String>> extraTooltipSupplier) {
        return new ItemStackRenderer(){

            @Override
            public class_1799 getItemStack() {
                if (((List)stacksSupplier.get()).isEmpty()) {
                    return class_1799.field_8037;
                }
                return (class_1799)((List)stacksSupplier.get()).get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)((List)stacksSupplier.get()).size() / 1.0)));
            }

            @Override
            protected String getCounts() {
                return (String)countsFunction.apply(this.getItemStack());
            }

            @Override
            protected List<String> getExtraToolTips(class_1799 stack) {
                if (extraTooltipSupplier == null) {
                    return super.getExtraToolTips(stack);
                }
                List apply = (List)extraTooltipSupplier.apply(stack);
                if (apply == null) {
                    return super.getExtraToolTips(stack);
                }
                return apply;
            }
        };
    }

    public static ItemStackRenderer fromItemStacksNoCounts(List<class_1799> stacks) {
        return Renderer.fromItemStacks(() -> stacks, false, null);
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public void setBlitOffset(int offset) {
        this.blitOffset = offset;
    }

    public abstract void render(int var1, int var2, double var3, double var5, float var7);

    @Nullable
    public QueuedTooltip getQueuedTooltip(float delta) {
        return null;
    }
}

