/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.renderers;

import com.google.common.collect.Lists;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.ScreenHelper;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3528;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;

public abstract class FluidRenderer extends Renderer {
    /**
     * @deprecated This boolean is no longer used
     */
    @Deprecated
    public boolean drawTooltip = false;
    public class_3528<class_3545<class_1058, Integer>> sprite = new class_3528<>(() -> {
        try {
            FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(getFluid());
            if (fluidRenderHandler == null)
                return null;
            class_1058[] sprites = fluidRenderHandler.getFluidSprites(class_310.method_1551().field_1687, class_310.method_1551().field_1687 == null ? null : class_2338.field_10980, getFluid().method_15785());
            int color = -1;
            if (class_310.method_1551().field_1687 != null)
                color = fluidRenderHandler.getFluidColor(class_310.method_1551().field_1687, class_2338.field_10980, getFluid().method_15785());
            return new class_3545<>(sprites[0], color);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    });
    
    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        x = x - 8;
        y = y - 6;
        class_3545<class_1058, Integer> pair = this.sprite.method_15332();
        if (pair != null) {
            class_1058 sprite = pair.method_15442();
            Integer int_5 = pair.method_15441();
            int a = 255;
            int r = (int_5 >> 16 & 255);
            int g = (int_5 >> 8 & 255);
            int b = (int_5 & 255);
            class_310.method_1551().method_1531().method_4618(class_1059.field_5275);
            class_308.method_1450();
            class_289 tess = class_289.method_1348();
            class_287 bb = tess.method_1349();
            bb.method_1328(7, class_290.field_1575);
            bb.method_1315(x + 16, y, blitOffset).method_1312(sprite.method_4577(), sprite.method_4593()).method_1323(r, g, b, a).method_1344();
            bb.method_1315(x, y, blitOffset).method_1312(sprite.method_4594(), sprite.method_4593()).method_1323(r, g, b, a).method_1344();
            bb.method_1315(x, y + 16, blitOffset).method_1312(sprite.method_4594(), sprite.method_4575()).method_1323(r, g, b, a).method_1344();
            bb.method_1315(x + 16, y + 16, blitOffset).method_1312(sprite.method_4577(), sprite.method_4575()).method_1323(r, g, b, a).method_1344();
            tess.method_1350();
        }
        this.blitOffset = 0;
    }
    
    @Nullable
    @Override
    public QueuedTooltip getQueuedTooltip(float delta) {
        return QueuedTooltip.create(getTooltip(getFluid()));
    }
    
    /**
     * Queue a tooltip to the REI overlay
     *
     * @param fluid the fluid to queue
     * @param delta the delta
     * @deprecated Use {@link Renderer#getQueuedTooltip(float)} instead and queue manually
     */
    @Deprecated
    protected void queueTooltip(class_3611 fluid, float delta) {
        ScreenHelper.getLastOverlay().addTooltip(getQueuedTooltip(delta));
    }
    
    protected List<String> getTooltip(class_3611 fluid) {
        List<String> toolTip = Lists.newArrayList(EntryListWidget.tryGetFluidName(fluid));
        toolTip.addAll(getExtraToolTips(fluid));
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().shouldAppendModNames()) {
            final String modString = ClientHelper.getInstance().getFormattedModFromIdentifier(class_2378.field_11154.method_10221(fluid));
            boolean alreadyHasMod = false;
            for (String s : toolTip)
                if (s.equalsIgnoreCase(modString)) {
                    alreadyHasMod = true;
                    break;
                }
            if (!alreadyHasMod)
                toolTip.add(modString);
        }
        return toolTip;
    }
    
    protected List<String> getExtraToolTips(class_3611 fluid) {
        return Collections.emptyList();
    }
    
    public abstract class_3611 getFluid();
}
