/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.renderers.RecipeRenderer;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public interface RecipeCategory<T extends RecipeDisplay> {
    public class_2960 getIdentifier();

    public Renderer getIcon();

    public String getCategoryName();

    default public RecipeRenderer getSimpleRenderer(T recipe) {
        return Renderer.fromRecipe(() -> recipe.getInput(), () -> recipe.getOutput());
    }

    default public List<Widget> setupDisplay(Supplier<T> recipeDisplaySupplier, Rectangle bounds) {
        return Collections.singletonList(new RecipeBaseWidget(bounds));
    }

    default public void drawCategoryBackground(Rectangle bounds, int mouseX, int mouseY, float delta) {
        new CategoryBaseWidget(bounds).render();
        if (ScreenHelper.isDarkModeEnabled()) {
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)-12566464);
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 21), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 33), (int)-12566464);
        } else {
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)-6381922);
            class_332.fill((int)(bounds.x + 17), (int)(bounds.y + 21), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 33), (int)-6381922);
        }
    }

    default public int getDisplayHeight() {
        return 66;
    }

    default public int getDisplayWidth(T display) {
        return 150;
    }

    default public int getMaximumRecipePerPage() {
        return 99;
    }

    @Deprecated
    default public int getFixedRecipesPerPage() {
        return -1;
    }

    default public boolean checkTags() {
        return false;
    }
}

