/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zeitheron.hammercore.client.utils.Scissors;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.compat.RenderHelper;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.renderers.RecipeRenderer;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class VillagerRecipeViewingScreen
extends class_437 {
    private static final int TABS_PER_PAGE = 8;
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap;
    private final List<RecipeCategory<?>> categories;
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<ButtonWidget> buttonWidgets;
    private final List<Renderer> recipeRenderers;
    private final List<TabWidget> tabs;
    public Rectangle bounds;
    public Rectangle scrollListBounds;
    private int selectedCategoryIndex = 0;
    private int selectedRecipeIndex = 0;
    private double scroll = 0.0;
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private boolean draggingScrollBar = false;
    private int tabsPage = 0;

    public VillagerRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        super((class_2561)new class_2585(""));
        this.categoryMap = Maps.newLinkedHashMap();
        this.categories = Lists.newArrayList();
        this.buttonWidgets = Lists.newArrayList();
        this.tabs = Lists.newArrayList();
        this.recipeRenderers = Lists.newArrayList();
        RecipeHelper.getInstance().getAllCategories().forEach(category -> {
            if (map.containsKey(category)) {
                this.categories.add((RecipeCategory<?>)category);
                this.categoryMap.put((RecipeCategory<?>)category, (List<RecipeDisplay>)map.get(category));
            }
        });
    }

    protected void init() {
        super.init();
        this.draggingScrollBar = false;
        this.children.clear();
        this.widgets.clear();
        this.buttonWidgets.clear();
        this.recipeRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.width - 100;
        int largestHeight = this.height - 40;
        RecipeCategory<?> category = this.categories.get(this.selectedCategoryIndex);
        RecipeDisplay display = this.categoryMap.get(category).get(this.selectedRecipeIndex);
        int guiWidth = class_3532.method_15340((int)(category.getDisplayWidth(display) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = class_3532.method_15340((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.bounds = new Rectangle(this.width / 2 - guiWidth / 2, this.height / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<List<class_1799>> workingStations = RoughlyEnoughItemsCore.getRecipeHelper().getWorkingStations(category.getIdentifier());
        if (!workingStations.isEmpty()) {
            int ww = class_3532.method_15375((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workingStations.size());
            int h = class_3532.method_15386((float)((float)workingStations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 5;
            this.widgets.add(new CategoryBaseWidget(new Rectangle(xx - 6, this.bounds.y + this.bounds.height - 5, 11 + w * 18, 15 + h * 18)));
            int index = 0;
            List<String> list = Collections.singletonList(class_124.field_1054.toString() + class_1074.method_4662((String)"text.rei.working_station", (Object[])new Object[0]));
            for (List<class_1799> workingStation : workingStations) {
                this.widgets.add(new SlotWidget(xx, yy, Renderer.fromItemStacks(() -> workingStation, true, stack -> list), true, true, true));
                xx += 18;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 18;
            }
        }
        this.widgets.add(new CategoryBaseWidget(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(new SlotBaseWidget(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display), category.getDisplayHeight());
        List<Widget> setupDisplay = category.setupDisplay(() -> display, recipeBounds);
        this.widgets.addAll(setupDisplay);
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getAutoCraftButtonArea(category);
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(new AutoCraftingButtonWidget(recipeBounds, supplier.get().get(recipeBounds), supplier.get().getButtonText(), () -> display, setupDisplay, category));
        }
        int index = 0;
        for (RecipeDisplay recipeDisplay : this.categoryMap.get(category)) {
            final int finalIndex = index++;
            RecipeRenderer recipeRenderer = category.getSimpleRenderer(recipeDisplay);
            this.recipeRenderers.add(recipeRenderer);
            this.buttonWidgets.add(new ButtonWidget(this.bounds.x + 5, 0, recipeRenderer.getWidth(), recipeRenderer.getHeight(), ""){

                @Override
                public void onPressed() {
                    VillagerRecipeViewingScreen.this.selectedRecipeIndex = finalIndex;
                    VillagerRecipeViewingScreen.this.init();
                }

                @Override
                public boolean isHovered(int mouseX, int mouseY) {
                    return this.isMouseOver(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) || this.focused;
                }

                @Override
                protected int getTextureId(boolean boolean_1) {
                    this.enabled = VillagerRecipeViewingScreen.this.selectedRecipeIndex != finalIndex;
                    return super.getTextureId(boolean_1);
                }

                @Override
                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.isMouseOver(mouseX, mouseY) && VillagerRecipeViewingScreen.this.scrollListBounds.contains(mouseX, mouseY) && this.enabled && button == 0) {
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        this.onPressed();
                        return true;
                    }
                    return false;
                }
            });
        }
        for (int i = 0; i < 8; ++i) {
            int j = i + this.tabsPage * 8;
            if (this.categories.size() <= j) continue;
            TabWidget tab = new TabWidget(i, new Rectangle(this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * 8, 8) * 14 + i * 28, this.bounds.y - 28, 28, 28)){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        if (this.getId() + VillagerRecipeViewingScreen.this.tabsPage * 8 == VillagerRecipeViewingScreen.this.selectedCategoryIndex) {
                            return false;
                        }
                        VillagerRecipeViewingScreen.this.selectedCategoryIndex = this.getId() + VillagerRecipeViewingScreen.this.tabsPage * 8;
                        VillagerRecipeViewingScreen.this.scroll = 0.0;
                        VillagerRecipeViewingScreen.this.selectedRecipeIndex = 0;
                        VillagerRecipeViewingScreen.this.init();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getIcon(), this.categories.get(j).getCategoryName(), tab.getId() + this.tabsPage * 8 == this.selectedCategoryIndex);
        }
        ButtonWidget w = new ButtonWidget(this.bounds.x + 2, this.bounds.y - 16, 10, 10, (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage--;
                if (VillagerRecipeViewingScreen.this.tabsPage < 0) {
                    VillagerRecipeViewingScreen.this.tabsPage = class_3532.method_15386((float)((float)VillagerRecipeViewingScreen.this.categories.size() / 8.0f)) - 1;
                }
                VillagerRecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10, (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage++;
                if (VillagerRecipeViewingScreen.this.tabsPage > class_3532.method_15386((float)((float)VillagerRecipeViewingScreen.this.categories.size() / 8.0f)) - 1) {
                    VillagerRecipeViewingScreen.this.tabsPage = 0;
                }
                VillagerRecipeViewingScreen.this.init();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > 8;
        w.enabled = w2.enabled;
        this.widgets.add(new ClickableLabelWidget(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6, this.categories.get(this.selectedCategoryIndex).getCategoryName()){

            @Override
            public void onLabelClicked() {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(class_1074.method_4662((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                RenderHelper.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.font.method_1729((this.isHovered(mouseX, mouseY) ? class_124.field_1073.toString() : "") + this.text, (float)(this.x - this.font.method_1727(this.text) / 2), (float)this.y, this.getDefaultColor());
                if (this.clickable && this.getTooltips().isPresent()) {
                    if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
                    } else if (this.focused) {
                        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(new Point(this.x, this.y), this.getTooltips().get().split("\n")));
                    }
                }
            }

            @Override
            public int getDefaultColor() {
                return ScreenHelper.isDarkModeEnabled() ? -4473925 : 0x404040;
            }
        });
        this.children.addAll(this.buttonWidgets);
        this.widgets.addAll(this.tabs);
        this.children.addAll(this.widgets);
        this.children.add(ScreenHelper.getLastOverlay(true, false));
        ScreenHelper.getLastOverlay().init();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight));
        if (height > (double)(actualHeight = this.scrollListBounds.height - 2) && this.scrollBarAlpha > 0.0f && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= (double)(this.scrollListBounds.getMaxY() - 1) && mouseX >= (scrollbarPositionMinX = (double)(this.scrollListBounds.getMaxX() - 6)) & mouseX <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            this.scrollBarAlpha = 1.0f;
            return false;
        }
        this.draggingScrollBar = false;
        return super.mouseClicked(mouseX, mouseY, int_1);
    }

    public boolean charTyped(char char_1, int int_1) {
        for (class_364 listener : this.children()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        double height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight));
        if (this.scrollListBounds.contains(double_1, double_2) && height > (double)(this.scrollListBounds.height - 2)) {
            this.scroll = double_3 > 0.0 ? (this.scroll -= 16.0) : (this.scroll += 16.0);
            this.scroll = class_3532.method_15350((double)this.scroll, (double)0.0, (double)(height - (double)this.scrollListBounds.height + 2.0));
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - this.scrollBarAlphaFutureTime) > 300.0f) {
                this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        for (class_364 listener : this.children()) {
            if (!listener.mouseScrolled(double_1, double_2, double_3)) continue;
            return true;
        }
        if (this.bounds.contains(PointHelper.fromMouse())) {
            if (double_3 < 0.0 && this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.init();
            } else if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.init();
                return true;
            }
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    public void render(int mouseX, int mouseY, float delta) {
        int i;
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().doesVillagerScreenHavePermanentScrollBar()) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), this.scrollBarAlpha);
            }
        }
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        int yOffset = 0;
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(mouseX, mouseY, delta);
        });
        class_308.method_1450();
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        RenderHelper.pushMatrix();
        Scissors.begin();
        Scissors.scissor(0, this.scrollListBounds.y + 1, this.width, this.scrollListBounds.height - 2);
        for (i = 0; i < this.buttonWidgets.size(); ++i) {
            ButtonWidget buttonWidget = this.buttonWidgets.get(i);
            buttonWidget.getBounds().y = this.scrollListBounds.y + 1 + yOffset - (int)this.scroll;
            if (buttonWidget.getBounds().getMaxY() > this.scrollListBounds.getMinY() && buttonWidget.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                class_308.method_1450();
                buttonWidget.render(mouseX, mouseY, delta);
            }
            yOffset += buttonWidget.getBounds().height;
        }
        for (i = 0; i < this.buttonWidgets.size(); ++i) {
            if (this.buttonWidgets.get(i).getBounds().getMaxY() <= this.scrollListBounds.getMinY() || this.buttonWidgets.get(i).getBounds().getMinY() >= this.scrollListBounds.getMaxY()) continue;
            class_308.method_1450();
            this.recipeRenderers.get(i).setBlitOffset(1);
            this.recipeRenderers.get(i).render(this.buttonWidgets.get((int)i).getBounds().x, this.buttonWidgets.get((int)i).getBounds().y, mouseX, mouseY, delta);
            ScreenHelper.getLastOverlay().addTooltip(this.recipeRenderers.get(i).getQueuedTooltip(delta));
        }
        double height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight));
        if (height > (double)(this.scrollListBounds.height - 2)) {
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            double maxScroll = height - (double)this.scrollListBounds.height + 2.0;
            int scrollBarHeight = class_3532.method_15357((double)((double)((this.scrollListBounds.height - 2) * (this.scrollListBounds.height - 2)) / maxScroll));
            int minY = (int)(this.scroll * (double)(this.scrollListBounds.height - 2 - (scrollBarHeight = class_3532.method_15340((int)scrollBarHeight, (int)32, (int)(this.scrollListBounds.height - 2 - 8)))) / maxScroll) + this.scrollListBounds.y + 1;
            if (minY < this.scrollListBounds.y + 1) {
                minY = this.scrollListBounds.y + 1;
            }
            double scrollbarPositionMinX = this.scrollListBounds.getMaxX() - 6;
            double scrollbarPositionMaxX = this.scrollListBounds.getMaxX() - 2;
            class_308.method_1450();
            RenderHelper.disableTexture();
            RenderHelper.enableBlend();
            RenderHelper.disableAlphaTest();
            RenderHelper.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderHelper.shadeModel((int)7425);
            buffer.method_1328(7, class_290.field_1576);
            float b = ScreenHelper.isDarkModeEnabled() ? 0.37f : 1.0f;
            buffer.method_1315(scrollbarPositionMinX, (double)(minY + scrollBarHeight), 1000.0).method_1336(b, b, b, this.scrollBarAlpha).method_1344();
            buffer.method_1315(scrollbarPositionMaxX, (double)(minY + scrollBarHeight), 1000.0).method_1336(b, b, b, this.scrollBarAlpha).method_1344();
            buffer.method_1315(scrollbarPositionMaxX, (double)minY, 1000.0).method_1336(b, b, b, this.scrollBarAlpha).method_1344();
            buffer.method_1315(scrollbarPositionMinX, (double)minY, 1000.0).method_1336(b, b, b, this.scrollBarAlpha).method_1344();
            tessellator.method_1350();
            RenderHelper.shadeModel((int)7424);
            RenderHelper.disableBlend();
            RenderHelper.enableAlphaTest();
            RenderHelper.enableTexture();
        }
        Scissors.end();
        RenderHelper.popMatrix();
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        double height;
        if (int_1 == 0 && this.scrollBarAlpha > 0.0f && this.draggingScrollBar && (height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight)).doubleValue()) > (double)(actualHeight = this.scrollListBounds.height - 2) && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= (double)(this.scrollListBounds.getMaxY() - 1)) {
            int int_3 = class_3532.method_15340((int)((int)((double)(actualHeight * actualHeight) / height)), (int)32, (int)(actualHeight - 8));
            double double_6 = Math.max(1.0, Math.max(1.0, height) / (double)(actualHeight - int_3));
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            this.scroll = class_3532.method_15350((double)(this.scroll + double_4 * double_6), (double)0.0, (double)(height - (double)this.scrollListBounds.height + 2.0));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if ((int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) && this.shouldCloseOnEsc()) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (int_1 == 258) {
            boolean boolean_1;
            boolean bl = boolean_1 = !VillagerRecipeViewingScreen.hasShiftDown();
            if (!this.changeFocus(boolean_1)) {
                this.changeFocus(boolean_1);
            }
            return true;
        }
        if (ClientHelper.getInstance().getNextPageKeyBinding().method_1417(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.init();
                return true;
            }
            return false;
        }
        if (ClientHelper.getInstance().getPreviousPageKeyBinding().method_1417(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.init();
                return true;
            }
            return false;
        }
        for (class_364 element : this.children()) {
            if (!element.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        if (int_1 == 259) {
            if (ScreenHelper.hasLastRecipeScreen()) {
                this.minecraft.method_1507(ScreenHelper.getLastRecipeScreen());
            } else {
                this.minecraft.method_1507(ScreenHelper.getLastContainerScreen());
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
}

