/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import me.shedaniel.rei.impl.FluidEntry;
import me.shedaniel.rei.impl.ItemStackEntry;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import javax.annotation.Nullable;

public interface Entry {
    @SuppressWarnings("deprecation")
    static Entry create(class_1799 itemStack) {
        return new ItemStackEntry(itemStack);
    }
    
    @SuppressWarnings("deprecation")
    static Entry create(class_3611 fluid) {
        return new FluidEntry(fluid);
    }
    
    Type getEntryType();
    
    @Nullable
    class_1799 getItemStack();
    
    @Nullable
    class_3611 getFluid();
    
    public static enum Type {
        ITEM, FLUID
    }
}
