/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.Entry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.config.SearchFieldLocation;
import me.shedaniel.rei.gui.widget.*;
import me.shedaniel.rei.impl.RecipeHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.Weather;
import me.shedaniel.rei.listeners.ContainerScreenHooks;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import javax.annotation.Nullable;
import java.util.*;
import java.util.stream.Collectors;

public class ContainerScreenOverlay extends Widget {
    
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    public static String searchTerm = "";
    private static int page = 0;
    private static EntryListWidget entryListWidget;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private Rectangle rectangle;
    private class_1041 window;
    private CraftableToggleButtonWidget toggleButtonWidget;
    private ButtonWidget buttonLeft, buttonRight;
    
    public static EntryListWidget getEntryListWidget() {
        return entryListWidget;
    }
    
    public static void setPage(int page) {
        ContainerScreenOverlay.page = page;
    }
    
    public void init() {
        init(false);
    }
    
    public void init(boolean setPage) {
        this.shouldReInit = false;
        //Update Variables
        this.children().clear();
        this.window = class_310.method_1551().method_22683();
        DisplayHelper.DisplayBoundsHandler boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        this.rectangle = RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755);
        widgets.add(entryListWidget = new EntryListWidget(page));
        entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, false);
        
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            widgets.add(buttonLeft = new ButtonWidget(rectangle.x, rectangle.y + (RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16, new class_2588("text.rei.left_arrow")) {
                @Override
                public void onPressed() {
                    page--;
                    if (page < 0)
                        page = getTotalPage();
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, false);
                }
                
                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662("text.rei.previous_page"));
                }
                
                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
            widgets.add(buttonRight = new ButtonWidget(rectangle.x + rectangle.width - 18, rectangle.y + (RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16, new class_2588("text.rei.right_arrow")) {
                @Override
                public void onPressed() {
                    page++;
                    if (page > getTotalPage())
                        page = 0;
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, false);
                }
                
                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662("text.rei.next_page"));
                }
                
                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
        }
        
        if (setPage)
            page = class_3532.method_15340(page, 0, getTotalPage());
        
        widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? window.method_4486() - 30 : 10, 10, 20, 20, "") {
            @Override
            public void onPressed() {
                if (class_437.hasShiftDown()) {
                    ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                    return;
                }
                RoughlyEnoughItemsCore.getConfigManager().openConfigScreen(ScreenHelper.getLastContainerScreen());
            }
            
            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                class_308.method_1450();
                if (ClientHelper.getInstance().isCheating() && RoughlyEnoughItemsCore.hasOperatorPermission()) {
                    if (RoughlyEnoughItemsCore.hasPermissionToUsePackets())
                        fill(getBounds().x, getBounds().y, getBounds().x + 20, getBounds().y + 20, 721354752);
                    else
                        fill(getBounds().x, getBounds().y, getBounds().x + 20, getBounds().y + 20, 1476440063);
                }
                class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
                blit(getBounds().x + 3, getBounds().y + 3, 0, 0, 14, 14);
            }
            
            @Override
            public Optional<String> getTooltips() {
                String tooltips = class_1074.method_4662("text.rei.config_tooltip");
                tooltips += "\n  ";
                if (!ClientHelper.getInstance().isCheating())
                    tooltips += "\n" + class_1074.method_4662("text.rei.cheating_disabled");
                else if (!RoughlyEnoughItemsCore.hasOperatorPermission())
                    tooltips += "\n" + class_1074.method_4662("text.rei.cheating_enabled_no_perms");
                else if (RoughlyEnoughItemsCore.hasPermissionToUsePackets())
                    tooltips += "\n" + class_1074.method_4662("text.rei.cheating_enabled");
                else
                    tooltips += "\n" + class_1074.method_4662("text.rei.cheating_limited_enabled");
                return Optional.ofNullable(tooltips);
            }
            
            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }
        });
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().doesShowUtilsButtons()) {
            widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? window.method_4486() - 55 : 35, 10, 20, 20, "") {
                @Override
                public void onPressed() {
                    class_310.method_1551().field_1724.method_3142(RoughlyEnoughItemsCore.getConfigManager().getConfig().getGamemodeCommand().replaceAll("\\{gamemode}", getNextGameMode(class_437.hasShiftDown()).method_8381()));
                }
                
                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    text = getGameModeShortText(getCurrentGameMode());
                    super.render(mouseX, mouseY, delta);
                }
                
                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662("text.rei.gamemode_button.tooltip", getGameModeText(getNextGameMode(class_437.hasShiftDown()))));
                }
                
                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
            int xxx = RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? window.method_4486() - 30 : 10;
            for (Weather weather : Weather.values()) {
                widgets.add(new ButtonWidget(xxx, 35, 20, 20, "") {
                    @Override
                    public void onPressed() {
                        class_310.method_1551().field_1724.method_3142(RoughlyEnoughItemsCore.getConfigManager().getConfig().getWeatherCommand().replaceAll("\\{weather}", weather.name().toLowerCase(Locale.ROOT)));
                    }
                    
                    @Override
                    public void render(int mouseX, int mouseY, float delta) {
                        super.render(mouseX, mouseY, delta);
                        class_308.method_1450();
                        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
                        blit(getBounds().x + 3, getBounds().y + 3, weather.getId() * 14, 14, 14, 14);
                    }
                    
                    @Override
                    public Optional<String> getTooltips() {
                        return Optional.ofNullable(class_1074.method_4662("text.rei.weather_button.tooltip", class_1074.method_4662(weather.getTranslateKey())));
                    }
                    
                    @Override
                    public boolean changeFocus(boolean boolean_1) {
                        return false;
                    }
                });
                xxx += RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? -25 : 25;
            }
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            widgets.add(new ClickableLabelWidget(rectangle.x + (rectangle.width / 2), rectangle.y + (RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10, "", getTotalPage() > 0) {
                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    page = class_3532.method_15340(page, 0, getTotalPage());
                    this.text = String.format("%s/%s", page + 1, getTotalPage() + 1);
                    super.render(mouseX, mouseY, delta);
                }
                
                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662("text.rei.go_back_first_page"));
                }
                
                @Override
                public void onLabelClicked() {
                    class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                    page = 0;
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, false);
                }
                
                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
            buttonLeft.enabled = buttonRight.enabled = getTotalPage() > 0;
        }
        if (ScreenHelper.searchField == null)
            ScreenHelper.searchField = new SearchFieldWidget(0, 0, 0, 0);
        ScreenHelper.searchField.getBounds().setBounds(getTextFieldArea());
        this.widgets.add(ScreenHelper.searchField);
        ScreenHelper.searchField.setText(searchTerm);
        ScreenHelper.searchField.setChangedListener(s -> {
            searchTerm = s;
            entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, true);
        });
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isCraftableFilterEnabled())
            this.widgets.add(toggleButtonWidget = new CraftableToggleButtonWidget(getCraftableToggleArea()) {
                @Override
                public void onPressed() {
                    RoughlyEnoughItemsCore.getConfigManager().toggleCraftableOnly();
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, true);
                }
                
                @Override
                public void lateRender(int mouseX, int mouseY, float delta) {
                    setBlitOffset(300);
                    super.lateRender(mouseX, mouseY, delta);
                }
            });
        else
            toggleButtonWidget = null;
        this.entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, false);
    }
    
    private Weather getNextWeather() {
        try {
            Weather current = getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3)
                next = 0;
            return Weather.byId(next);
        } catch (Exception e) {
            return Weather.CLEAR;
        }
    }
    
    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546())
            return Weather.THUNDER;
        if (world.method_8401().method_156())
            return Weather.RAIN;
        return Weather.CLEAR;
    }
    
    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662("text.rei.short_gamemode." + gameMode.method_8381());
    }
    
    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662("selectWorld.gameMode." + gameMode.method_8381());
    }
    
    private class_1934 getNextGameMode(boolean reverse) {
        try {
            class_1934 current = getCurrentGameMode();
            int next = current.method_8379() + 1;
            if (reverse)
                next -= 2;
            if (next > 3)
                next = 0;
            if (next < 0)
                next = 3;
            return class_1934.method_8384(next);
        } catch (Exception e) {
            return class_1934.field_9218;
        }
    }
    
    private class_1934 getCurrentGameMode() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId()).method_2958();
    }
    
    private Rectangle getTextFieldArea() {
        int widthRemoved = RoughlyEnoughItemsCore.getConfigManager().getConfig().isCraftableFilterEnabled() ? 22 : 2;
        SearchFieldLocation searchFieldLocation = RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation();
        if (searchFieldLocation == SearchFieldLocation.BOTTOM_SIDE)
            return new Rectangle(rectangle.x + 2, window.method_4502() - 22, rectangle.width - 6 - widthRemoved, 18);
        if (searchFieldLocation == SearchFieldLocation.TOP_SIDE)
            return new Rectangle(rectangle.x + 2, 4, rectangle.width - 6 - widthRemoved, 18);
        if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen) class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen) class_310.method_1551().field_1755;
            return new Rectangle(widget.bounds.x, window.method_4502() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft(), window.method_4502() - 22, ScreenHelper.getLastContainerScreenHooks().rei_getContainerWidth() - widthRemoved, 18);
    }
    
    private Rectangle getCraftableToggleArea() {
        Rectangle searchBoxArea = getTextFieldArea();
        searchBoxArea.setLocation(searchBoxArea.x + searchBoxArea.width + 4, searchBoxArea.y - 1);
        searchBoxArea.setSize(20, 20);
        return searchBoxArea;
    }
    
    private String getCheatModeText() {
        return class_1074.method_4662(String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"));
    }
    
    public Rectangle getRectangle() {
        return rectangle;
    }
    
    @Override
    public void render(int mouseX, int mouseY, float delta) {
        List<class_1799> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler() != null && RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler().shouldRecalculateArea(!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel(), rectangle))
            shouldReInit = true;
        if (shouldReInit)
            init(true);
        else if (RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() && ((currentStacks.size() != ScreenHelper.inventoryStacks.size()) || !hasSameListContent(new LinkedList<>(ScreenHelper.inventoryStacks), currentStacks))) {
            ScreenHelper.inventoryStacks = currentStacks;
            DisplayHelper.DisplayBoundsHandler<?> boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
            entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(rectangle), page, searchTerm, true);
        }
        if (SearchFieldWidget.isSearching) {
            class_308.method_1450();
            setBlitOffset(200);
            if (class_310.method_1551().field_1755 instanceof class_465) {
                ContainerScreenHooks hooks = (ContainerScreenHooks) class_310.method_1551().field_1755;
                int left = hooks.rei_getContainerLeft(), top = hooks.rei_getContainerTop();
                for (class_1735 slot : ((class_465<?>) class_310.method_1551().field_1755).method_17577().field_7761)
                    if (!slot.method_7681() || !entryListWidget.filterEntry(Entry.create(slot.method_7677()), entryListWidget.getLastSearchArgument()))
                        fillGradient(left + slot.field_7873, top + slot.field_7872, left + slot.field_7873 + 16, top + slot.field_7872 + 16, -601874400, -601874400);
            }
            setBlitOffset(0);
        }
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        class_308.method_1450();
        this.renderWidgets(mouseX, mouseY, delta);
        if (class_310.method_1551().field_1755 instanceof class_465 && RoughlyEnoughItemsCore.getConfigManager().getConfig().areClickableRecipeArrowsEnabled()) {
            ContainerScreenHooks hooks = (ContainerScreenHooks) class_310.method_1551().field_1755;
            for (RecipeHelperImpl.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas())
                if (area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()))
                    if (area.getRectangle().contains(mouseX - hooks.rei_getContainerLeft(), mouseY - hooks.rei_getContainerTop())) {
                        String collect = Arrays.asList(area.getCategories()).stream().map(identifier -> RecipeHelper.getInstance().getCategory(identifier).getCategoryName()).collect(Collectors.joining(", "));
                        QUEUED_TOOLTIPS.add(QueuedTooltip.create(class_1074.method_4662("text.rei.view_recipes_for", collect)));
                        break;
                    }
        }
    }
    
    public void lateRender(int mouseX, int mouseY, float delta) {
        if (ScreenHelper.isOverlayVisible()) {
            ScreenHelper.searchField.laterRender(mouseX, mouseY, delta);
            if (toggleButtonWidget != null)
                toggleButtonWidget.lateRender(mouseX, mouseY, delta);
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (!(currentScreen instanceof RecipeViewingScreen) || !((RecipeViewingScreen) currentScreen).choosePageActivated)
                QUEUED_TOOLTIPS.stream().filter(Objects::nonNull).forEach(this::renderTooltip);
        }
        QUEUED_TOOLTIPS.clear();
    }
    
    @SuppressWarnings("deprecation")
    public void renderTooltip(QueuedTooltip tooltip) {
        if (tooltip.getConsumer() == null)
            renderTooltip(tooltip.getText(), tooltip.getX(), tooltip.getY());
        else
            tooltip.getConsumer().accept(tooltip);
    }
    
    public void renderTooltip(List<String> lines, int mouseX, int mouseY) {
        if (lines.isEmpty())
            return;
        class_327 font = class_310.method_1551().field_1772;
        int width = lines.stream().map(font::method_1727).max(Integer::compareTo).get();
        int height = lines.size() <= 1 ? 8 : lines.size() * 10;
        ScreenHelper.drawHoveringWidget(mouseX, mouseY, (x, y, aFloat) -> {
            RenderSystem.disableRescaleNormal();
            class_308.method_1450();
            RenderSystem.disableLighting();
            setBlitOffset(1000);
            this.fillGradient(x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864);
            this.fillGradient(x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864);
            this.fillGradient(x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864);
            this.fillGradient(x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864);
            this.fillGradient(x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864);
            this.fillGradient(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 1347420415, 1344798847);
            this.fillGradient(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 1347420415, 1344798847);
            this.fillGradient(x - 3, y - 3, x + width + 3, y - 3 + 1, 1347420415, 1347420415);
            this.fillGradient(x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847);
            int currentY = y;
            for (int lineIndex = 0; lineIndex < lines.size(); lineIndex++) {
                RenderSystem.disableDepthTest();
                font.method_1720(lines.get(lineIndex), x, currentY, -1);
                RenderSystem.enableDepthTest();
                currentY += lineIndex == 0 ? 12 : 10;
            }
            setBlitOffset(0);
            RenderSystem.enableLighting();
            class_308.method_1452();
            RenderSystem.enableRescaleNormal();
        }, width, height, 0);
    }
    
    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        list1.sort(Comparator.comparing(Object::toString));
        list2.sort(Comparator.comparing(Object::toString));
        return list1.stream().map(Objects::toString).collect(Collectors.joining("")).equals(list2.stream().map(Objects::toString).collect(Collectors.joining("")));
    }
    
    public void addTooltip(@Nullable QueuedTooltip queuedTooltip) {
        if (queuedTooltip != null)
            QUEUED_TOOLTIPS.add(queuedTooltip);
    }
    
    public void renderWidgets(int int_1, int int_2, float float_1) {
        if (!ScreenHelper.isOverlayVisible())
            return;
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled())
            buttonLeft.enabled = buttonRight.enabled = getTotalPage() > 0;
        widgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(int_1, int_2, float_1);
        });
        class_308.method_1450();
    }
    
    private int getTotalPage() {
        return entryListWidget.getTotalPage();
    }
    
    @Override
    public boolean mouseScrolled(double i, double j, double amount) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (isInside(PointHelper.fromMouse())) {
            if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
                if (amount > 0 && buttonLeft.enabled)
                    buttonLeft.onPressed();
                else if (amount < 0 && buttonRight.enabled)
                    buttonRight.onPressed();
                else
                    return false;
                return true;
            } else {
                return entryListWidget.mouseScrolled(i, j, amount);
            }
        }
        for (Widget widget : widgets)
            if (widget.mouseScrolled(i, j, amount))
                return true;
        return false;
    }
    
    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible())
            for (class_364 listener : widgets)
                if (listener.keyPressed(int_1, int_2, int_3))
                    return true;
        if (ClientHelper.getInstance().getHideKeyBinding().method_1417(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        class_1799 itemStack = null;
        if (class_310.method_1551().field_1755 instanceof class_465)
            if (ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot() != null && !ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677().method_7960())
                itemStack = ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677();
        if (itemStack != null && !itemStack.method_7960()) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().method_1417(int_1, int_2))
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            else if (ClientHelper.getInstance().getUsageKeyBinding().method_1417(int_1, int_2))
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
        }
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (ClientHelper.getInstance().getFocusSearchFieldKeyBinding().method_1417(int_1, int_2)) {
            ScreenHelper.searchField.setFocused(true);
            setFocused(ScreenHelper.searchField);
            ScreenHelper.searchField.keybindFocusTime = System.currentTimeMillis();
            ScreenHelper.searchField.keybindFocusKey = int_1;
            return true;
        }
        return false;
    }
    
    @Override
    public boolean charTyped(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        for (class_364 listener : widgets)
            if (listener.charTyped(char_1, int_1))
                return true;
        return false;
    }
    
    @Override
    public List<? extends class_364> children() {
        return widgets;
    }
    
    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        if (class_310.method_1551().field_1755 instanceof class_465 && RoughlyEnoughItemsCore.getConfigManager().getConfig().areClickableRecipeArrowsEnabled()) {
            ContainerScreenHooks hooks = (ContainerScreenHooks) class_310.method_1551().field_1755;
            for (RecipeHelperImpl.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas())
                if (area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()))
                    if (area.getRectangle().contains(double_1 - hooks.rei_getContainerLeft(), double_2 - hooks.rei_getContainerTop())) {
                        ClientHelper.getInstance().executeViewAllRecipesFromCategories(Arrays.asList(area.getCategories()));
                        class_310.method_1551().method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                        return true;
                    }
        }
        for (class_364 element : widgets)
            if (element.mouseClicked(double_1, double_2, int_1)) {
                this.setFocused(element);
                if (int_1 == 0)
                    this.setDragging(true);
                return true;
            }
        return false;
    }
    
    @Override
    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!ScreenHelper.isOverlayVisible())
            return false;
        return this.getFocused() != null && this.isDragging() && int_1 == 0 ? this.getFocused().mouseDragged(double_1, double_2, int_1, double_3, double_4) : false;
    }
    
    public boolean isInside(double mouseX, double mouseY) {
        if (!rectangle.contains(mouseX, mouseY))
            return false;
        for (DisplayHelper.DisplayBoundsHandler handler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(class_310.method_1551().field_1755.getClass())) {
            class_1269 in = handler.isInZone(!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel(), mouseX, mouseY);
            if (in != class_1269.field_5811)
                return in == class_1269.field_5812;
        }
        return true;
    }
    
    public boolean isInside(Point point) {
        return isInside(point.getX(), point.getY());
    }
    
}
