/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.renderers;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import javax.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SimpleRecipeRenderer extends RecipeRenderer {
    
    public static final Comparator<class_1799> ITEM_STACK_COMPARATOR = (o1, o2) -> {
        if (o1.method_7909() == o2.method_7909()) {
            if (o1.method_7947() != o2.method_7947())
                return o1.method_7947() - o2.method_7947();
            int compare = Boolean.compare(o1.method_7985(), o2.method_7985());
            if (compare != 0)
                return compare;
            if (o1.method_7969().method_10546() != o2.method_7969().method_10546())
                return o1.method_7969().method_10546() - o2.method_7969().method_10546();
            return o1.method_7969().hashCode() - o2.method_7969().hashCode();
        }
        return o1.method_7909().hashCode() - o2.method_7909().hashCode();
    };
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<ItemStackRenderer> inputRenderer;
    private ItemStackRenderer outputRenderer;
    private QueuedTooltip lastTooltip;
    
    public SimpleRecipeRenderer(Supplier<List<List<class_1799>>> input, Supplier<List<class_1799>> output) {
        List<class_3545<List<class_1799>, AtomicInteger>> newList = Lists.newArrayList();
        List<class_3545<List<class_1799>, Integer>> a = input.get().stream().map(stacks -> new class_3545<>(stacks, stacks.stream().map(class_1799::method_7947).max(Integer::compareTo).orElse(1))).collect(Collectors.toList());
        for (class_3545<List<class_1799>, Integer> pair : a) {
            Optional<class_3545<List<class_1799>, AtomicInteger>> any = newList.stream().filter(pairr -> equalsList(pair.method_15442(), pairr.method_15442())).findAny();
            if (any.isPresent()) {
                any.get().method_15441().addAndGet(pair.method_15441());
            } else
                newList.add(new class_3545<>(pair.method_15442(), new AtomicInteger(pair.method_15441())));
        }
        List<List<class_1799>> b = Lists.newArrayList();
        for (class_3545<List<class_1799>, AtomicInteger> pair : newList)
            b.add(pair.method_15442().stream().map(stack -> {
                class_1799 s = stack.method_7972();
                s.method_7939(pair.method_15441().get());
                return s;
            }).collect(Collectors.toList()));
        this.inputRenderer = b.stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> Renderer.fromItemStacks(stacks)).collect(Collectors.toList());
        this.outputRenderer = Renderer.fromItemStacks(output.get().stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList()));
    }
    
    public static boolean equalsList(List<class_1799> list_1, List<class_1799> list_2) {
        List<class_1799> stacks_1 = list_1.stream().distinct().sorted(ITEM_STACK_COMPARATOR).collect(Collectors.toList());
        List<class_1799> stacks_2 = list_2.stream().distinct().sorted(ITEM_STACK_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2))
            return true;
        if (stacks_1.size() != stacks_2.size())
            return false;
        for (int i = 0; i < stacks_1.size(); i++)
            if (!stacks_1.get(i).method_7962(stacks_2.get(i)))
                return false;
        return true;
    }
    
    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        lastTooltip = null;
        int xx = x + 4, yy = y + 2;
        int j = 0;
        int itemsPerLine = getItemsPerLine();
        for (ItemStackRenderer itemStackRenderer : inputRenderer) {
            itemStackRenderer.setBlitOffset(getBlitOffset() + 50);
            if (lastTooltip == null && class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen && mouseX >= xx && mouseX <= xx + 16 && mouseY >= yy && mouseY <= yy + 16) {
                lastTooltip = itemStackRenderer.getQueuedTooltip(delta);
            }
            itemStackRenderer.render(xx + 8, yy + 6, mouseX, mouseY, delta);
            xx += 18;
            j++;
            if (j >= getItemsPerLine() - 2) {
                yy += 18;
                xx = x + 5;
                j = 0;
            }
        }
        xx = x + 5 + 18 * (getItemsPerLine() - 2);
        yy = y + getHeight() / 2 - 8;
        class_308.method_1450();
        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
        blit(xx, yy, 0, 28, 18, 18);
        xx += 18;
        outputRenderer.setBlitOffset(getBlitOffset() + 50);
        outputRenderer.render(xx + 8, yy + 6, mouseX, mouseY, delta);
        if (lastTooltip == null && class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen && mouseX >= xx && mouseX <= xx + 16 && mouseY >= yy && mouseY <= yy + 16) {
            lastTooltip = outputRenderer.getQueuedTooltip(delta);
        }
    }
    
    @Nullable
    @Override
    public QueuedTooltip getQueuedTooltip(float delta) {
        return lastTooltip;
    }
    
    @Override
    public int getHeight() {
        return 4 + getItemsHeight() * 18;
    }
    
    public int getItemsHeight() {
        return class_3532.method_15386(((float) inputRenderer.size()) / (getItemsPerLine() - 2));
    }
    
    public int getItemsPerLine() {
        return class_3532.method_15375((getWidth() - 4f) / 18f);
    }
    
}
