/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.crafting;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.server.ContainerInfo;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import java.util.List;
import java.util.Optional;

public interface DefaultCraftingDisplay extends TransferRecipeDisplay {
    
    @Override
    default class_2960 getRecipeCategory() {
        return DefaultPlugin.CRAFTING;
    }
    
    @Override
    default public int getWidth() {
        return 2;
    }
    
    @Override
    default public int getHeight() {
        return 2;
    }
    
    Optional<class_1860<?>> getOptionalRecipe();
    
    @Override
    default List<List<class_1799>> getOrganisedInput(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        List<List<class_1799>> list = Lists.newArrayListWithCapacity(containerInfo.getCraftingWidth(container) * containerInfo.getCraftingHeight(container));
        for (int i = 0; i < containerInfo.getCraftingWidth(container) * containerInfo.getCraftingHeight(container); i++) {
            list.add(Lists.newArrayList());
        }
        for (int i = 0; i < getInput().size(); i++) {
            List<class_1799> stacks = getInput().get(i);
            list.set(DefaultCraftingCategory.getSlotWithSize(this, i, containerInfo.getCraftingWidth(container)), stacks);
        }
        return list;
    }
}
