/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.crafting;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2960;

public class DefaultCustomDisplay implements DefaultCraftingDisplay {
    
    private List<List<class_1799>> input;
    private List<class_1799> output;
    private class_1860<?> possibleRecipe;
    private int width, height;
    
    public DefaultCustomDisplay(List<List<class_1799>> input, List<class_1799> output, class_1860<?> possibleRecipe) {
        this.input = input;
        this.output = output;
        this.possibleRecipe = possibleRecipe;
        List<Boolean> row = Lists.newArrayList(false, false, false);
        List<Boolean> column = Lists.newArrayList(false, false, false);
        for (int i = 0; i < 9; i++)
            if (i < input.size()) {
                List<class_1799> stacks = input.get(i);
                if (stacks.stream().filter(stack -> !stack.method_7960()).count() > 0) {
                    row.set((i - (i % 3)) / 3, true);
                    column.set(i % 3, true);
                }
            }
        this.width = (int) column.stream().filter(Boolean::booleanValue).count();
        this.height = (int) row.stream().filter(Boolean::booleanValue).count();
    }
    
    public DefaultCustomDisplay(List<List<class_1799>> input, List<class_1799> output) {
        this(input, output, null);
    }
    
    public class_1860 getPossibleRecipe() {
        return possibleRecipe;
    }
    
    @Override
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(possibleRecipe).map(class_1860::method_8114);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return input;
    }
    
    @Override
    public List<class_1799> getOutput() {
        return output;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return input;
    }
    
    @Override
    public int getWidth() {
        return width;
    }
    
    @Override
    public int getHeight() {
        return height;
    }
    
    @Override
    public Optional<class_1860<?>> getOptionalRecipe() {
        return Optional.ofNullable(possibleRecipe);
    }
    
}
