/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.renderers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.renderers.ItemStackRenderer;
import me.shedaniel.rei.gui.renderers.RecipeRenderer;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;

public class SimpleRecipeRenderer
extends RecipeRenderer {
    public static final Comparator<class_1799> ITEM_STACK_COMPARATOR = (o1, o2) -> {
        if (o1.method_7909() == o2.method_7909()) {
            if (o1.method_7947() != o2.method_7947()) {
                return o1.method_7947() - o2.method_7947();
            }
            int compare = Boolean.compare(o1.method_7985(), o2.method_7985());
            if (compare != 0) {
                return compare;
            }
            if (o1.method_7969().method_10546() != o2.method_7969().method_10546()) {
                return o1.method_7969().method_10546() - o2.method_7969().method_10546();
            }
            return o1.method_7969().hashCode() - o2.method_7969().hashCode();
        }
        return o1.method_7909().hashCode() - o2.method_7909().hashCode();
    };
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<ItemStackRenderer> inputRenderer;
    private ItemStackRenderer outputRenderer;
    private QueuedTooltip lastTooltip;

    public SimpleRecipeRenderer(Supplier<List<List<class_1799>>> input, Supplier<List<class_1799>> output) {
        ArrayList newList = Lists.newArrayList();
        List a = input.get().stream().map(stacks -> new class_3545(stacks, (Object)stacks.stream().map(class_1799::method_7947).max(Integer::compareTo).orElse(1))).collect(Collectors.toList());
        for (class_3545 pair : a) {
            Optional<class_3545> any = newList.stream().filter(pairr -> SimpleRecipeRenderer.equalsList((List)pair.method_15442(), (List)pairr.method_15442())).findAny();
            if (any.isPresent()) {
                ((AtomicInteger)any.get().method_15441()).addAndGet((Integer)pair.method_15441());
                continue;
            }
            newList.add(new class_3545(pair.method_15442(), (Object)new AtomicInteger((Integer)pair.method_15441())));
        }
        ArrayList b = Lists.newArrayList();
        for (class_3545 pair : newList) {
            b.add(((List)pair.method_15442()).stream().map(stack -> {
                class_1799 s = stack.method_7972();
                s.method_7939(((AtomicInteger)pair.method_15441()).get());
                return s;
            }).collect(Collectors.toList()));
        }
        this.inputRenderer = b.stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> Renderer.fromItemStacks(stacks)).collect(Collectors.toList());
        this.outputRenderer = Renderer.fromItemStacks(output.get().stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList()));
    }

    public static boolean equalsList(List<class_1799> list_1, List<class_1799> list_2) {
        List stacks_2;
        List stacks_1 = list_1.stream().distinct().sorted(ITEM_STACK_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2 = list_2.stream().distinct().sorted(ITEM_STACK_COMPARATOR).collect(Collectors.toList()))) {
            return true;
        }
        if (stacks_1.size() != stacks_2.size()) {
            return false;
        }
        for (int i = 0; i < stacks_1.size(); ++i) {
            if (((class_1799)stacks_1.get(i)).method_7962((class_1799)stacks_2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        this.lastTooltip = null;
        int xx = x + 4;
        int yy = y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (ItemStackRenderer itemStackRenderer : this.inputRenderer) {
            itemStackRenderer.setBlitOffset(this.getBlitOffset() + 50);
            if (this.lastTooltip == null && class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen && mouseX >= (double)xx && mouseX <= (double)(xx + 16) && mouseY >= (double)yy && mouseY <= (double)(yy + 16)) {
                this.lastTooltip = itemStackRenderer.getQueuedTooltip(delta);
            }
            itemStackRenderer.render(xx + 8, yy + 6, mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = x + 5;
            j = 0;
        }
        xx = x + 5 + 18 * (this.getItemsPerLine() - 2);
        yy = y + this.getHeight() / 2 - 8;
        class_308.method_1450();
        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
        this.blit(xx, yy, 0, 28, 18, 18);
        this.outputRenderer.setBlitOffset(this.getBlitOffset() + 50);
        this.outputRenderer.render((xx += 18) + 8, yy + 6, mouseX, mouseY, delta);
        if (this.lastTooltip == null && class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen && mouseX >= (double)xx && mouseX <= (double)(xx + 16) && mouseY >= (double)yy && mouseY <= (double)(yy + 16)) {
            this.lastTooltip = this.outputRenderer.getQueuedTooltip(delta);
        }
    }

    @Override
    @Nullable
    public QueuedTooltip getQueuedTooltip(float delta) {
        return this.lastTooltip;
    }

    @Override
    public int getHeight() {
        return 4 + this.getItemsHeight() * 18;
    }

    public int getItemsHeight() {
        return class_3532.method_15386((float)((float)this.inputRenderer.size() / (float)(this.getItemsPerLine() - 2)));
    }

    public int getItemsPerLine() {
        return class_3532.method_15375((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }
}

