/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.Entry;
import me.shedaniel.rei.api.EntryRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_3611;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class EntryRegistryImpl implements EntryRegistry {
    
    private final CopyOnWriteArrayList<Entry> entries = Lists.newCopyOnWriteArrayList();
    
    @Override
    public List<Entry> getEntryList() {
        return Collections.unmodifiableList(entries);
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public List<Entry> getModifiableEntryList() {
        return entries;
    }
    
    @Override
    public class_1799[] getAllStacksFromItem(class_1792 item) {
        class_2371<class_1799> list = class_2371.method_10211();
        list.add(item.method_7854());
        item.method_7850(item.method_7859(), list);
        TreeSet<class_1799> stackSet = list.stream().collect(Collectors.toCollection(() -> new TreeSet<class_1799>((p1, p2) -> class_1799.method_7973(p1, p2) ? 0 : 1)));
        return Lists.newArrayList(stackSet).toArray(new class_1799[0]);
    }
    
    @Override
    public void registerItemStack(class_1792 afterItem, class_1799 stack) {
        if (!stack.method_7960() && !alreadyContain(stack))
            if (afterItem == null || afterItem.equals(class_1802.field_8162))
                entries.add(Entry.create(stack));
            else {
                int last = entries.size();
                for (int i = 0; i < entries.size(); i++)
                    if (entries.get(i).getEntryType() == Entry.Type.ITEM && entries.get(i).getItemStack().method_7909().equals(afterItem))
                        last = i + 1;
                entries.add(last, Entry.create(stack));
            }
    }
    
    @Override
    public void registerFluid(class_3611 fluid) {
        entries.add(Entry.create(fluid));
    }
    
}
