/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.autocrafting;

import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.listeners.RecipeBookGuiHooks;
import me.shedaniel.rei.plugin.blasting.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.smelting.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.smoking.DefaultSmokingDisplay;
import net.minecraft.class_1074;
import net.minecraft.class_1714;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_1860;
import net.minecraft.class_437;
import net.minecraft.class_518;

public class DefaultRecipeBookHandler implements AutoTransferHandler {
    @Override
    public Result handle(Context context) {
        RecipeDisplay display = context.getRecipe();
        if (!(context.getContainer() instanceof class_1729))
            return Result.createNotApplicable();
        class_1729<?> container = (class_1729<?>) context.getContainer();
        if (display instanceof DefaultCraftingDisplay) {
            DefaultCraftingDisplay craftingDisplay = (DefaultCraftingDisplay) display;
            if (craftingDisplay.getOptionalRecipe().isPresent()) {
                int h = -1, w = -1;
                if (container instanceof class_1714) {
                    h = 3;
                    w = 3;
                } else if (container instanceof class_1723) {
                    h = 2;
                    w = 2;
                }
                if (h == -1 || w == -1)
                    return Result.createNotApplicable();
                class_1860<?> recipe = (craftingDisplay).getOptionalRecipe().get();
                if (craftingDisplay.getHeight() > h || craftingDisplay.getWidth() > w)
                    return Result.createFailed(class_1074.method_4662("error.rei.transfer.too_small", h, w));
                if (!context.getMinecraft().field_1724.method_3130().method_14878(recipe))
                    return Result.createFailed(class_1074.method_4662("error.rei.recipe.not.unlocked"));
                if (!context.isActuallyCrafting())
                    return Result.createSuccessful();
                context.getMinecraft().method_1507(context.getContainerScreen());
                if (context.getContainerScreen() instanceof class_518)
                    ((RecipeBookGuiHooks) ((class_518) context.getContainerScreen()).method_2659()).rei_getGhostSlots().method_2571();
                context.getMinecraft().field_1761.method_2912(container.field_7763, recipe, class_437.hasShiftDown());
                ScreenHelper.getLastOverlay().init();
            }
        } else if (display instanceof DefaultSmeltingDisplay) {
            DefaultSmeltingDisplay defaultDisplay = (DefaultSmeltingDisplay) display;
            if (defaultDisplay.getOptionalRecipe().isPresent()) {
                class_1860<?> recipe = (defaultDisplay).getOptionalRecipe().get();
                if (!context.getMinecraft().field_1724.method_3130().method_14878(recipe))
                    return Result.createFailed(class_1074.method_4662("error.rei.recipe.not.unlocked"));
                if (!context.isActuallyCrafting())
                    return Result.createSuccessful();
                context.getMinecraft().method_1507(context.getContainerScreen());
                if (context.getContainerScreen() instanceof class_518)
                    ((RecipeBookGuiHooks) ((class_518) context.getContainerScreen()).method_2659()).rei_getGhostSlots().method_2571();
                context.getMinecraft().field_1761.method_2912(container.field_7763, recipe, class_437.hasShiftDown());
                ScreenHelper.getLastOverlay().init();
            }
        } else if (display instanceof DefaultSmokingDisplay) {
            DefaultSmokingDisplay defaultDisplay = (DefaultSmokingDisplay) display;
            if (defaultDisplay.getOptionalRecipe().isPresent()) {
                class_1860<?> recipe = (defaultDisplay).getOptionalRecipe().get();
                if (!context.getMinecraft().field_1724.method_3130().method_14878(recipe))
                    return Result.createFailed(class_1074.method_4662("error.rei.recipe.not.unlocked"));
                if (!context.isActuallyCrafting())
                    return Result.createSuccessful();
                context.getMinecraft().method_1507(context.getContainerScreen());
                if (context.getContainerScreen() instanceof class_518)
                    ((RecipeBookGuiHooks) ((class_518) context.getContainerScreen()).method_2659()).rei_getGhostSlots().method_2571();
                context.getMinecraft().field_1761.method_2912(container.field_7763, recipe, class_437.hasShiftDown());
                ScreenHelper.getLastOverlay().init();
            }
        } else if (display instanceof DefaultBlastingDisplay) {
            DefaultBlastingDisplay defaultDisplay = (DefaultBlastingDisplay) display;
            if (defaultDisplay.getOptionalRecipe().isPresent()) {
                class_1860<?> recipe = (defaultDisplay).getOptionalRecipe().get();
                if (!context.getMinecraft().field_1724.method_3130().method_14878(recipe))
                    return Result.createFailed(class_1074.method_4662("error.rei.recipe.not.unlocked"));
                if (!context.isActuallyCrafting())
                    return Result.createSuccessful();
                context.getMinecraft().method_1507(context.getContainerScreen());
                if (context.getContainerScreen() instanceof class_518)
                    ((RecipeBookGuiHooks) ((class_518) context.getContainerScreen()).method_2659()).rei_getGhostSlots().method_2571();
                context.getMinecraft().field_1761.method_2912(container.field_7763, recipe, class_437.hasShiftDown());
                ScreenHelper.getLastOverlay().init();
            }
        }
        return Result.createNotApplicable();
    }
    
    @Override
    public double getPriority() {
        return -20;
    }
}
