/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.Entry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.SearchFieldLocation;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.CraftableToggleButtonWidget;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SearchFieldWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.Weather;
import me.shedaniel.rei.listeners.ContainerScreenHooks;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1269;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import org.apache.logging.log4j.util.TriConsumer;

public class ContainerScreenOverlay
extends Widget {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    public static String searchTerm = "";
    private static int page = 0;
    private static EntryListWidget entryListWidget;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private Rectangle rectangle;
    private class_1041 window;
    private CraftableToggleButtonWidget toggleButtonWidget;
    private ButtonWidget buttonLeft;
    private ButtonWidget buttonRight;

    public static EntryListWidget getEntryListWidget() {
        return entryListWidget;
    }

    public static void setPage(int page) {
        ContainerScreenOverlay.page = page;
    }

    public void init() {
        this.init(false);
    }

    public void init(boolean setPage) {
        this.shouldReInit = false;
        this.children().clear();
        this.window = class_310.method_1551().method_22683();
        final DisplayHelper.DisplayBoundsHandler<?> boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
        this.rectangle = RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? boundsHandler.getLeftBounds(class_310.method_1551().field_1755) : boundsHandler.getRightBounds(class_310.method_1551().field_1755);
        entryListWidget = new EntryListWidget(page);
        this.widgets.add(entryListWidget);
        entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, false);
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            this.buttonLeft = new ButtonWidget(this.rectangle.x, this.rectangle.y + (RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16, (class_2561)new class_2588("text.rei.left_arrow", new Object[0])){

                @Override
                public void onPressed() {
                    page--;
                    if (page < 0) {
                        page = ContainerScreenOverlay.this.getTotalPage();
                    }
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
                }

                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662((String)"text.rei.previous_page", (Object[])new Object[0]));
                }

                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            };
            this.widgets.add(this.buttonLeft);
            this.buttonRight = new ButtonWidget(this.rectangle.x + this.rectangle.width - 18, this.rectangle.y + (RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16, (class_2561)new class_2588("text.rei.right_arrow", new Object[0])){

                @Override
                public void onPressed() {
                    page++;
                    if (page > ContainerScreenOverlay.this.getTotalPage()) {
                        page = 0;
                    }
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
                }

                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662((String)"text.rei.next_page", (Object[])new Object[0]));
                }

                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            };
            this.widgets.add(this.buttonRight);
        }
        if (setPage) {
            page = class_3532.method_15340((int)page, (int)0, (int)this.getTotalPage());
        }
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10, 10, 20, 20, ""){

            @Override
            public void onPressed() {
                if (class_437.hasShiftDown()) {
                    ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                    return;
                }
                RoughlyEnoughItemsCore.getConfigManager().openConfigScreen((class_437)ScreenHelper.getLastContainerScreen());
            }

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                class_308.method_1450();
                if (ClientHelper.getInstance().isCheating() && RoughlyEnoughItemsCore.hasOperatorPermission()) {
                    if (RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                        3.fill((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + 20), (int)(this.getBounds().y + 20), (int)721354752);
                    } else {
                        3.fill((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + 20), (int)(this.getBounds().y + 20), (int)1476440063);
                    }
                }
                class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(this.getBounds().x + 3, this.getBounds().y + 3, 0, 0, 14, 14);
            }

            @Override
            public Optional<String> getTooltips() {
                String tooltips = class_1074.method_4662((String)"text.rei.config_tooltip", (Object[])new Object[0]);
                tooltips = tooltips + "\n  ";
                tooltips = !ClientHelper.getInstance().isCheating() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (!RoughlyEnoughItemsCore.hasOperatorPermission() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled_no_perms", (Object[])new Object[0]) : (RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : tooltips + "\n" + class_1074.method_4662((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0])));
                return Optional.ofNullable(tooltips);
            }

            @Override
            public boolean changeFocus(boolean boolean_1) {
                return false;
            }
        });
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().doesShowUtilsButtons()) {
            this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? this.window.method_4486() - 55 : 35, 10, 20, 20, ""){

                @Override
                public void onPressed() {
                    class_310.method_1551().field_1724.method_3142(RoughlyEnoughItemsCore.getConfigManager().getConfig().getGamemodeCommand().replaceAll("\\{gamemode}", ContainerScreenOverlay.this.getNextGameMode(class_437.hasShiftDown()).method_8381()));
                }

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    this.text = ContainerScreenOverlay.this.getGameModeShortText(ContainerScreenOverlay.this.getCurrentGameMode());
                    super.render(mouseX, mouseY, delta);
                }

                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662((String)"text.rei.gamemode_button.tooltip", (Object[])new Object[]{ContainerScreenOverlay.this.getGameModeText(ContainerScreenOverlay.this.getNextGameMode(class_437.hasShiftDown()))}));
                }

                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
            int xxx = RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? this.window.method_4486() - 30 : 10;
            for (final Weather weather : Weather.values()) {
                this.widgets.add(new ButtonWidget(xxx, 35, 20, 20, ""){

                    @Override
                    public void onPressed() {
                        class_310.method_1551().field_1724.method_3142(RoughlyEnoughItemsCore.getConfigManager().getConfig().getWeatherCommand().replaceAll("\\{weather}", weather.name().toLowerCase(Locale.ROOT)));
                    }

                    @Override
                    public void render(int mouseX, int mouseY, float delta) {
                        super.render(mouseX, mouseY, delta);
                        class_308.method_1450();
                        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.blit(this.getBounds().x + 3, this.getBounds().y + 3, weather.getId() * 14, 14, 14, 14);
                    }

                    @Override
                    public Optional<String> getTooltips() {
                        return Optional.ofNullable(class_1074.method_4662((String)"text.rei.weather_button.tooltip", (Object[])new Object[]{class_1074.method_4662((String)weather.getTranslateKey(), (Object[])new Object[0])}));
                    }

                    @Override
                    public boolean changeFocus(boolean boolean_1) {
                        return false;
                    }
                });
                xxx += RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel() ? -25 : 25;
            }
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            this.widgets.add(new ClickableLabelWidget(this.rectangle.x + this.rectangle.width / 2, this.rectangle.y + (RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10, "", this.getTotalPage() > 0){

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    page = class_3532.method_15340((int)page, (int)0, (int)ContainerScreenOverlay.this.getTotalPage());
                    this.text = String.format("%s/%s", page + 1, ContainerScreenOverlay.this.getTotalPage() + 1);
                    super.render(mouseX, mouseY, delta);
                }

                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(class_1074.method_4662((String)"text.rei.go_back_first_page", (Object[])new Object[0]));
                }

                @Override
                public void onLabelClicked() {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    page = 0;
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
                }

                @Override
                public boolean changeFocus(boolean boolean_1) {
                    return false;
                }
            });
            this.buttonRight.enabled = this.getTotalPage() > 0;
            this.buttonLeft.enabled = this.buttonRight.enabled;
        }
        if (ScreenHelper.searchField == null) {
            ScreenHelper.searchField = new SearchFieldWidget(0, 0, 0, 0);
        }
        ScreenHelper.searchField.getBounds().setBounds(this.getTextFieldArea());
        this.widgets.add(ScreenHelper.searchField);
        ScreenHelper.searchField.setText(searchTerm);
        ScreenHelper.searchField.setChangedListener(s -> {
            searchTerm = s;
            entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, true);
        });
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isCraftableFilterEnabled()) {
            this.toggleButtonWidget = new CraftableToggleButtonWidget(this.getCraftableToggleArea()){

                @Override
                public void onPressed() {
                    RoughlyEnoughItemsCore.getConfigManager().toggleCraftableOnly();
                    entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, true);
                }

                @Override
                public void lateRender(int mouseX, int mouseY, float delta) {
                    this.setBlitOffset(300);
                    super.lateRender(mouseX, mouseY, delta);
                }
            };
            this.widgets.add(this.toggleButtonWidget);
        } else {
            this.toggleButtonWidget = null;
        }
        entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, false);
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546()) {
            return Weather.THUNDER;
        }
        if (world.method_8401().method_156()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(class_1934 gameMode) {
        return class_1074.method_4662((String)("text.rei.short_gamemode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private String getGameModeText(class_1934 gameMode) {
        return class_1074.method_4662((String)("selectWorld.gameMode." + gameMode.method_8381()), (Object[])new Object[0]);
    }

    private class_1934 getNextGameMode(boolean reverse) {
        try {
            class_1934 current = this.getCurrentGameMode();
            int next = current.method_8379() + 1;
            if (reverse) {
                next -= 2;
            }
            if (next > 3) {
                next = 0;
            }
            if (next < 0) {
                next = 3;
            }
            return class_1934.method_8384((int)next);
        }
        catch (Exception e) {
            return class_1934.field_9218;
        }
    }

    private class_1934 getCurrentGameMode() {
        return class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_7334().getId()).method_2958();
    }

    private Rectangle getTextFieldArea() {
        int widthRemoved = RoughlyEnoughItemsCore.getConfigManager().getConfig().isCraftableFilterEnabled() ? 22 : 2;
        SearchFieldLocation searchFieldLocation = RoughlyEnoughItemsCore.getConfigManager().getConfig().getSearchFieldLocation();
        if (searchFieldLocation == SearchFieldLocation.BOTTOM_SIDE) {
            return new Rectangle(this.rectangle.x + 2, this.window.method_4502() - 22, this.rectangle.width - 6 - widthRemoved, 18);
        }
        if (searchFieldLocation == SearchFieldLocation.TOP_SIDE) {
            return new Rectangle(this.rectangle.x + 2, 4, this.rectangle.width - 6 - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, this.window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.bounds.x, this.window.method_4502() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft(), this.window.method_4502() - 22, ScreenHelper.getLastContainerScreenHooks().rei_getContainerWidth() - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle searchBoxArea = this.getTextFieldArea();
        searchBoxArea.setLocation(searchBoxArea.x + searchBoxArea.width + 4, searchBoxArea.y - 1);
        searchBoxArea.setSize(20, 20);
        return searchBoxArea;
    }

    private String getCheatModeText() {
        return class_1074.method_4662((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void render(int mouseX, int mouseY, float delta) {
        ContainerScreenHooks hooks;
        List<class_1799> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler() != null && RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler().shouldRecalculateArea(!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel(), this.rectangle)) {
            this.shouldReInit = true;
        }
        if (this.shouldReInit) {
            this.init(true);
        } else if (RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() && (currentStacks.size() != ScreenHelper.inventoryStacks.size() || !this.hasSameListContent(new LinkedList<class_1799>(ScreenHelper.inventoryStacks), currentStacks))) {
            ScreenHelper.inventoryStacks = currentStacks;
            DisplayHelper.DisplayBoundsHandler<?> boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
            entryListWidget.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, true);
        }
        if (SearchFieldWidget.isSearching) {
            class_308.method_1450();
            this.setBlitOffset(200);
            if (class_310.method_1551().field_1755 instanceof class_465) {
                hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
                int left = hooks.rei_getContainerLeft();
                int top = hooks.rei_getContainerTop();
                for (class_1735 slot : ((class_465)class_310.method_1551().field_1755).method_17577().field_7761) {
                    if (slot.method_7681()) {
                        if (EntryListWidget.filterEntry(Entry.create(slot.method_7677()), entryListWidget.getLastSearchArgument())) continue;
                    }
                    this.fillGradient(left + slot.field_7873, top + slot.field_7872, left + slot.field_7873 + 16, top + slot.field_7872 + 16, -601874400, -601874400);
                }
            }
            this.setBlitOffset(0);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_1450();
        this.renderWidgets(mouseX, mouseY, delta);
        if (class_310.method_1551().field_1755 instanceof class_465 && RoughlyEnoughItemsCore.getConfigManager().getConfig().areClickableRecipeArrowsEnabled()) {
            hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()) || !area.getRectangle().contains(mouseX - hooks.rei_getContainerLeft(), mouseY - hooks.rei_getContainerTop())) continue;
                String collect = Arrays.asList(area.getCategories()).stream().map(identifier -> RecipeHelper.getInstance().getCategory((class_2960)identifier).getCategoryName()).collect(Collectors.joining(", "));
                QUEUED_TOOLTIPS.add(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.view_recipes_for", (Object[])new Object[]{collect})));
                break;
            }
        }
    }

    public void lateRender(int mouseX, int mouseY, float delta) {
        if (ScreenHelper.isOverlayVisible()) {
            class_437 currentScreen;
            ScreenHelper.searchField.laterRender(mouseX, mouseY, delta);
            if (this.toggleButtonWidget != null) {
                this.toggleButtonWidget.lateRender(mouseX, mouseY, delta);
            }
            if (!((currentScreen = class_310.method_1551().field_1755) instanceof RecipeViewingScreen) || !((RecipeViewingScreen)currentScreen).choosePageActivated) {
                QUEUED_TOOLTIPS.stream().filter(Objects::nonNull).forEach(this::renderTooltip);
            }
        }
        QUEUED_TOOLTIPS.clear();
    }

    public void renderTooltip(QueuedTooltip tooltip) {
        if (tooltip.getConsumer() == null) {
            this.renderTooltip(tooltip.getText(), tooltip.getX(), tooltip.getY());
        } else {
            tooltip.getConsumer().accept(tooltip);
        }
    }

    public void renderTooltip(List<String> lines, int mouseX, int mouseY) {
        if (lines.isEmpty()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        int width = lines.stream().map(arg_0 -> ((class_327)font).method_1727(arg_0)).max(Integer::compareTo).get();
        int height = lines.size() <= 1 ? 8 : lines.size() * 10;
        ScreenHelper.drawHoveringWidget(mouseX, mouseY, (TriConsumer<Integer, Integer, Float>)((TriConsumer)(x, y, aFloat) -> {
            RenderSystem.disableRescaleNormal();
            class_308.method_1450();
            RenderSystem.disableLighting();
            this.setBlitOffset(1000);
            this.fillGradient(x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864);
            this.fillGradient(x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864);
            this.fillGradient(x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864);
            this.fillGradient(x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864);
            this.fillGradient(x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864);
            this.fillGradient(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 0x505000FF, 1344798847);
            this.fillGradient(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 0x505000FF, 1344798847);
            this.fillGradient(x - 3, y - 3, x + width + 3, y - 3 + 1, 0x505000FF, 0x505000FF);
            this.fillGradient(x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847);
            int currentY = y;
            for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
                RenderSystem.disableDepthTest();
                font.method_1720((String)lines.get(lineIndex), (float)x.intValue(), (float)currentY, -1);
                RenderSystem.enableDepthTest();
                currentY += lineIndex == 0 ? 12 : 10;
            }
            this.setBlitOffset(0);
            RenderSystem.enableLighting();
            class_308.method_1452();
            RenderSystem.enableRescaleNormal();
        }), width, height, 0.0f);
    }

    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        list1.sort(Comparator.comparing(Object::toString));
        list2.sort(Comparator.comparing(Object::toString));
        return list1.stream().map(Objects::toString).collect(Collectors.joining("")).equals(list2.stream().map(Objects::toString).collect(Collectors.joining("")));
    }

    public void addTooltip(@Nullable QueuedTooltip queuedTooltip) {
        if (queuedTooltip != null) {
            QUEUED_TOOLTIPS.add(queuedTooltip);
        }
    }

    public void renderWidgets(int int_1, int int_2, float float_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return;
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            this.buttonRight.enabled = this.getTotalPage() > 0;
            this.buttonLeft.enabled = this.buttonRight.enabled;
        }
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.render(int_1, int_2, float_1);
        });
        class_308.method_1450();
    }

    private int getTotalPage() {
        return entryListWidget.getTotalPage();
    }

    public boolean mouseScrolled(double i, double j, double amount) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (this.isInside(PointHelper.fromMouse())) {
            if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
                if (amount > 0.0 && this.buttonLeft.enabled) {
                    this.buttonLeft.onPressed();
                } else if (amount < 0.0 && this.buttonRight.enabled) {
                    this.buttonRight.onPressed();
                } else {
                    return false;
                }
                return true;
            }
            return entryListWidget.mouseScrolled(i, j, amount);
        }
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(i, j, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible()) {
            for (class_364 class_3642 : this.widgets) {
                if (!class_3642.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        if (ClientHelper.getInstance().getHideKeyBinding().method_1417(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        class_1799 itemStack = null;
        if (class_310.method_1551().field_1755 instanceof class_465 && ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot() != null && !ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677().method_7960()) {
            itemStack = ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().method_7677();
        }
        if (itemStack != null && !itemStack.method_7960()) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            }
            if (ClientHelper.getInstance().getUsageKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
            }
        }
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (ClientHelper.getInstance().getFocusSearchFieldKeyBinding().method_1417(int_1, int_2)) {
            ScreenHelper.searchField.setFocused(true);
            this.setFocused((class_364)ScreenHelper.searchField);
            ScreenHelper.searchField.keybindFocusTime = System.currentTimeMillis();
            ScreenHelper.searchField.keybindFocusKey = int_1;
            return true;
        }
        return false;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.charTyped(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public List<? extends class_364> children() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (class_310.method_1551().field_1755 instanceof class_465 && RoughlyEnoughItemsCore.getConfigManager().getConfig().areClickableRecipeArrowsEnabled()) {
            ContainerScreenHooks hooks = (ContainerScreenHooks)class_310.method_1551().field_1755;
            for (RecipeHelper.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(class_310.method_1551().field_1755.getClass()) || !area.getRectangle().contains(double_1 - (double)hooks.rei_getContainerLeft(), double_2 - (double)hooks.rei_getContainerTop())) continue;
                ClientHelper.getInstance().executeViewAllRecipesFromCategories(Arrays.asList(area.getCategories()));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                return true;
            }
        }
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.mouseClicked(double_1, double_2, int_1)) continue;
            this.setFocused(class_3642);
            if (int_1 == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        return this.getFocused() != null && this.isDragging() && int_1 == 0 ? this.getFocused().mouseDragged(double_1, double_2, int_1, double_3, double_4) : false;
    }

    public boolean isInside(double mouseX, double mouseY) {
        if (!this.rectangle.contains(mouseX, mouseY)) {
            return false;
        }
        for (DisplayHelper.DisplayBoundsHandler<?> handler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(class_310.method_1551().field_1755.getClass())) {
            class_1269 in = handler.isInZone(!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel(), mouseX, mouseY);
            if (in == class_1269.field_5811) continue;
            return in == class_1269.field_5812;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }
}

