/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zeitheron.hammercore.client.utils.Scissors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.api.RunSixtyTimesEverySec;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.Entry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.renderers.FluidRenderer;
import me.shedaniel.rei.gui.renderers.ItemStackRenderer;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

public class EntryListWidget
extends Widget {
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final Comparator<Entry> ASCENDING_COMPARATOR;
    private static List<class_1792> searchBlacklisted;
    private static float scroll;
    private static float scrollVelocity;
    private static float maxScroll;
    protected static RunSixtyTimesEverySec scroller;
    private static float scrollBarAlpha;
    private static float scrollBarAlphaFuture;
    private static long scrollBarAlphaFutureTime;
    private static boolean draggingScrollBar;
    private final List<SearchArgument[]> lastSearchArgument;
    private List<Entry> currentDisplayed = Lists.newArrayList();
    private List<Slot> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;

    public EntryListWidget(int page) {
        this.page = page;
        this.lastSearchArgument = Lists.newArrayList();
        scroller.unregisterTick();
        scrollVelocity = 0.0f;
    }

    public static List<String> tryGetItemStackToolTip(class_1799 itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.method_7909())) {
            try {
                return itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934)).stream().map(class_2561::method_10863).collect(Collectors.toList());
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.method_7909());
            }
        }
        return Collections.singletonList(EntryListWidget.tryGetItemStackName(itemStack));
    }

    public static String tryGetEntryName(Entry stack) {
        if (stack.getEntryType() == Entry.Type.ITEM) {
            return EntryListWidget.tryGetItemStackName(stack.getItemStack());
        }
        if (stack.getEntryType() == Entry.Type.FLUID) {
            return EntryListWidget.tryGetFluidName(stack.getFluid());
        }
        return EMPTY;
    }

    public static String tryGetFluidName(class_3611 fluid) {
        class_2960 id = class_2378.field_11154.method_10221((Object)fluid);
        if (class_1074.method_4663((String)("block." + id.toString().replaceFirst(":", ".")))) {
            return class_1074.method_4662((String)("block." + id.toString().replaceFirst(":", ".")), (Object[])new Object[0]);
        }
        return Stream.of(id.method_12832().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(SPACE));
    }

    public static String tryGetItemStackName(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909())) {
            try {
                return stack.method_7964().method_10863();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        }
        try {
            return class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)stack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static boolean filterEntry(Entry entry, List<SearchArgument[]> arguments) {
        if (arguments.isEmpty()) {
            return true;
        }
        AtomicReference<String> mod = new AtomicReference<String>();
        AtomicReference<String> tooltips = new AtomicReference<String>();
        AtomicReference<String> name = new AtomicReference<String>();
        for (SearchArgument[] arguments1 : arguments) {
            boolean b = true;
            for (SearchArgument argument : arguments1) {
                if (argument.getArgumentType() == SearchArgument.ArgumentType.ALWAYS) {
                    return true;
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.MOD && argument.getFunction(!argument.isInclude()).apply(EntryListWidget.fillMod(entry, mod).get()).booleanValue()) {
                    b = false;
                    break;
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.TOOLTIP && argument.getFunction(!argument.isInclude()).apply(EntryListWidget.fillTooltip(entry, tooltips).get()).booleanValue()) {
                    b = false;
                    break;
                }
                if (argument.getArgumentType() != SearchArgument.ArgumentType.TEXT || !argument.getFunction(!argument.isInclude()).apply(EntryListWidget.fillName(entry, name).get()).booleanValue()) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static AtomicReference<String> fillMod(Entry entry, AtomicReference<String> mod) {
        if (mod.get() == null) {
            if (entry.getEntryType() == Entry.Type.ITEM) {
                mod.set(ClientHelper.getInstance().getModFromItem(entry.getItemStack().method_7909()).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            } else if (entry.getEntryType() == Entry.Type.FLUID) {
                mod.set(ClientHelper.getInstance().getModFromIdentifier(class_2378.field_11154.method_10221((Object)entry.getFluid())).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            }
        }
        return mod;
    }

    private static AtomicReference<String> fillTooltip(Entry entry, AtomicReference<String> mod) {
        if (mod.get() == null) {
            if (entry.getEntryType() == Entry.Type.ITEM) {
                mod.set(EntryListWidget.tryGetItemStackToolTip(entry.getItemStack(), false).stream().collect(Collectors.joining(EMPTY)).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            } else {
                mod.set(EntryListWidget.tryGetFluidName(entry.getFluid()).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            }
        }
        return mod;
    }

    private static AtomicReference<String> fillName(Entry entry, AtomicReference<String> mod) {
        if (mod.get() == null) {
            if (entry.getEntryType() == Entry.Type.ITEM) {
                mod.set(EntryListWidget.tryGetItemStackName(entry.getItemStack()).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            } else {
                mod.set(EntryListWidget.tryGetFluidName(entry.getFluid()).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
            }
        }
        return mod;
    }

    private static void scrollerUnregisterTick() {
        scroller.unregisterTick();
    }

    public static float getMaxScroll() {
        ScreenHelper.getLastOverlay();
        return Math.max(maxScroll - (float)ContainerScreenOverlay.getEntryListWidget().rectangle.height, 0.0f);
    }

    public static float getScroll() {
        return scroll;
    }

    public static float getScrollVelocity() {
        return scrollVelocity;
    }

    public int getFullTotalSlotsPerPage() {
        return this.width * this.height;
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (!scroller.isRegistered()) {
            scroller.registerTick();
        }
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled() && this.rectangle.contains(double_1, double_2)) {
            if (scroll >= 0.0f && double_3 > 0.0) {
                scrollVelocity -= 24.0f;
            } else if (scroll <= this.getMaxScroll() && double_3 < 0.0) {
                scrollVelocity += 24.0f;
            }
            if (scrollBarAlphaFuture == 0.0f) {
                scrollBarAlphaFuture = 1.0f;
            }
            if ((float)(System.currentTimeMillis() - scrollBarAlphaFutureTime) > 300.0f) {
                scrollBarAlphaFutureTime = System.currentTimeMillis();
            }
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    public void render(int int_1, int int_2, float float_1) {
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().doesVillagerScreenHavePermanentScrollBar()) {
            scrollBarAlphaFutureTime = System.currentTimeMillis();
            scrollBarAlphaFuture = 0.0f;
            scrollBarAlpha = 1.0f;
        } else if (scrollBarAlphaFutureTime > 0L) {
            long l = System.currentTimeMillis() - scrollBarAlphaFutureTime;
            if ((float)l > 300.0f) {
                if (scrollBarAlphaFutureTime == 0L) {
                    scrollBarAlpha = scrollBarAlphaFuture;
                    scrollBarAlphaFutureTime = -1L;
                } else if ((float)l > 2000.0f && scrollBarAlphaFuture == 1.0f) {
                    scrollBarAlphaFuture = 0.0f;
                    scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    scrollBarAlpha = scrollBarAlphaFuture;
                }
            } else if (scrollBarAlphaFuture == 0.0f) {
                scrollBarAlpha = Math.min(scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l / 300.0f));
            } else if (scrollBarAlphaFuture == 1.0f) {
                scrollBarAlpha = Math.max(Math.min(1.0f, (float)l / 300.0f), scrollBarAlpha);
            }
        }
        class_308.method_1450();
        RenderSystem.pushMatrix();
        boolean widgetScrolled = RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled();
        if (!widgetScrolled) {
            scroll = 0.0f;
        } else {
            this.page = 0;
            ScreenHelper.getLastOverlay();
            ContainerScreenOverlay.setPage(0);
            Scissors.begin();
            Scissors.scissor(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        }
        this.widgets.forEach(widget -> {
            if (widgetScrolled) {
                widget.y = (int)((float)((Slot)widget).backupY - scroll);
                if (widget.y <= this.rectangle.y + this.rectangle.height && widget.y + widget.getBounds().height >= this.rectangle.y) {
                    widget.render(int_1, int_2, float_1);
                }
            } else {
                widget.render(int_1, int_2, float_1);
            }
        });
        if (widgetScrolled) {
            double height = EntryListWidget.getMaxScroll();
            if (height > (double)this.rectangle.height) {
                class_289 tessellator = class_289.method_1348();
                class_287 buffer = tessellator.method_1349();
                double maxScroll = height;
                int scrollBarHeight = class_3532.method_15357((double)((double)(this.rectangle.height * this.rectangle.height) / maxScroll));
                scrollBarHeight = class_3532.method_15340((int)scrollBarHeight, (int)32, (int)(this.rectangle.height - 8));
                scrollBarHeight = (int)((double)scrollBarHeight - Math.min((double)((double)scroll < 0.0 ? (float)((int)(-scroll)) : ((double)scroll > (double)this.getMaxScroll() ? (float)((int)scroll) - this.getMaxScroll() : 0.0f)), (double)scrollBarHeight * 0.75));
                int minY = (int)Math.min(Math.max((double)((int)this.getScroll() * (this.rectangle.height - scrollBarHeight)) / maxScroll + (double)this.rectangle.y, (double)this.rectangle.y), (double)(this.rectangle.getMaxY() - scrollBarHeight));
                double scrollbarPositionMinX = this.rectangle.getMaxX() - 6;
                double scrollbarPositionMaxX = this.rectangle.getMaxX() - 1;
                class_308.method_1450();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.disableAlphaTest();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.shadeModel((int)7425);
                buffer.method_1328(7, class_290.field_1576);
                float b = ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f;
                buffer.method_22912(scrollbarPositionMinX, (double)(minY + scrollBarHeight), 1000.0).method_22915(b, b, b, scrollBarAlpha).method_1344();
                buffer.method_22912(scrollbarPositionMaxX, (double)(minY + scrollBarHeight), 1000.0).method_22915(b, b, b, scrollBarAlpha).method_1344();
                buffer.method_22912(scrollbarPositionMaxX, (double)minY, 1000.0).method_22915(b, b, b, scrollBarAlpha).method_1344();
                buffer.method_22912(scrollbarPositionMinX, (double)minY, 1000.0).method_22915(b, b, b, scrollBarAlpha).method_1344();
                tessellator.method_1350();
                RenderSystem.shadeModel((int)7424);
                RenderSystem.disableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
            }
            Scissors.end();
        }
        RenderSystem.popMatrix();
        class_746 player = this.minecraft.field_1724;
        if (this.rectangle.contains(PointHelper.fromMouse()) && ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    public void updateList(DisplayHelper.DisplayBoundsHandler<?> boundsHandler, Rectangle rectangle, int page, String searchTerm, boolean processSearchTerm) {
        this.rectangle = rectangle;
        this.page = page;
        this.widgets = Lists.newCopyOnWriteArrayList();
        this.calculateListSize(rectangle);
        if (this.currentDisplayed.isEmpty() || processSearchTerm) {
            this.currentDisplayed = this.processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getEntryRegistry().getEntryList(), new ArrayList<class_1799>(ScreenHelper.inventoryStacks));
        }
        int startX = rectangle.getCenterX() - this.width * 9;
        int startY = rectangle.getCenterY() - this.height * 9;
        this.listArea = new Rectangle(startX, startY, this.width * 18, this.height * 18);
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(startX, startY, this.listArea);
        int j = page * fitSlotsPerPage;
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            this.height = Integer.MAX_VALUE;
            j = 0;
        }
        float maxScroll = 0.0f;
        for (int yy = 0; yy < this.height; ++yy) {
            for (int xx = 0; xx < this.width; ++xx) {
                int x = startX + xx * 18;
                int y = startY + yy * 18;
                if (!this.canBeFit(x, y, this.listArea)) continue;
                if (++j > this.currentDisplayed.size()) break;
                final Entry entry = this.currentDisplayed.get(j - 1);
                maxScroll = y + 18;
                this.widgets.add(new Slot(entry, xx, yy, x, y, entry.getEntryType() == Entry.Type.ITEM ? new ItemStackRenderer(){

                    @Override
                    public class_1799 getItemStack() {
                        return entry.getItemStack();
                    }

                    @Override
                    protected String getCounts() {
                        return EntryListWidget.EMPTY;
                    }

                    @Override
                    protected boolean renderOverlay() {
                        return RoughlyEnoughItemsCore.getConfigManager().getConfig().doesRenderEntryExtraOverlay();
                    }

                    @Override
                    @Nullable
                    public QueuedTooltip getQueuedTooltip(float delta) {
                        class_746 player = EntryListWidget.this.minecraft.field_1724;
                        if (!ClientHelper.getInstance().isCheating() || player.field_7514.method_7399().method_7960()) {
                            return super.getQueuedTooltip(delta);
                        }
                        return null;
                    }
                } : new FluidRenderer(){

                    @Override
                    public class_3611 getFluid() {
                        return entry.getFluid();
                    }

                    @Override
                    protected List<String> getExtraToolTips(class_3611 fluid) {
                        if (class_310.method_1551().field_1690.field_1827) {
                            return Collections.singletonList(class_124.field_1063.toString() + class_2378.field_11154.method_10221((Object)fluid).toString());
                        }
                        return super.getExtraToolTips(fluid);
                    }
                }, false, true, true){

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int button) {
                        if (this.isCurrentRendererItem() && this.containsMouse(mouseX, mouseY)) {
                            if (ClientHelper.getInstance().isCheating()) {
                                if (this.getCurrentItemStack() != null && !this.getCurrentItemStack().method_7960()) {
                                    class_1799 cheatedStack = this.getCurrentItemStack().method_7972();
                                    if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getItemCheatingMode() == ItemCheatingMode.REI_LIKE) {
                                        cheatedStack.method_7939(button != 1 ? 1 : cheatedStack.method_7914());
                                    } else if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getItemCheatingMode() == ItemCheatingMode.JEI_LIKE) {
                                        cheatedStack.method_7939(button != 0 ? 1 : cheatedStack.method_7914());
                                    } else {
                                        cheatedStack.method_7939(1);
                                    }
                                    return ClientHelper.getInstance().tryCheatingStack(cheatedStack);
                                }
                            } else {
                                if (button == 0) {
                                    return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack().method_7972());
                                }
                                if (button == 1) {
                                    return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack().method_7972());
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            if (j > this.currentDisplayed.size()) break;
        }
        EntryListWidget.maxScroll = maxScroll;
        if (!scroller.isRegistered()) {
            scroller.registerTick();
        }
    }

    public int getTotalPage() {
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isEntryListWidgetScrolled()) {
            return 1;
        }
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(this.listArea.x, this.listArea.y, this.listArea);
        if (fitSlotsPerPage > 0) {
            return class_3532.method_15386((float)(this.getCurrentDisplayed().size() / fitSlotsPerPage));
        }
        return 0;
    }

    public int getTotalFitSlotsPerPage(int startX, int startY, Rectangle listArea) {
        int slots = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.canBeFit(startX + x * 18, startY + y * 18, listArea)) continue;
                ++slots;
            }
        }
        return slots;
    }

    public boolean canBeFit(int left, int top, Rectangle listArea) {
        for (DisplayHelper.DisplayBoundsHandler<?> sortedBoundsHandler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(this.minecraft.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLeftHandSidePanel(), left, top, this.minecraft.field_1755, listArea);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        float height;
        if (int_1 == 0 && scrollBarAlpha > 0.0f && draggingScrollBar && (height = maxScroll) > (float)(actualHeight = this.rectangle.height) && mouseY >= (double)this.rectangle.y && mouseY <= (double)this.rectangle.getMaxY()) {
            double double_5 = Math.max(1.0f, this.getMaxScroll());
            int int_2 = this.rectangle.height;
            int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / maxScroll)), (int)32, (int)(int_2 - 8));
            double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
            scroll = class_3532.method_15363((float)((float)((double)scroll + double_4 * double_6)), (float)0.0f, (float)(height - (float)this.rectangle.height));
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.rectangle.contains(PointHelper.fromMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Entry> getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<Entry> processSearchTerm(String searchTerm, List<Entry> ol, List<class_1799> inventoryItems) {
        this.lastSearchArgument.clear();
        List<Entry> os = new LinkedList<Entry>(ol);
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getItemListOrdering() != ItemListOrdering.registry) {
            os = ol.stream().sorted(ASCENDING_COMPARATOR).collect(Collectors.toList());
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isItemListAscending()) {
            Collections.reverse(os);
        }
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            String[] split = StringUtils.split((String)s);
            SearchArgument[] arguments = new SearchArgument[split.length];
            for (int i = 0; i < split.length; ++i) {
                String s1 = split[i];
                arguments[i] = s1.startsWith("@-") || s1.startsWith("-@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false) : (s1.startsWith("@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true) : (s1.startsWith("#-") || s1.startsWith("-#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false) : (s1.startsWith("#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true) : (s1.startsWith("-") ? new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false) : new SearchArgument(SearchArgument.ArgumentType.TEXT, s1, true)))));
            }
            if (arguments.length > 0) {
                this.lastSearchArgument.add(arguments);
            } else {
                this.lastSearchArgument.add(new SearchArgument[]{SearchArgument.ALWAYS});
            }
        });
        List<Object> stacks = Collections.emptyList();
        stacks = this.lastSearchArgument.isEmpty() ? os : os.stream().filter(entry -> EntryListWidget.filterEntry(entry, this.lastSearchArgument)).collect(Collectors.toList());
        if (!RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() || stacks.isEmpty() || inventoryItems.isEmpty()) {
            return Collections.unmodifiableList(stacks);
        }
        List<class_1799> workingItems = RecipeHelper.getInstance().findCraftableByItems(inventoryItems);
        LinkedList newList = Lists.newLinkedList();
        for (class_1799 workingItem : workingItems) {
            Optional<Entry> any = stacks.stream().filter(i -> i.getItemStack() != null && i.getItemStack().method_7962(workingItem)).findAny();
            if (!any.isPresent()) continue;
            newList.add(any.get());
        }
        if (newList.isEmpty()) {
            return Collections.unmodifiableList(stacks);
        }
        return Collections.unmodifiableList(newList);
    }

    public List<SearchArgument[]> getLastSearchArgument() {
        return this.lastSearchArgument;
    }

    public void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = EntryListWidget.getMaxScroll();
        if (height > (double)(actualHeight = this.rectangle.height) && scrollBarAlpha > 0.0f && double_2 >= (double)this.rectangle.y && double_2 <= (double)this.rectangle.getMaxY() && double_1 >= (scrollbarPositionMinX = (double)(this.rectangle.getMaxX() - 6)) - 2.0 & double_1 <= scrollbarPositionMinX + 8.0) {
            draggingScrollBar = true;
            scrollBarAlpha = 1.0f;
            return true;
        }
        draggingScrollBar = false;
        if (this.rectangle.contains(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Slot> children() {
        return this.widgets;
    }

    static {
        searchBlacklisted = Lists.newArrayList();
        scroller = () -> {
            try {
                if (scrollVelocity == 0.0f && scroll >= 0.0f && scroll <= EntryListWidget.getMaxScroll()) {
                    EntryListWidget.scrollerUnregisterTick();
                } else {
                    float change = scrollVelocity * 0.3f;
                    if (scrollVelocity != 0.0f && Math.abs(scrollVelocity = (float)((double)scrollVelocity - (double)scrollVelocity * ((scroll += change) >= 0.0f && scroll <= EntryListWidget.getMaxScroll() ? 0.2 : 0.4))) < 0.1f) {
                        scrollVelocity = 0.0f;
                    }
                    if (scroll < 0.0f && scrollVelocity == 0.0f) {
                        if (Math.abs(scroll = Math.min(scroll + (0.0f - scroll) * 0.2f, 0.0f)) < 0.1f) {
                            scroll = 0.0f;
                        }
                    } else if (scroll > EntryListWidget.getMaxScroll() && scrollVelocity == 0.0f && (scroll = Math.max(scroll - (scroll - EntryListWidget.getMaxScroll()) * 0.2f, EntryListWidget.getMaxScroll())) > EntryListWidget.getMaxScroll() && scroll < EntryListWidget.getMaxScroll() + 0.1f) {
                        scroll = EntryListWidget.getMaxScroll();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        scrollBarAlpha = 0.0f;
        scrollBarAlphaFuture = 0.0f;
        scrollBarAlphaFutureTime = -1L;
        draggingScrollBar = false;
        ASCENDING_COMPARATOR = (entry, entry1) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getItemListOrdering().equals((Object)ItemListOrdering.name)) {
                return EntryListWidget.tryGetEntryName(entry).compareToIgnoreCase(EntryListWidget.tryGetEntryName(entry1));
            }
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().getItemListOrdering().equals((Object)ItemListOrdering.item_groups) && entry.getEntryType() == Entry.Type.ITEM && entry1.getEntryType() == Entry.Type.ITEM) {
                class_1799 stack0 = entry.getItemStack();
                class_1799 stack1 = entry1.getItemStack();
                List<class_1761> itemGroups = Arrays.asList(class_1761.field_7921);
                return itemGroups.indexOf(stack0.method_7909().method_7859()) - itemGroups.indexOf(stack1.method_7909().method_7859());
            }
            return 0;
        };
    }

    public class Slot
    extends SlotWidget {
        private final int backupY;
        private int xx;
        private int yy;
        private Entry entry;

        public Slot(Entry entry, int xx, int yy, int x, int y, Renderer renderer, boolean drawBackground, boolean showToolTips, boolean clickToMoreRecipes) {
            super(x, y, renderer, drawBackground, showToolTips, clickToMoreRecipes);
            this.xx = xx;
            this.yy = yy;
            this.backupY = y;
            this.entry = entry;
        }

        public int getBackupY() {
            return this.backupY;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public int getXx() {
            return this.xx;
        }

        public int getYy() {
            return this.yy;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.rectangle.contains(mouseX, mouseY);
        }
    }
}

