/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.renderers.FluidRenderer;
import me.shedaniel.rei.gui.renderers.ItemStackRenderer;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_364;

public class SlotWidget
extends WidgetWithBounds {
    public static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final class_2960 RECIPE_GUI_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    protected int x;
    protected int y;
    private List<Renderer> renderers = new LinkedList<Renderer>();
    private boolean drawBackground;
    private boolean showToolTips;
    private boolean clickToMoreRecipes;
    private boolean drawHighlightedBackground;

    public SlotWidget(int x, int y, Renderer renderer, boolean drawBackground, boolean showToolTips) {
        this(x, y, Collections.singletonList(renderer), drawBackground, showToolTips);
    }

    public SlotWidget(int x, int y, Renderer renderer, boolean drawBackground, boolean showToolTips, boolean clickToMoreRecipes) {
        this(x, y, Collections.singletonList(renderer), drawBackground, showToolTips, clickToMoreRecipes);
    }

    public SlotWidget(int x, int y, List<Renderer> renderers, boolean drawBackground, boolean showToolTips) {
        this.renderers = renderers;
        this.drawBackground = drawBackground;
        this.showToolTips = showToolTips;
        this.x = x;
        this.y = y;
        this.clickToMoreRecipes = false;
        this.drawHighlightedBackground = true;
    }

    public SlotWidget(int x, int y, List<Renderer> itemList, boolean drawBackground, boolean showToolTips, boolean clickToMoreRecipes) {
        this(x, y, itemList, drawBackground, showToolTips);
        this.clickToMoreRecipes = clickToMoreRecipes;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isShowToolTips() {
        return this.showToolTips;
    }

    public void setShowToolTips(boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    public boolean isClickToMoreRecipes() {
        return this.clickToMoreRecipes;
    }

    public void setClickToMoreRecipes(boolean clickToMoreRecipes) {
        this.clickToMoreRecipes = clickToMoreRecipes;
    }

    public boolean isDrawHighlightedBackground() {
        return this.drawHighlightedBackground;
    }

    public void setDrawHighlightedBackground(boolean drawHighlightedBackground) {
        this.drawHighlightedBackground = drawHighlightedBackground;
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public void render(int mouseX, int mouseY, float delta) {
        QueuedTooltip queuedTooltip;
        Renderer renderer = this.getCurrentRenderer();
        boolean darkTheme = ScreenHelper.isDarkModeEnabled();
        if (this.drawBackground) {
            this.minecraft.method_1531().method_22813(darkTheme ? RECIPE_GUI_DARK : RECIPE_GUI);
            this.blit(this.x - 1, this.y - 1, 0, 222, 18, 18);
        }
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        renderer.setBlitOffset(200);
        renderer.render(this.x + 8, this.y + 6, mouseX, mouseY, delta);
        if (highlighted && this.showToolTips && (queuedTooltip = renderer.getQueuedTooltip(delta)) != null) {
            ScreenHelper.getLastOverlay().addTooltip(queuedTooltip);
        }
        if (this.drawHighlightedBackground && highlighted) {
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int color = darkTheme ? -1877929711 : -2130706433;
            this.setBlitOffset(300);
            this.fillGradient(this.x, this.y, this.x + 16, this.y + 16, color, color);
            this.setBlitOffset(0);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
        }
    }

    @Deprecated
    protected void queueTooltip(class_3611 fluid, float delta) {
        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltip(fluid)));
    }

    @Deprecated
    private List<String> getTooltip(class_3611 fluid) {
        ArrayList toolTip = Lists.newArrayList((Object[])new String[]{EntryListWidget.tryGetFluidName(fluid)});
        toolTip.addAll(this.getExtraFluidToolTips(fluid));
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().shouldAppendModNames()) {
            String modString = ClientHelper.getInstance().getFormattedModFromIdentifier(class_2378.field_11154.method_10221((Object)fluid));
            boolean alreadyHasMod = false;
            for (String s : toolTip) {
                if (!s.equalsIgnoreCase(modString)) continue;
                alreadyHasMod = true;
                break;
            }
            if (!alreadyHasMod) {
                toolTip.add(modString);
            }
        }
        return toolTip;
    }

    @Deprecated
    protected void queueTooltip(class_1799 itemStack, float delta) {
        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltip(itemStack)));
    }

    @Deprecated
    protected List<String> getTooltip(class_1799 itemStack) {
        ArrayList toolTip = Lists.newArrayList(EntryListWidget.tryGetItemStackToolTip(itemStack, true));
        toolTip.addAll(this.getExtraItemToolTips(itemStack));
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().shouldAppendModNames()) {
            String modString = ClientHelper.getInstance().getFormattedModFromItem(itemStack.method_7909());
            String s1 = ClientHelper.getInstance().getModFromItem(itemStack.method_7909()).toLowerCase(Locale.ROOT);
            if (!modString.isEmpty()) {
                toolTip.removeIf(s -> !s.equals(toolTip.get(0)) && class_124.method_539((String)s).equalsIgnoreCase(s1));
                toolTip.add(modString);
            }
        }
        return toolTip;
    }

    @Deprecated
    protected List<String> getExtraItemToolTips(class_1799 stack) {
        return Collections.emptyList();
    }

    @Deprecated
    protected List<String> getExtraFluidToolTips(class_3611 fluid) {
        return Collections.emptyList();
    }

    public class_1799 getCurrentItemStack() {
        if (this.getCurrentRenderer() instanceof ItemStackRenderer) {
            return ((ItemStackRenderer)this.getCurrentRenderer()).getItemStack();
        }
        return class_1799.field_8037;
    }

    public Renderer getCurrentRenderer() {
        if (this.renderers.isEmpty()) {
            return Renderer.empty();
        }
        return this.renderers.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.renderers.size() / 1.0)));
    }

    @Deprecated
    public void setItemList(List<class_1799> itemList) {
        this.setRenderers(itemList.stream().map(Renderer::fromItemStack).collect(Collectors.toList()));
    }

    public void setRenderers(List<Renderer> renderers) {
        this.renderers = renderers;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x - 1, this.y - 1, 18, 18);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.isCurrentRendererItem() && this.getBounds().contains(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack());
            }
            if (button == 1) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack());
            }
        }
        return false;
    }

    public boolean isCurrentRendererItem() {
        return this.getCurrentRenderer() instanceof ItemStackRenderer;
    }

    public boolean isCurrentRendererFluid() {
        return this.getCurrentRenderer() instanceof FluidRenderer;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.isCurrentRendererItem() && this.getBounds().contains(PointHelper.fromMouse())) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack());
            }
            if (ClientHelper.getInstance().getUsageKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack());
            }
        }
        return false;
    }
}

