/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import com.google.common.collect.Lists;
import me.shedaniel.rei.server.ContainerInfo;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface TransferRecipeDisplay extends RecipeDisplay {
    
    int getWidth();
    
    int getHeight();
    
    default List<List<class_1799>> getOrganisedInput(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        List<List<class_1799>> list = Lists.newArrayListWithCapacity(containerInfo.getCraftingWidth(container) * containerInfo.getCraftingHeight(container));
        for (int i = 0; i < containerInfo.getCraftingWidth(container) * containerInfo.getCraftingHeight(container); i++) {
            list.add(Lists.newArrayList());
        }
        return list;
    }
    
    default List<List<EntryStack>> getOrganisedInputEntries(ContainerInfo<class_1703> containerInfo, class_1703 container) {
        List<List<class_1799>> input = getOrganisedInput(containerInfo, container);
        if (input.isEmpty())
            return Collections.emptyList();
        List<List<EntryStack>> list = new ArrayList<>();
        for (List<class_1799> stacks : input) {
            List<EntryStack> entries = new ArrayList<>();
            for (class_1799 stack : stacks) {
                entries.add(EntryStack.create(stack));
            }
            list.add(entries);
        }
        return list;
    }
    
}
