/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.renderers;

import com.google.common.collect.Lists;
import me.shedaniel.math.compat.RenderHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ItemStackRenderOverlayHook;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_918;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;

public abstract class ItemStackRenderer extends Renderer {
    
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    /**
     * @deprecated This boolean is no longer used
     */
    @Deprecated
    public boolean drawTooltip = false;
    
    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        int l = x - 8, i1 = y - 6;
        class_1799 stack = getItemStack();
        ((ItemStackRenderOverlayHook) (Object) stack).rei_setRenderOverlay(renderOverlay());
        RenderHelper.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        class_918 itemRenderer = class_310.method_1551().method_1480();
        itemRenderer.field_4730 = blitOffset;
        class_308.method_1453();
        RenderHelper.colorMask(true, true, true, true);
        RenderHelper.enableLighting();
        RenderHelper.enableRescaleNormal();
        RenderHelper.enableDepthTest();
        itemRenderer.method_4023(stack, l, i1);
        itemRenderer.method_4022(class_310.method_1551().field_1772, stack, l, i1, getCounts());
        itemRenderer.field_4730 = 0.0F;
        this.blitOffset = 0;
    }
    
    /**
     * Queue a tooltip to the REI overlay
     *
     * @param itemStack the stack to queue
     * @param delta     the delta
     * @deprecated Use {@link Renderer#getQueuedTooltip(float)} instead and queue manually
     */
    @Deprecated
    protected void queueTooltip(class_1799 itemStack, float delta) {
        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(getTooltip(itemStack)));
    }
    
    @Nullable
    @Override
    public QueuedTooltip getQueuedTooltip(float delta) {
        return QueuedTooltip.create(getTooltip(getItemStack()));
    }
    
    protected boolean renderCounts() {
        return true;
    }
    
    protected boolean renderOverlay() {
        return true;
    }
    
    protected String getCounts() {
        return renderCounts() ? null : "";
    }
    
    protected List<String> getTooltip(class_1799 itemStack) {
        List<String> toolTip = Lists.newArrayList(EntryListWidget.tryGetItemStackToolTip(itemStack, true));
        toolTip.addAll(getExtraToolTips(itemStack));
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().shouldAppendModNames()) {
            final String modString = ClientHelper.getInstance().getFormattedModFromItem(itemStack.method_7909());
            boolean alreadyHasMod = false;
            for (String s : toolTip)
                if (s.equalsIgnoreCase(modString)) {
                    alreadyHasMod = true;
                    break;
                }
            if (!alreadyHasMod)
                toolTip.add(modString);
        }
        return toolTip;
    }
    
    protected List<String> getExtraToolTips(class_1799 stack) {
        return Collections.emptyList();
    }
    
    public abstract class_1799 getItemStack();
    
}
