/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.compat.RenderHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Entry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.ItemStackRenderOverlayHook;
import me.shedaniel.rei.gui.widget.EntryListWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_918;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Deprecated
public class ItemEntryStack extends AbstractEntryStack {
    
    private class_1799 itemStack;
    
    public ItemEntryStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }
    
    @Override
    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11142.method_10221(getItem()));
    }
    
    @Override
    public Type getType() {
        return Type.ITEM;
    }
    
    @Override
    public int getAmount() {
        return itemStack.method_7947();
    }
    
    @Override
    public void setAmount(int amount) {
        itemStack.method_7939(amount);
    }
    
    @Override
    public boolean isEmpty() {
        return itemStack.method_7960();
    }
    
    @Override
    public Entry toEntry() {
        return Entry.create(getItemStack());
    }
    
    @Override
    public EntryStack copy() {
        EntryStack stack = EntryStack.create(getItemStack().method_7972());
        for (Map.Entry<Settings, Object> entry : getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }
    
    @Override
    public Object getObject() {
        return itemStack;
    }
    
    @Override
    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        return itemStack.method_7909() == stack.getItem();
    }
    
    @Override
    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem() || getAmount() != stack.getAmount())
            return false;
        return class_1799.method_7975(itemStack, stack.getItemStack());
    }
    
    @Override
    public boolean equalsIgnoreAmount(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem())
            return false;
        return class_1799.method_7975(itemStack, stack.getItemStack());
    }
    
    @Override
    public boolean equalsIgnoreTags(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem())
            return false;
        return getAmount() == stack.getAmount();
    }
    
    @Nullable
    @Override
    public QueuedTooltip getTooltip(int mouseX, int mouseY) {
        if (!getSetting(Settings.TOOLTIP_ENABLED).value().get() || isEmpty())
            return null;
        List<String> toolTip = Lists.newArrayList(EntryListWidget.tryGetItemStackToolTip(getItemStack(), true));
        toolTip.addAll(getSetting(Settings.TOOLTIP_APPEND_EXTRA).value().apply(this));
        if (getSetting(Settings.TOOLTIP_APPEND_MOD).value().get() && RoughlyEnoughItemsCore.getConfigManager().getConfig().shouldAppendModNames()) {
            final String modString = ClientHelper.getInstance().getFormattedModFromItem(getItem());
            boolean alreadyHasMod = false;
            for (String s : toolTip)
                if (s.equalsIgnoreCase(modString)) {
                    alreadyHasMod = true;
                    break;
                }
            if (!alreadyHasMod)
                toolTip.add(modString);
        }
        return QueuedTooltip.create(toolTip);
    }
    
    @Override
    public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (getSetting(Settings.RENDER).value().get()) {
            class_1799 stack = getItemStack().method_7972();
            ((ItemStackRenderOverlayHook) (Object) stack).rei_setRenderOverlay(getSetting(Settings.Item.RENDER_OVERLAY).value().get());
            RenderHelper.color4f(1.0F, 1.0F, 1.0F, 1.0F);
            class_918 itemRenderer = class_310.method_1551().method_1480();
            itemRenderer.field_4730 = getZ();
            class_308.method_1453();
            RenderHelper.colorMask(true, true, true, true);
            RenderHelper.enableLighting();
            RenderHelper.enableRescaleNormal();
            RenderHelper.enableDepthTest();
            int i1 = bounds.getCenterX() - 8;
            int i2 = bounds.getCenterY() - 8;
            itemRenderer.method_4023(stack, i1, i2);
            itemRenderer.method_4022(class_310.method_1551().field_1772, stack, i1, i2, getSetting(Settings.RENDER_COUNTS).value().get() ? getSetting(Settings.COUNTS).value().apply(this) : "");
            itemRenderer.field_4730 = 0.0F;
        }
    }
}
