/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.crafting;

import me.shedaniel.rei.api.EntryStack;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2960;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultShapedDisplay implements DefaultCraftingDisplay {
    
    private class_1869 display;
    private List<List<EntryStack>> input;
    private List<EntryStack> output;
    
    public DefaultShapedDisplay(class_1869 recipe) {
        this.display = recipe;
        this.input = recipe.method_8117().stream().map(i -> {
            List<EntryStack> entries = new ArrayList<>();
            for (class_1799 stack : i.method_8105()) {
                if (stack.method_7909() instanceof class_1812)
                    entries.add(EntryStack.create(stack).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
                else entries.add(EntryStack.create(stack));
            }
            return entries;
        }).collect(Collectors.toList());
        if (recipe.method_8110().method_7909() instanceof class_1812)
            this.output = Collections.singletonList(EntryStack.create(recipe.method_8110()).setting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
        else this.output = Collections.singletonList(EntryStack.create(recipe.method_8110()));
    }
    
    @Override
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(display).map(class_1869::method_8114);
    }
    
    @Override
    public List<List<EntryStack>> getInputEntries() {
        return input;
    }
    
    @Override
    public List<EntryStack> getOutputEntries() {
        return output;
    }
    
    @Override
    public List<List<EntryStack>> getRequiredEntries() {
        return input;
    }
    
    @Override
    public int getHeight() {
        return display.method_8158();
    }
    
    @Override
    public Optional<class_1860<?>> getOptionalRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public int getWidth() {
        return display.method_8150();
    }
    
}
