/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.stonecutting;

import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3972;
import net.minecraft.class_3975;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultStoneCuttingDisplay implements RecipeDisplay {
    
    private List<List<EntryStack>> inputs;
    private List<EntryStack> output;
    private class_3975 display;
    
    public DefaultStoneCuttingDisplay(class_3975 recipe) {
        this(recipe.method_8117(), recipe.method_8110());
        this.display = recipe;
    }
    
    public DefaultStoneCuttingDisplay(class_2371<class_1856> ingredients, class_1799 output) {
        this.inputs = ingredients.stream().map(i -> {
            List<EntryStack> entries = new ArrayList<>();
            for (class_1799 stack : i.method_8105()) {
                entries.add(EntryStack.create(stack));
            }
            return entries;
        }).collect(Collectors.toList());
        this.output = Collections.singletonList(EntryStack.create(output));
    }
    
    @Override
    public Optional<class_2960> getRecipeLocation() {
        return Optional.ofNullable(display).map(class_3972::method_8114);
    }
    
    @Override
    public List<List<EntryStack>> getInputEntries() {
        return inputs;
    }
    
    @Override
    public List<EntryStack> getOutputEntries() {
        return output;
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.STONE_CUTTING;
    }
    
    @Override
    public List<List<EntryStack>> getRequiredEntries() {
        return getInputEntries();
    }
}
