/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.Entry;
import me.shedaniel.rei.api.ObjectHolder;
import me.shedaniel.rei.api.annotations.ToBeRemoved;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.EmptyEntryStack;
import me.shedaniel.rei.impl.FluidEntryStack;
import me.shedaniel.rei.impl.ItemEntryStack;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public interface EntryStack {
    public static EntryStack empty() {
        return EmptyEntryStack.EMPTY;
    }

    public static EntryStack create(class_3611 fluid) {
        return EntryStack.create(fluid, 1000);
    }

    public static EntryStack create(class_3611 fluid, int amount) {
        return new FluidEntryStack(fluid, amount);
    }

    public static EntryStack create(class_1799 stack) {
        return new ItemEntryStack(stack);
    }

    public static EntryStack create(class_1935 item) {
        return new ItemEntryStack(new class_1799(item));
    }

    public static EntryStack create(class_2248 block) {
        return new ItemEntryStack(new class_1799((class_1935)block));
    }

    public Optional<class_2960> getIdentifier();

    public Type getType();

    public int getAmount();

    public void setAmount(int var1);

    public boolean isEmpty();

    @ToBeRemoved
    @Deprecated
    public Entry toEntry();

    public EntryStack copy();

    public Object getObject();

    public boolean equals(EntryStack var1, boolean var2, boolean var3);

    public boolean equalsIgnoreTagsAndAmount(EntryStack var1);

    public boolean equalsIgnoreTags(EntryStack var1);

    public boolean equalsIgnoreAmount(EntryStack var1);

    public boolean equalsAll(EntryStack var1);

    public int getZ();

    public void setZ(int var1);

    default public class_1799 getItemStack() {
        if (this.getType() == Type.ITEM) {
            return (class_1799)this.getObject();
        }
        return null;
    }

    default public class_1792 getItem() {
        if (this.getType() == Type.ITEM) {
            return ((class_1799)this.getObject()).method_7909();
        }
        return null;
    }

    default public class_3611 getFluid() {
        if (this.getType() == Type.FLUID) {
            return (class_3611)this.getObject();
        }
        return null;
    }

    public <T> EntryStack setting(Settings<T> var1, T var2);

    public <T> EntryStack removeSetting(Settings<T> var1);

    public EntryStack clearSettings();

    default public <T> EntryStack addSetting(Settings<T> settings, T value) {
        return this.setting(settings, value);
    }

    public <T> ObjectHolder<T> getSetting(Settings<T> var1);

    @Nullable
    public QueuedTooltip getTooltip(int var1, int var2);

    public void render(Rectangle var1, int var2, int var3, float var4);

    public static class Settings<T> {
        public static final Supplier<Boolean> TRUE = () -> true;
        public static final Supplier<Boolean> FALSE = () -> false;
        public static final Settings<Supplier<Boolean>> RENDER = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Supplier<Boolean>> CHECK_TAGS = new Settings<Supplier<Boolean>>(FALSE);
        public static final Settings<Supplier<Boolean>> TOOLTIP_ENABLED = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Supplier<Boolean>> TOOLTIP_APPEND_MOD = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Supplier<Boolean>> RENDER_COUNTS = new Settings<Supplier<Boolean>>(TRUE);
        public static final Settings<Function<EntryStack, List<String>>> TOOLTIP_APPEND_EXTRA = new Settings<Function<EntryStack, List>>(stack -> Collections.emptyList());
        public static final Settings<Function<EntryStack, String>> COUNTS = new Settings<Function<EntryStack, String>>(stack -> null);
        private T defaultValue;

        public Settings(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public static class Item {
            public static final Settings<Supplier<Boolean>> RENDER_OVERLAY = new Settings<Supplier<Boolean>>(TRUE);

            private Item() {
            }
        }
    }

    public static enum Type {
        ITEM,
        FLUID,
        EMPTY;

    }
}

