/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.impl.ConfigObjectImpl;
import me.zeroeightsix.fiber.JanksonSettings;
import me.zeroeightsix.fiber.exception.FiberException;
import me.zeroeightsix.fiber.tree.Node;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ConfigManagerImpl
implements ConfigManager {
    private final File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "roughlyenoughitems/config.json5");
    private ConfigObject config;
    private boolean craftableOnly = false;

    public ConfigManagerImpl() {
        try {
            this.loadConfig();
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Config is loaded.");
        }
        catch (IOException | FiberException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveConfig() throws IOException, FiberException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() && !this.configFile.createNewFile()) {
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to save config! Overwriting with default config.");
            this.config = new ConfigObjectImpl();
            return;
        }
        try {
            new JanksonSettings().serialize((Node)this.config.getConfigNode(), Files.newOutputStream(this.configFile.toPath(), new OpenOption[0]), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to save config! Overwriting with default config.");
            this.config = new ConfigObjectImpl();
            return;
        }
    }

    @Override
    public void loadConfig() throws IOException, FiberException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            RoughlyEnoughItemsCore.LOGGER.warn("[REI] Config not found! Creating one.");
            this.config = new ConfigObjectImpl();
            this.saveConfig();
            return;
        }
        boolean failed = false;
        try {
            this.config = new ConfigObjectImpl();
            new JanksonSettings().deserialize((Node)this.config.getConfigNode(), Files.newInputStream(this.configFile.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            failed = true;
        }
        if (failed || this.config == null) {
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to load config! Overwriting with default config.");
            this.config = new ConfigObjectImpl();
        }
        this.saveConfig();
    }

    @Override
    public ConfigObject getConfig() {
        return this.config;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly;
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public void openConfigScreen(class_437 parent) {
        class_310.method_1551().method_1507(this.getConfigScreen(parent));
    }

    @Override
    public class_437 getConfigScreen(final class_437 parent) {
        if (FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            try {
                return (class_437)class_437.class.cast(Class.forName("me.shedaniel.rei.utils.ClothScreenRegistry").getDeclaredMethod("getConfigScreen", class_437.class).invoke(null, parent));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new class_437((class_2561)new class_2585("")){

            public void render(int int_1, int int_2, float float_1) {
                this.renderDirtBackground(0);
                List list = this.minecraft.field_1772.method_1728(class_1074.method_4662((String)"text.rei.config_api_failed", (Object[])new Object[0]), this.width - 100);
                float f = this.height / 2;
                this.minecraft.field_1772.getClass();
                int y = (int)(f - 9.0f * 1.3f / 2.0f * (float)list.size());
                for (int i = 0; i < list.size(); ++i) {
                    String s = (String)list.get(i);
                    this.drawCenteredString(this.minecraft.field_1772, s, this.width / 2, y, -1);
                    this.minecraft.field_1772.getClass();
                    y += 9;
                }
                super.render(int_1, int_2, float_1);
            }

            protected void init() {
                super.init();
                this.addButton((class_339)new class_4185(this.width / 2 - 100, this.height - 26, 200, 20, class_1074.method_4662((String)"text.rei.back", (Object[])new Object[0]), buttonWidget -> this.minecraft.method_1507(parent)));
            }

            public boolean keyPressed(int int_1, int int_2, int int_3) {
                if (int_1 == 256 && this.shouldCloseOnEsc()) {
                    this.minecraft.method_1507(parent);
                    return true;
                }
                return super.keyPressed(int_1, int_2, int_3);
            }
        };
    }
}

