/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;

public class DisplayHelperImpl
implements DisplayHelper {
    private static final Comparator<DisplayHelper.DisplayBoundsHandler<?>> BOUNDS_HANDLER_COMPARATOR;
    private static final DisplayHelper.DisplayBoundsHandler<Object> EMPTY;
    private List<DisplayHelper.DisplayBoundsHandler<?>> screenDisplayBoundsHandlers = Lists.newArrayList();
    private Map<Class<?>, DisplayHelper.DisplayBoundsHandler<?>> handlerCache = Maps.newHashMap();
    private Map<Class, List<DisplayHelper.DisplayBoundsHandler<?>>> handlerSortedCache = Maps.newHashMap();
    private BaseBoundsHandler baseBoundsHandler;
    private Class<?> tempScreen;

    @Override
    public List<DisplayHelper.DisplayBoundsHandler<?>> getSortedBoundsHandlers(Class<?> screenClass) {
        List<DisplayHelper.DisplayBoundsHandler<?>> possibleCached = this.handlerSortedCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tempScreen = screenClass;
        this.handlerSortedCache.put(screenClass, this.screenDisplayBoundsHandlers.stream().filter(this::filterResponsible).sorted(BOUNDS_HANDLER_COMPARATOR).collect(Collectors.toList()));
        return this.handlerSortedCache.get(screenClass);
    }

    @Override
    public List<DisplayHelper.DisplayBoundsHandler<?>> getAllBoundsHandlers() {
        return this.screenDisplayBoundsHandlers;
    }

    @Override
    public DisplayHelper.DisplayBoundsHandler<?> getResponsibleBoundsHandler(Class<?> screenClass) {
        DisplayHelper.DisplayBoundsHandler<?> possibleCached = this.handlerCache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        List<DisplayHelper.DisplayBoundsHandler<?>> handlers = this.getSortedBoundsHandlers(screenClass);
        this.handlerCache.put(screenClass, handlers.isEmpty() ? EMPTY : handlers.get(0));
        return this.handlerCache.get(screenClass);
    }

    @Deprecated
    public boolean filterResponsible(DisplayHelper.DisplayBoundsHandler<?> handler) {
        return handler.getBaseSupportedClass().isAssignableFrom(this.tempScreen);
    }

    @Override
    public void registerBoundsHandler(DisplayHelper.DisplayBoundsHandler<?> handler) {
        this.screenDisplayBoundsHandlers.add(handler);
    }

    @Override
    public BaseBoundsHandler getBaseBoundsHandler() {
        return this.baseBoundsHandler;
    }

    @Deprecated
    public void setBaseBoundsHandler(BaseBoundsHandler baseBoundsHandler) {
        this.baseBoundsHandler = baseBoundsHandler;
    }

    @Deprecated
    public void resetData() {
        this.screenDisplayBoundsHandlers.clear();
    }

    @Deprecated
    public void resetCache() {
        this.handlerCache.clear();
        this.handlerSortedCache.clear();
    }

    static {
        EMPTY = new DisplayHelper.DisplayBoundsHandler(){

            public Class getBaseSupportedClass() {
                return null;
            }

            public Rectangle getLeftBounds(Object screen) {
                return new Rectangle();
            }

            public Rectangle getRightBounds(Object screen) {
                return new Rectangle();
            }

            @Override
            public float getPriority() {
                return -10.0f;
            }
        };
        Comparator<DisplayHelper.DisplayBoundsHandler> comparator = Comparator.comparingDouble(DisplayHelper.DisplayBoundsHandler::getPriority);
        BOUNDS_HANDLER_COMPARATOR = comparator.reversed();
    }
}

