/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.plugin.DefaultPotionEffectExclusionZones;
import me.shedaniel.rei.plugin.DefaultRecipeBookExclusionZones;
import me.shedaniel.rei.plugin.blasting.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.brewing.DefaultBrewingCategory;
import me.shedaniel.rei.plugin.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.campfire.DefaultCampfireCategory;
import me.shedaniel.rei.plugin.campfire.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.composting.DefaultCompostingCategory;
import me.shedaniel.rei.plugin.composting.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.cooking.DefaultCookingCategory;
import me.shedaniel.rei.plugin.crafting.DefaultCraftingCategory;
import me.shedaniel.rei.plugin.crafting.DefaultCustomDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.crafting.DefaultShapelessDisplay;
import me.shedaniel.rei.plugin.smelting.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.smoking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.stonecutting.DefaultStoneCuttingCategory;
import me.shedaniel.rei.plugin.stonecutting.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.stripping.DefaultStrippingCategory;
import me.shedaniel.rei.plugin.stripping.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.stripping.DummyAxeItem;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.util.version.VersionParsingException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3576;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3920;
import net.minecraft.class_3962;
import net.minecraft.class_3975;
import net.minecraft.class_465;
import net.minecraft.class_472;
import net.minecraft.class_479;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_518;

public class DefaultPlugin
implements REIPluginV0 {
    public static final class_2960 CRAFTING = new class_2960("minecraft", "plugins/crafting");
    public static final class_2960 SMELTING = new class_2960("minecraft", "plugins/smelting");
    public static final class_2960 SMOKING = new class_2960("minecraft", "plugins/smoking");
    public static final class_2960 BLASTING = new class_2960("minecraft", "plugins/blasting");
    public static final class_2960 CAMPFIRE = new class_2960("minecraft", "plugins/campfire");
    public static final class_2960 STONE_CUTTING = new class_2960("minecraft", "plugins/stone_cutting");
    public static final class_2960 STRIPPING = new class_2960("minecraft", "plugins/stripping");
    public static final class_2960 BREWING = new class_2960("minecraft", "plugins/brewing");
    public static final class_2960 PLUGIN = new class_2960("roughlyenoughitems", "default_plugin");
    public static final class_2960 COMPOSTING = new class_2960("minecraft", "plugins/composting");
    private static final class_2960 DISPLAY_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/display.png");
    private static final class_2960 DISPLAY_TEXTURE_DARK = new class_2960("roughlyenoughitems", "textures/gui/display_dark.png");
    private static final List<DefaultBrewingDisplay> BREWING_DISPLAYS = Lists.newArrayList();

    public static class_2960 getDisplayTexture() {
        return ScreenHelper.isDarkModeEnabled() ? DISPLAY_TEXTURE_DARK : DISPLAY_TEXTURE;
    }

    public static void registerBrewingDisplay(DefaultBrewingDisplay display) {
        BREWING_DISPLAYS.add(display);
    }

    @Override
    public class_2960 getPluginIdentifier() {
        return PLUGIN;
    }

    @Override
    public SemanticVersion getMinimumVersion() throws VersionParsingException {
        return SemanticVersion.parse((String)"3.0-pre");
    }

    @Override
    public void registerEntries(EntryRegistry entryRegistry) {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLoadingDefaultPlugin()) {
            return;
        }
        class_2378.field_11142.method_10220().forEach(item -> {
            entryRegistry.registerEntry(EntryStack.create((class_1935)item));
            try {
                for (class_1799 stack : entryRegistry.getAllStacksFromItem((class_1792)item)) {
                    entryRegistry.registerEntry(EntryStack.create(stack));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        class_2378.field_11160.forEach(enchantment -> {
            for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); ++i) {
                HashMap<class_1887, Integer> map = new HashMap<class_1887, Integer>();
                map.put((class_1887)enchantment, i);
                class_1799 itemStack = new class_1799((class_1935)class_1802.field_8598);
                class_1890.method_8214(map, (class_1799)itemStack);
                entryRegistry.registerEntriesAfter(EntryStack.create((class_1935)class_1802.field_8598), EntryStack.create(itemStack));
            }
        });
        class_2378.field_11154.forEach(fluid -> {
            if (!(fluid instanceof class_3576)) {
                entryRegistry.registerEntry(EntryStack.create(fluid));
            }
        });
    }

    @Override
    public void registerPluginCategories(RecipeHelper recipeHelper) {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLoadingDefaultPlugin()) {
            return;
        }
        recipeHelper.registerCategory(new DefaultCraftingCategory());
        recipeHelper.registerCategory(new DefaultCookingCategory(SMELTING, EntryStack.create((class_1935)class_1802.field_8732), "category.rei.smelting"));
        recipeHelper.registerCategory(new DefaultCookingCategory(SMOKING, EntryStack.create((class_1935)class_1802.field_16309), "category.rei.smoking"));
        recipeHelper.registerCategory(new DefaultCookingCategory(BLASTING, EntryStack.create((class_1935)class_1802.field_16306), "category.rei.blasting"));
        recipeHelper.registerCategory(new DefaultCampfireCategory());
        recipeHelper.registerCategory(new DefaultStoneCuttingCategory());
        recipeHelper.registerCategory(new DefaultBrewingCategory());
        recipeHelper.registerCategory(new DefaultCompostingCategory());
        recipeHelper.registerCategory(new DefaultStrippingCategory());
    }

    @Override
    public void registerRecipeDisplays(RecipeHelper recipeHelper) {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLoadingDefaultPlugin()) {
            return;
        }
        recipeHelper.registerRecipes(CRAFTING, class_1867.class, DefaultShapelessDisplay::new);
        recipeHelper.registerRecipes(CRAFTING, class_1869.class, DefaultShapedDisplay::new);
        recipeHelper.registerRecipes(SMELTING, class_3861.class, DefaultSmeltingDisplay::new);
        recipeHelper.registerRecipes(SMOKING, class_3862.class, DefaultSmokingDisplay::new);
        recipeHelper.registerRecipes(BLASTING, class_3859.class, DefaultBlastingDisplay::new);
        recipeHelper.registerRecipes(CAMPFIRE, class_3920.class, DefaultCampfireDisplay::new);
        recipeHelper.registerRecipes(STONE_CUTTING, class_3975.class, DefaultStoneCuttingDisplay::new);
        BREWING_DISPLAYS.stream().forEachOrdered(display -> recipeHelper.registerDisplay(BREWING, (RecipeDisplay)display));
        List<EntryStack> arrowStack = Collections.singletonList(EntryStack.create((class_1935)class_1802.field_8107));
        for (EntryStack entry : RoughlyEnoughItemsCore.getEntryRegistry().getStacksList()) {
            int i;
            if (entry.getItem() != class_1802.field_8150) continue;
            ArrayList<List<EntryStack>> input = new ArrayList<List<EntryStack>>();
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            input.add(Collections.singletonList(EntryStack.create(entry.getItemStack())));
            for (i = 0; i < 4; ++i) {
                input.add(arrowStack);
            }
            class_1799 outputStack = new class_1799((class_1935)class_1802.field_8087, 8);
            class_1844.method_8061((class_1799)outputStack, (class_1842)class_1844.method_8063((class_1799)entry.getItemStack()));
            class_1844.method_8056((class_1799)outputStack, (Collection)class_1844.method_8068((class_1799)entry.getItemStack()));
            List<EntryStack> output = Collections.singletonList(EntryStack.create(outputStack).addSetting(EntryStack.Settings.CHECK_TAGS, EntryStack.Settings.TRUE));
            recipeHelper.registerDisplay(CRAFTING, new DefaultCustomDisplay(null, input, output));
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (class_3962.field_17566.isEmpty()) {
            class_3962.method_17758();
        }
        class_3962.field_17566.keySet().forEach(itemConvertible -> {
            float chance = class_3962.field_17566.getOrDefault(itemConvertible, 0.0f);
            if (chance > 0.0f) {
                map.put(itemConvertible, Float.valueOf(chance));
            }
        });
        LinkedList stacks = new LinkedList(map.keySet());
        stacks.sort((first, second) -> (int)((((Float)map.get(first)).floatValue() - ((Float)map.get(second)).floatValue()) * 100.0f));
        for (int i = 0; i < stacks.size(); i += class_3532.method_15340((int)48, (int)1, (int)(stacks.size() - i))) {
            ArrayList thisStacks = Lists.newArrayList();
            for (int j = i; j < i + 48; ++j) {
                if (j >= stacks.size()) continue;
                thisStacks.add(stacks.get(j));
            }
            recipeHelper.registerDisplay(COMPOSTING, new DefaultCompostingDisplay(class_3532.method_15375((float)((float)i / 48.0f)), thisStacks, map, Lists.newArrayList(map.keySet()), new class_1799[]{new class_1799((class_1935)class_1802.field_8324)}));
        }
        DummyAxeItem.getStrippedBlocksMap().entrySet().stream().sorted(Comparator.comparing(b -> class_2378.field_11146.method_10221(b.getKey()))).forEach(set -> recipeHelper.registerDisplay(STRIPPING, new DefaultStrippingDisplay(new class_1799((class_1935)set.getKey()), new class_1799((class_1935)set.getValue()))));
    }

    @Override
    public void registerBounds(DisplayHelper displayHelper) {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLoadingDefaultPlugin()) {
            return;
        }
        displayHelper.getBaseBoundsHandler().registerExclusionZones(class_485.class, new DefaultPotionEffectExclusionZones());
        displayHelper.getBaseBoundsHandler().registerExclusionZones(class_518.class, new DefaultRecipeBookExclusionZones());
        displayHelper.registerBoundsHandler(new DisplayHelper.DisplayBoundsHandler<class_465<?>>(){

            @Override
            public Class<?> getBaseSupportedClass() {
                return class_465.class;
            }

            @Override
            public Rectangle getLeftBounds(class_465<?> screen) {
                return new Rectangle(2, 0, ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft() - 4, class_310.method_1551().field_1704.method_4502());
            }

            @Override
            public Rectangle getRightBounds(class_465<?> screen) {
                int startX = ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft() + ScreenHelper.getLastContainerScreenHooks().rei_getContainerWidth() + 2;
                return new Rectangle(startX, 0, class_310.method_1551().field_1704.method_4486() - startX - 2, class_310.method_1551().field_1704.method_4502());
            }

            @Override
            public float getPriority() {
                return -1.0f;
            }
        });
        displayHelper.registerBoundsHandler(new DisplayHelper.DisplayBoundsHandler<RecipeViewingScreen>(){

            @Override
            public Class<?> getBaseSupportedClass() {
                return RecipeViewingScreen.class;
            }

            @Override
            public Rectangle getLeftBounds(RecipeViewingScreen screen) {
                return new Rectangle(2, 0, screen.getBounds().x - 4, class_310.method_1551().field_1704.method_4502());
            }

            @Override
            public Rectangle getRightBounds(RecipeViewingScreen screen) {
                int startX = screen.getBounds().x + screen.getBounds().width + 2;
                return new Rectangle(startX, 0, class_310.method_1551().field_1704.method_4486() - startX - 2, class_310.method_1551().field_1704.method_4502());
            }

            @Override
            public float getPriority() {
                return -1.0f;
            }
        });
        displayHelper.registerBoundsHandler(new DisplayHelper.DisplayBoundsHandler<VillagerRecipeViewingScreen>(){

            @Override
            public Class<?> getBaseSupportedClass() {
                return VillagerRecipeViewingScreen.class;
            }

            @Override
            public Rectangle getLeftBounds(VillagerRecipeViewingScreen screen) {
                return new Rectangle(2, 0, screen.bounds.x - 4, class_310.method_1551().field_1704.method_4502());
            }

            @Override
            public Rectangle getRightBounds(VillagerRecipeViewingScreen screen) {
                int startX = screen.bounds.x + screen.bounds.width + 2;
                return new Rectangle(startX, 0, class_310.method_1551().field_1704.method_4486() - startX - 2, class_310.method_1551().field_1704.method_4502());
            }

            @Override
            public float getPriority() {
                return -1.0f;
            }
        });
    }

    @Override
    public void registerOthers(RecipeHelper recipeHelper) {
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isLoadingDefaultPlugin()) {
            return;
        }
        recipeHelper.registerWorkingStations(CRAFTING, new class_1799((class_1935)class_1802.field_8465));
        recipeHelper.registerWorkingStations(SMELTING, new class_1799((class_1935)class_1802.field_8732));
        recipeHelper.registerWorkingStations(SMOKING, new class_1799((class_1935)class_1802.field_16309));
        recipeHelper.registerWorkingStations(BLASTING, new class_1799((class_1935)class_1802.field_16306));
        recipeHelper.registerWorkingStations(CAMPFIRE, new class_1799((class_1935)class_1802.field_17346));
        recipeHelper.registerWorkingStations(BREWING, new class_1799((class_1935)class_1802.field_8740));
        recipeHelper.registerWorkingStations(STONE_CUTTING, new class_1799((class_1935)class_1802.field_16305));
        recipeHelper.registerWorkingStations(COMPOSTING, new class_1799((class_1935)class_1802.field_17530));
        recipeHelper.registerAutoCraftButtonArea(CAMPFIRE, bounds -> null);
        recipeHelper.registerAutoCraftButtonArea(COMPOSTING, bounds -> null);
        recipeHelper.registerScreenClickArea(new Rectangle(88, 32, 28, 23), class_479.class, CRAFTING);
        recipeHelper.registerScreenClickArea(new Rectangle(137, 29, 10, 13), class_490.class, CRAFTING);
        recipeHelper.registerScreenClickArea(new Rectangle(97, 16, 14, 30), class_472.class, BREWING);
        recipeHelper.registerScreenClickArea(new Rectangle(78, 32, 28, 23), class_3873.class, SMELTING);
        recipeHelper.registerScreenClickArea(new Rectangle(78, 32, 28, 23), class_3874.class, SMOKING);
        recipeHelper.registerScreenClickArea(new Rectangle(78, 32, 28, 23), class_3871.class, BLASTING);
    }

    @Override
    public int getPriority() {
        return -1;
    }
}

