/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.listeners.RecipeBookGuiHooks;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.ContainerInfoHandler;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1074;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_518;

public class DefaultCategoryHandler
implements AutoTransferHandler {
    @Override
    public AutoTransferHandler.Result handle(AutoTransferHandler.Context context) {
        if (!(context.getRecipe() instanceof TransferRecipeDisplay)) {
            return AutoTransferHandler.Result.createNotApplicable();
        }
        TransferRecipeDisplay recipe = (TransferRecipeDisplay)context.getRecipe();
        if (!ContainerInfoHandler.isCategoryHandled(recipe.getRecipeCategory())) {
            return AutoTransferHandler.Result.createNotApplicable();
        }
        class_465<?> containerScreen = context.getContainerScreen();
        class_1703 container = containerScreen.method_17577();
        ContainerInfo containerInfo = ContainerInfoHandler.getContainerInfo(recipe.getRecipeCategory(), container.getClass());
        if (containerInfo == null) {
            return AutoTransferHandler.Result.createNotApplicable();
        }
        if (recipe.getHeight() > containerInfo.getCraftingHeight(container) || recipe.getWidth() > containerInfo.getCraftingWidth(container)) {
            return AutoTransferHandler.Result.createFailed(class_1074.method_4662((String)"error.rei.transfer.too_small", (Object[])new Object[]{containerInfo.getCraftingWidth(container), containerInfo.getCraftingHeight(container)}));
        }
        List<List<EntryStack>> input = recipe.getOrganisedInputEntries(containerInfo, container);
        IntList intList = this.hasItems(input);
        if (!intList.isEmpty()) {
            return AutoTransferHandler.Result.createFailed("error.rei.not.enough.materials", intList);
        }
        if (!this.canUseMovePackets()) {
            return AutoTransferHandler.Result.createFailed("error.rei.not.on.server");
        }
        if (!context.isActuallyCrafting()) {
            return AutoTransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().method_1507(containerScreen);
        if (containerScreen instanceof class_518) {
            ((RecipeBookGuiHooks)((class_518)containerScreen).method_2659()).rei_getGhostSlots().method_2571();
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(recipe.getRecipeCategory());
        buf.writeBoolean(class_437.hasShiftDown());
        buf.writeInt(input.size());
        for (List<EntryStack> stacks : input) {
            buf.writeInt(stacks.size());
            for (EntryStack stack : stacks) {
                if (stack.getItemStack() != null) {
                    buf.method_10793(stack.getItemStack());
                    continue;
                }
                buf.method_10793(class_1799.field_8037);
            }
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, buf);
        return AutoTransferHandler.Result.createSuccessful();
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    public boolean canUseMovePackets() {
        return ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET);
    }

    public IntList hasItems(List<List<EntryStack>> inputs) {
        class_2371 copyMain = class_2371.method_10211();
        for (class_1799 stack : class_310.method_1551().field_1724.field_7514.field_7547) {
            copyMain.add((Object)stack.method_7972());
        }
        IntArrayList intList = new IntArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            List<EntryStack> possibleStacks = inputs.get(i);
            boolean done = possibleStacks.isEmpty();
            for (EntryStack possibleStack : possibleStacks) {
                if (done) continue;
                int invRequiredCount = possibleStack.getAmount();
                for (class_1799 stack : copyMain) {
                    EntryStack entryStack = EntryStack.create(stack);
                    if (!entryStack.equals(possibleStack)) continue;
                    while (invRequiredCount > 0 && !stack.method_7960()) {
                        --invRequiredCount;
                        stack.method_7934(1);
                    }
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            intList.add(i);
        }
        return intList;
    }
}

