/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.annotations.Internal;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.EmptyEntryStack;
import me.shedaniel.rei.impl.FluidEntryStack;
import me.shedaniel.rei.impl.ItemEntryStack;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

@SuppressWarnings("deprecation")
public interface EntryStack {
    
    static EntryStack empty() {
        return EmptyEntryStack.EMPTY;
    }
    
    static EntryStack create(class_3611 fluid) {
        return new FluidEntryStack(fluid);
    }
    
    static EntryStack create(class_3611 fluid, int amount) {
        return new FluidEntryStack(fluid, amount);
    }
    
    static EntryStack create(class_1799 stack) {
        return new ItemEntryStack(stack);
    }
    
    static EntryStack create(class_1935 item) {
        return new ItemEntryStack(new class_1799(item));
    }
    
    @Internal
    @Deprecated
    static EntryStack readFromJson(JsonElement jsonElement) {
        try {
            JsonObject obj = jsonElement.getAsJsonObject();
            switch (obj.getAsJsonPrimitive("type").getAsString()) {
                case "stack":
                    return EntryStack.create(class_1799.method_7915(class_2522.method_10718(obj.get("nbt").getAsString())));
                case "fluid":
                    return EntryStack.create(class_2378.field_11154.method_10223(class_2960.method_12829(obj.get("id").getAsString())));
                case "empty":
                    return EntryStack.empty();
                default:
                    throw new IllegalArgumentException("Invalid Entry Type!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return EntryStack.empty();
        }
    }
    
    @Internal
    @Deprecated
    @Nullable
    default JsonElement toJson() {
        try {
            switch (getType()) {
                case ITEM:
                    JsonObject obj1 = new JsonObject();
                    obj1.addProperty("type", "stack");
                    obj1.addProperty("nbt", getItemStack().method_7953(new class_2487()).toString());
                    return obj1;
                case FLUID:
                    JsonObject obj2 = new JsonObject();
                    obj2.addProperty("type", "fluid");
                    obj2.addProperty("id", getIdentifier().get().toString());
                    return obj2;
                case EMPTY:
                    JsonObject obj3 = new JsonObject();
                    obj3.addProperty("type", "empty");
                    return obj3;
                default:
                    throw new IllegalArgumentException("Invalid Entry Type!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
    
    Optional<class_2960> getIdentifier();
    
    EntryStack.Type getType();
    
    int getAmount();
    
    void setAmount(int amount);
    
    boolean isEmpty();
    
    EntryStack copy();
    
    Object getObject();
    
    boolean equals(EntryStack stack, boolean ignoreTags, boolean ignoreAmount);
    
    boolean equalsIgnoreTagsAndAmount(EntryStack stack);
    
    boolean equalsIgnoreTags(EntryStack stack);
    
    boolean equalsIgnoreAmount(EntryStack stack);
    
    boolean equalsAll(EntryStack stack);
    
    int getZ();
    
    void setZ(int z);
    
    default class_1799 getItemStack() {
        if (getType() == Type.ITEM)
            return (class_1799) getObject();
        return null;
    }
    
    default class_1792 getItem() {
        if (getType() == Type.ITEM)
            return ((class_1799) getObject()).method_7909();
        return null;
    }
    
    default class_3611 getFluid() {
        if (getType() == Type.FLUID)
            return (class_3611) getObject();
        return null;
    }
    
    <T> EntryStack setting(Settings<T> settings, T value);
    
    <T> EntryStack removeSetting(Settings<T> settings);
    
    EntryStack clearSettings();
    
    default <T> EntryStack addSetting(Settings<T> settings, T value) {
        return setting(settings, value);
    }
    
    <T> ObjectHolder<T> getSetting(Settings<T> settings);
    
    @Nullable
    QueuedTooltip getTooltip(int mouseX, int mouseY);
    
    void render(Rectangle bounds, int mouseX, int mouseY, float delta);
    
    public static enum Type {
        ITEM,
        FLUID,
        EMPTY,
        RENDER
    }
    
    public static class Settings<T> {
        public static final Supplier<Boolean> TRUE = () -> true;
        public static final Supplier<Boolean> FALSE = () -> false;
        public static final Settings<Supplier<Boolean>> RENDER = new Settings(TRUE);
        public static final Settings<Supplier<Boolean>> CHECK_TAGS = new Settings(FALSE);
        public static final Settings<Supplier<Boolean>> TOOLTIP_ENABLED = new Settings(TRUE);
        public static final Settings<Supplier<Boolean>> TOOLTIP_APPEND_MOD = new Settings(TRUE);
        public static final Settings<Supplier<Boolean>> RENDER_COUNTS = new Settings(TRUE);
        public static final Settings<Function<EntryStack, List<String>>> TOOLTIP_APPEND_EXTRA = new Settings<Function<EntryStack, List<String>>>(stack -> Collections.emptyList());
        public static final Settings<Function<EntryStack, String>> COUNTS = new Settings<Function<EntryStack, String>>(stack -> null);
        
        private T defaultValue;
        
        public Settings(T defaultValue) {
            this.defaultValue = defaultValue;
        }
        
        public T getDefaultValue() {
            return defaultValue;
        }
        
        public static class Item {
            public static final Settings<Supplier<Boolean>> RENDER_ENCHANTMENT_GLINT = new Settings(TRUE);
            @Deprecated public static final Settings<Supplier<Boolean>> RENDER_OVERLAY = RENDER_ENCHANTMENT_GLINT;
            
            private Item() {
            }
        }
        
        public static class Fluid {
            // Return null to disable
            public static final Settings<Function<EntryStack, String>> AMOUNT_TOOLTIP = new Settings<Function<EntryStack, String>>(stack -> class_1074.method_4662("tooltip.rei.fluid_amount", stack.getAmount()));
            
            private Fluid() {
            }
        }
    }
}
