/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PreRecipeViewingScreen extends class_437 {
    
    private static final class_2960 IDENTIFIER = new class_2960("roughlyenoughitems", "textures/gui/screenshot.png");
    private final List<Widget> widgets;
    private boolean original;
    private Map<RecipeCategory<?>, List<RecipeDisplay>> map;
    
    public PreRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        super(new class_2588("text.rei.recipe_screen_type.selection"));
        this.widgets = Lists.newArrayList();
        this.original = true;
        this.map = map;
    }
    
    @Override
    protected void init() {
        this.children.clear();
        this.widgets.clear();
        this.widgets.add(new ButtonWidget(new Rectangle(width / 2 - 100, height - 40, 200, 20), class_1074.method_4662("text.rei.select")) {
            @Override
            public void onPressed() {
                ConfigObject.getInstance().setRecipeScreenType(original ? RecipeScreenType.ORIGINAL : RecipeScreenType.VILLAGER);
                ConfigManager.getInstance().saveConfig();
                ClientHelper.getInstance().openRecipeViewingScreen(map);
            }
        });
        this.widgets.add(new ScreenTypeSelection(width / 2 - 200 - 5, height / 2 - 112 / 2 - 10, 0));
        this.widgets.add(new ScreenTypeSelection(width / 2 + 5, height / 2 - 112 / 2 - 10, 112));
        this.children.addAll(widgets);
    }
    
    @Override
    public void render(int int_1, int int_2, float float_1) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.method_10863(), this.width / 2, 20, 16777215);
        int i = 30;
        for(String s : this.font.method_1728(class_1074.method_4662("text.rei.recipe_screen_type.selection.sub"), width - 30)) {
            this.drawCenteredString(this.font, class_124.field_1080.toString() + s, width / 2, i, -1);
            i += 10;
        }
        super.render(int_1, int_2, float_1);
        for(Widget widget : widgets) {
            widget.render(int_1, int_2, float_1);
        }
    }
    
    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if ((int_1 == 256 || this.minecraft.field_1690.field_1822.method_1417(int_1, int_2)) && this.shouldCloseOnEsc()) {
            class_310.method_1551().method_1507(ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
    
    public class ScreenTypeSelection extends WidgetWithBounds {
        
        private Rectangle bounds;
        private int u, v;
        
        public ScreenTypeSelection(int x, int y, int v) {
            this.bounds = new Rectangle(x - 4, y - 4, 208, 120);
            this.u = 0;
            this.v = v;
        }
        
        @Override
        public Rectangle getBounds() {
            return bounds;
        }
        
        @Override
        public void render(int i, int i1, float delta) {
            class_310.method_1551().method_1531().method_22813(IDENTIFIER);
            blit(bounds.x + 4, bounds.y + 4, u, v, 200, 112);
            if (original == (v == 0)) {
                fillGradient(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + 2, 0xFFFFFFFF, 0xFFFFFFFF);
                fillGradient(bounds.x, bounds.y + bounds.height - 2, bounds.x + bounds.width, bounds.y + bounds.height, 0xFFFFFFFF, 0xFFFFFFFF);
                fillGradient(bounds.x, bounds.y, bounds.x + 2, bounds.y + bounds.height, 0xFFFFFFFF, 0xFFFFFFFF);
                fillGradient(bounds.x + bounds.width - 2, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0xFFFFFFFF, 0xFFFFFFFF);
            }
        }
        
        @Override
        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (containsMouse(double_1, double_2)) {
                minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                original = (v == 0);
                return true;
            }
            return false;
        }
        
        @Override
        public List<? extends class_364> children() {
            return Collections.emptyList();
        }
    }
}
