/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.ConfigManager;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_918;
import java.util.Optional;

public abstract class CraftableToggleButtonWidget extends ButtonWidget {
    
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private class_918 itemRenderer;
    
    public CraftableToggleButtonWidget(Rectangle rectangle) {
        super(rectangle, "");
        this.itemRenderer = minecraft.method_1480();
    }
    
    public CraftableToggleButtonWidget(int x, int y, int width, int height) {
        this(new Rectangle(x, y, width, height));
    }
    
    public void lateRender(int mouseX, int mouseY, float delta) {
        super.render(mouseX, mouseY, delta);
        
        this.itemRenderer.field_4730 = getBlitOffset();
        Rectangle bounds = getBounds();
        this.itemRenderer.method_4023(new class_1799(class_2246.field_9980), bounds.x + 2, bounds.y + 2);
        this.itemRenderer.field_4730 = 0.0F;
        class_310.method_1551().method_1531().method_22813(CHEST_GUI_TEXTURE);
        RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
        int color = ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776;
        setBlitOffset(getBlitOffset() + 10);
        this.fillGradient(bounds.x + 1, bounds.y + 1, bounds.getMaxX() - 1, bounds.getMaxY() - 1, color, color);
        setBlitOffset(0);
    }
    
    @Override
    public void render(int mouseX, int mouseY, float delta) {
    }
    
    @Override
    public boolean changeFocus(boolean boolean_1) {
        return false;
    }
    
    @Override
    public Optional<String> getTooltips() {
        return Optional.ofNullable(class_1074.method_4662(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all"));
    }
}
