/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import java.util.*;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class EntryListWidget extends WidgetWithBounds {
    
    static final Supplier<Boolean> RENDER_ENCHANTMENT_GLINT = ConfigObject.getInstance()::doesRenderEntryEnchantmentGlint;
    @SuppressWarnings("deprecation")
    static final Comparator<? super EntryStack> ENTRY_NAME_COMPARER = Comparator.comparing(SearchArgument::tryGetEntryStackName);
    static final Comparator<? super EntryStack> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        if (stack.getType() == EntryStack.Type.ITEM) {
            class_1761 group = stack.getItem().method_7859();
            if (group != null)
                return group.method_7741();
        }
        return Integer.MAX_VALUE;
    });
    private static final boolean LAZY = true;
    private static final String SPACE = " ", EMPTY = "";
    private static int page;
    protected double target;
    protected double scroll;
    protected long start;
    protected long duration;
    protected int blockedCount;
    private boolean debugTime;
    private Rectangle bounds, innerBounds;
    private List<EntryStack> allStacks = null;
    private List<EntryStack> favorites = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    @SuppressWarnings("deprecation")
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();
    private boolean draggingScrollBar = false;
    
    @SuppressWarnings("rawtypes")
    static boolean notSteppingOnExclusionZones(int left, int top, Rectangle listArea) {
        class_310 instance = class_310.method_1551();
        for(DisplayHelper.DisplayBoundsHandler sortedBoundsHandler : DisplayHelper.getInstance().getSortedBoundsHandlers(instance.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(left, top, instance.field_1755, listArea);
            if (fit != class_1269.field_5811)
                return fit == class_1269.field_5812;
        }
        return true;
    }
    
    private static Rectangle updateInnerBounds(Rectangle bounds) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((bounds.width - 2 - 6) / 18f), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel())
                return new Rectangle(bounds.getCenterX() - width * 9 + 3, bounds.y, width * 18, bounds.height);
            return new Rectangle(bounds.getCenterX() - width * 9 - 3, bounds.y, width * 18, bounds.height);
        }
        int width = Math.max(class_3532.method_15375((bounds.width - 2) / 18f), 1);
        int height = Math.max(class_3532.method_15375((bounds.height - 2) / 18f), 1);
        return new Rectangle(bounds.getCenterX() - width * 9, bounds.getCenterY() - height * 9, width * 18, height * 18);
    }
    
    protected final int getSlotsHeightNumberForFavorites() {
        if (favorites.isEmpty())
            return 0;
        if (ConfigObject.getInstance().isEntryListWidgetScrolled())
            return class_3532.method_15386(2 + favorites.size() / (innerBounds.width / 18f));
        int height = class_3532.method_15386(favorites.size() / (innerBounds.width / 18f));
        int pagesToFit = class_3532.method_15386(height / (innerBounds.height / 18f - 1));
        if (height > (innerBounds.height / 18 - 1) && (height) % (innerBounds.height / 18) == (innerBounds.height / 18) - 2)
            height--;
        return height + pagesToFit + 1;
    }
    
    protected final int getScrollNumberForFavorites() {
        if (favorites.isEmpty())
            return 0;
        return (innerBounds.width / 18) * getSlotsHeightNumberForFavorites();
    }
    
    protected final int getMaxScrollPosition() {
        if (favorites.isEmpty())
            return class_3532.method_15386((allStacks.size() + blockedCount) / (innerBounds.width / 18f)) * 18;
        return class_3532.method_15386((allStacks.size() + blockedCount + getScrollNumberForFavorites()) / (innerBounds.width / 18f)) * 18 - 12;
    }
    
    protected final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - innerBounds.height);
    }
    
    protected final double clamp(double v) {
        return this.clamp(v, 200.0D);
    }
    
    protected final double clamp(double v, double clampExtension) {
        return class_3532.method_15350(v, -clampExtension, (double) this.getMaxScroll() + clampExtension);
    }
    
    protected final void offset(double value, boolean animated) {
        scrollTo(target + value, animated);
    }
    
    protected final void scrollTo(double value, boolean animated) {
        scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }
    
    protected final void scrollTo(double value, boolean animated, long duration) {
        target = clamp(value);
        
        if (animated) {
            start = System.currentTimeMillis();
            this.duration = duration;
        } else
            scroll = target;
    }
    
    @Override
    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && bounds.contains(double_1, double_2)) {
            offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }
    
    @Override
    public Rectangle getBounds() {
        return bounds;
    }
    
    public int getPage() {
        return page;
    }
    
    public void setPage(int page) {
        this.page = page;
    }
    
    public void previousPage() {
        this.page--;
    }
    
    public void nextPage() {
        this.page++;
    }
    
    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled())
            return 1;
        return class_3532.method_15386((allStacks.size() + getScrollNumberForFavorites()) / (float) entries.size());
    }
    
    @Override
    public void render(int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            for(EntryListEntry entry : entries)
                entry.clearStacks();
            ScissorsHandler.INSTANCE.scissor(bounds);
            int sizeForFavorites = getSlotsHeightNumberForFavorites();
            int skip = Math.max(0, class_3532.method_15357(scroll / 18f) - sizeForFavorites);
            int nextIndex = skip * innerBounds.width / 18;
            int i = nextIndex;
            blockedCount = 0;
            if (debugTime) {
                int size = 0;
                long time = 0;
                if (sizeForFavorites > 0) {
                    drawString(font, class_1074.method_4662("text.rei.favorites"), innerBounds.x + 2, (int) (innerBounds.y + 8 - scroll), -1);
                    nextIndex += innerBounds.width / 18;
                    for(int i1 = 0; i1 < favorites.size(); i1++) {
                        EntryStack stack = favorites.get(i1);
                        back1:
                        while (true) {
                            EntryListEntry entry = entries.get(nextIndex);
                            entry.getBounds().y = (int) (entry.backupY - scroll);
                            if (entry.getBounds().y > bounds.getMaxY())
                                break back1;
                            if (notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, innerBounds)) {
                                entry.entry(stack);
                                entry.isFavorites = true;
                                size++;
                                long l = System.currentTimeMillis();
                                entry.render(mouseX, mouseY, delta);
                                time += (System.currentTimeMillis() - l);
                                nextIndex++;
                                break;
                            } else {
                                blockedCount++;
                                nextIndex++;
                            }
                        }
                    }
                    nextIndex += innerBounds.width / -18 + getScrollNumberForFavorites() - favorites.size();
                }
                int offset = sizeForFavorites > 0 ? -12 : 0;
                back:
                for(; i < allStacks.size(); i++) {
                    EntryStack stack = allStacks.get(i);
                    while (true) {
                        EntryListEntry entry = entries.get(nextIndex);
                        entry.getBounds().y = (int) (entry.backupY - scroll + offset);
                        if (entry.getBounds().y > bounds.getMaxY())
                            break back;
                        if (notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, innerBounds)) {
                            entry.entry(stack);
                            entry.isFavorites = false;
                            size++;
                            long l = System.currentTimeMillis();
                            entry.render(mouseX, mouseY, delta);
                            time += (System.currentTimeMillis() - l);
                            nextIndex++;
                            break;
                        } else {
                            blockedCount++;
                            nextIndex++;
                        }
                    }
                }
                int z = getZ();
                setZ(500);
                String str = String.format("%d entries, avg. %.2fms, %s fps", size, time / (double) size, minecraft.field_1770.split(" ")[0]);
                fillGradient(bounds.x, bounds.y, bounds.x + font.method_1727(str) + 2, bounds.y + font.field_2000 + 2, -16777216, -16777216);
                class_4587 matrixStack_1 = new class_4587();
                class_4597.class_4598 immediate = class_4597.method_22991(class_289.method_1348().method_1349());
                matrixStack_1.method_22904(0.0D, 0.0D, getZ());
                class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
                font.method_22942(str, bounds.x + 2, bounds.y + 2, -1, false, matrix4f_1, immediate, false, 0, 15728880);
                immediate.method_22993();
                setZ(z);
            } else {
                if (sizeForFavorites > 0) {
                    drawString(font, class_1074.method_4662("text.rei.favorites"), innerBounds.x + 2, (int) (innerBounds.y + 8 - scroll), -1);
                    nextIndex += innerBounds.width / 18;
                    for(int i1 = 0; i1 < favorites.size(); i1++) {
                        EntryStack stack = favorites.get(i1);
                        back1:
                        while (true) {
                            EntryListEntry entry = entries.get(nextIndex);
                            entry.getBounds().y = (int) (entry.backupY - scroll);
                            if (entry.getBounds().y > bounds.getMaxY())
                                break back1;
                            if (notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, innerBounds)) {
                                entry.entry(stack);
                                entry.isFavorites = true;
                                entry.render(mouseX, mouseY, delta);
                                nextIndex++;
                                break;
                            } else {
                                blockedCount++;
                                nextIndex++;
                            }
                        }
                    }
                    nextIndex += innerBounds.width / -18 + getScrollNumberForFavorites() - favorites.size();
                }
                int offset = sizeForFavorites > 0 ? -12 : 0;
                back:
                for(; i < allStacks.size(); i++) {
                    EntryStack stack = allStacks.get(i);
                    while (true) {
                        EntryListEntry entry = entries.get(nextIndex);
                        entry.getBounds().y = (int) (entry.backupY - scroll + offset);
                        if (entry.getBounds().y > bounds.getMaxY())
                            break back;
                        if (notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, innerBounds)) {
                            entry.entry(stack);
                            entry.isFavorites = false;
                            entry.render(mouseX, mouseY, delta);
                            nextIndex++;
                            break;
                        } else {
                            blockedCount++;
                            nextIndex++;
                        }
                    }
                }
            }
            updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            renderScrollbar();
        } else {
            if (debugTime) {
                int size = 0;
                long time = 0;
                for(Widget widget : widgets) {
                    if (widget instanceof EntryListEntry) {
                        size++;
                        long l = System.currentTimeMillis();
                        widget.render(mouseX, mouseY, delta);
                        time += (System.currentTimeMillis() - l);
                    } else
                        widget.render(mouseX, mouseY, delta);
                }
                int z = getZ();
                setZ(500);
                String str = String.format("%d entries, avg. %.2fms, %s fps", size, time / (double) size, minecraft.field_1770.split(" ")[0]);
                fillGradient(bounds.x, bounds.y, bounds.x + font.method_1727(str) + 2, bounds.y + font.field_2000 + 2, -16777216, -16777216);
                class_4587 matrixStack_1 = new class_4587();
                class_4597.class_4598 immediate = class_4597.method_22991(class_289.method_1348().method_1349());
                matrixStack_1.method_22904(0.0D, 0.0D, getZ());
                class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
                font.method_22942(str, bounds.x + 2, bounds.y + 2, -1, false, matrix4f_1, immediate, false, 0, 15728880);
                immediate.method_22993();
                setZ(z);
            } else {
                for(Widget widget : widgets) {
                    widget.render(mouseX, mouseY, delta);
                }
            }
        }
    }
    
    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel())
            return bounds.x + 1;
        return bounds.getMaxX() - 7;
    }
    
    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        if (int_1 == 0 && draggingScrollBar) {
            float height = getMaxScrollPosition();
            int actualHeight = innerBounds.height;
            if (height > actualHeight && mouseY >= innerBounds.y && mouseY <= innerBounds.getMaxY()) {
                double double_5 = (double) Math.max(1, this.getMaxScroll());
                int int_2 = innerBounds.height;
                int int_3 = class_3532.method_15340((int) ((float) (int_2 * int_2) / (float) getMaxScrollPosition()), 32, int_2 - 8);
                double double_6 = Math.max(1.0D, double_5 / (double) (int_2 - int_3));
                float to = class_3532.method_15363((float) (scroll + double_4 * double_6), 0, height - innerBounds.height);
                if (ConfigObject.getInstance().doesSnapToRows()) {
                    double nearestRow = Math.round(to / 18.0) * 18.0;
                    scrollTo(nearestRow, false);
                } else
                    scrollTo(to, false);
            }
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }
    
    private void renderScrollbar() {
        int maxScroll = getMaxScroll();
        if (maxScroll > 0) {
            int height = innerBounds.height * innerBounds.height / getMaxScrollPosition();
            height = class_3532.method_15340(height, 32, innerBounds.height - 8);
            height -= Math.min((scroll < 0 ? (int) -scroll : scroll > maxScroll ? (int) scroll - maxScroll : 0), height * .95);
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int) scroll * (innerBounds.height - height) / maxScroll + innerBounds.y, innerBounds.y), innerBounds.getMaxY() - height);
            
            int scrollbarPositionMinX = getScrollbarMinX();
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = (new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height)).contains(PointHelper.fromMouse());
            float bottomC = (hovered ? .67f : .5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1f);
            float topC = (hovered ? .87f : .67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1f);
            
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate(770, 771, 1, 0);
            RenderSystem.shadeModel(7425);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912(scrollbarPositionMinX, minY + height, 0.0D).method_22915(bottomC, bottomC, bottomC, 1).method_1344();
            buffer.method_22912(scrollbarPositionMaxX, minY + height, 0.0D).method_22915(bottomC, bottomC, bottomC, 1).method_1344();
            buffer.method_22912(scrollbarPositionMaxX, minY, 0.0D).method_22915(bottomC, bottomC, bottomC, 1).method_1344();
            buffer.method_22912(scrollbarPositionMinX, minY, 0.0D).method_22915(bottomC, bottomC, bottomC, 1).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912(scrollbarPositionMinX, (minY + height - 1), 0.0D).method_22915(topC, topC, topC, 1).method_1344();
            buffer.method_22912((scrollbarPositionMaxX - 1), (minY + height - 1), 0.0D).method_22915(topC, topC, topC, 1).method_1344();
            buffer.method_22912((scrollbarPositionMaxX - 1), minY, 0.0D).method_22915(topC, topC, topC, 1).method_1344();
            buffer.method_22912(scrollbarPositionMinX, minY, 0.0D).method_22915(topC, topC, topC, 1).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel(7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
    }
    
    private void updatePosition(float delta) {
        target = clamp(target);
        if (target < 0) {
            target -= target * (1 - ClothConfigInitializer.getBounceBackMultiplier()) * delta / 3;
        } else if (target > getMaxScroll()) {
            target = (target - getMaxScroll()) * (1 - (1 - ClothConfigInitializer.getBounceBackMultiplier()) * delta / 3) + getMaxScroll();
        } else if (ConfigObject.getInstance().doesSnapToRows()) {
            double nearestRow = Math.round(target / 18.0) * 18.0;
            if (!DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals(target, nearestRow, DynamicNewSmoothScrollingEntryListWidget.Precision.FLOAT_EPSILON))
                target += (nearestRow - target) * Math.min(delta / 2.0, 1.0);
            else
                target = nearestRow;
        }
        if (!DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals(scroll, target, DynamicNewSmoothScrollingEntryListWidget.Precision.FLOAT_EPSILON))
            scroll = (float) DynamicNewSmoothScrollingEntryListWidget.Interpolation.expoEase(scroll, target, Math.min((System.currentTimeMillis() - start) / ((double) duration), 1));
        else
            scroll = target;
    }
    
    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (containsMouse(PointHelper.fromMouse()))
            for(Widget widget : widgets)
                if (widget.keyPressed(int_1, int_2, int_3))
                    return true;
        return false;
    }
    
    public void updateArea(DisplayHelper.DisplayBoundsHandler<?> boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getItemListArea(ScreenHelper.getLastOverlay().getBounds());
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null)
            favoritesListWidget.updateFavoritesBounds(boundsHandler, searchTerm);
        if (searchTerm != null)
            updateSearch(searchTerm);
        else if (allStacks == null || favorites == null || (favoritesListWidget != null && favoritesListWidget.favorites == null))
            updateSearch("");
        else
            updateEntriesPosition();
    }
    
    public void updateEntriesPosition() {
        this.innerBounds = updateInnerBounds(bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            page = Math.max(page, 0);
            List<EntryListEntry> entries = Lists.newLinkedList();
            int width = innerBounds.width / 18;
            int height = innerBounds.height / 18;
            for(int currentY = 0; currentY < height; currentY++) {
                for(int currentX = 0; currentX < width; currentX++) {
                    if (notSteppingOnExclusionZones(currentX * 18 + innerBounds.x, currentY * 18 + innerBounds.y, innerBounds)) {
                        entries.add((EntryListEntry) new EntryListEntry(currentX * 18 + innerBounds.x, currentY * 18 + innerBounds.y).noBackground());
                    }
                }
            }
            page = Math.max(Math.min(page, getTotalPages() - 1), 0);
            int numberForFavorites = getScrollNumberForFavorites();
            List<EntryStack> subList = allStacks.stream().skip(Math.max(0, page * entries.size() - numberForFavorites)).limit(Math.max(0, entries.size() - Math.max(0, numberForFavorites - page * entries.size()))).collect(Collectors.toList());
            for(int i = 0; i < subList.size(); i++) {
                EntryStack stack = subList.get(i);
                entries.get(i + Math.max(0, numberForFavorites - page * entries.size())).clearStacks().entry(stack);
                entries.get(i + Math.max(0, numberForFavorites - page * entries.size())).isFavorites = false;
            }
            this.entries = entries;
            this.widgets = Lists.newLinkedList(entries);
            if (numberForFavorites > 0) {
                int skippedFavorites = page * (entries.size() - width);
                int j = 0;
                if (skippedFavorites < favorites.size()) {
                    widgets.add(new LabelWidget(new Point(innerBounds.x + 2, innerBounds.y + 6), class_1074.method_4662("text.rei.favorites")).leftAligned());
                    j += width;
                }
                List<EntryStack> subFavoritesList = favorites.stream().skip(skippedFavorites).limit(Math.max(0, entries.size() - width)).collect(Collectors.toList());
                for(int i = 0; i < subFavoritesList.size(); i++) {
                    EntryStack stack = subFavoritesList.get(i);
                    entries.get(j).clearStacks().entry(stack);
                    entries.get(j).isFavorites = true;
                    j++;
                }
            }
        } else {
            page = 0;
            int width = innerBounds.width / 18;
            int pageHeight = innerBounds.height / 18;
            int sizeForFavorites = getScrollNumberForFavorites();
            int slotsToPrepare = allStacks.size() * 3 + sizeForFavorites * 3;
            int currentX = 0;
            int currentY = 0;
            List<EntryListEntry> entries = Lists.newLinkedList();
            for(int i = 0; i < slotsToPrepare; i++) {
                int xPos = currentX * 18 + innerBounds.x;
                int yPos = currentY * 18 + innerBounds.y;
                entries.add((EntryListEntry) new EntryListEntry(xPos, yPos).noBackground());
                currentX++;
                if (currentX >= width) {
                    currentX = 0;
                    currentY++;
                }
            }
            this.entries = entries;
            this.widgets = Collections.unmodifiableList(entries);
        }
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null)
            favoritesListWidget.updateEntriesPosition();
    }
    
    @Deprecated
    public List<EntryStack> getAllStacks() {
        return allStacks;
    }
    
    @SuppressWarnings("deprecation")
    public void updateSearch(String searchTerm) {
        lastSearchArguments = processSearchTerm(searchTerm);
        {
            List<EntryStack> list = Lists.newLinkedList();
            boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            for(EntryStack stack : EntryRegistry.getInstance().getStacksList()) {
                if (canLastSearchTermsBeAppliedTo(stack)) {
                    if (workingItems != null && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null)
                        continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                }
            }
            ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == ItemListOrdering.name)
                list.sort(ENTRY_NAME_COMPARER);
            if (ordering == ItemListOrdering.item_groups)
                list.sort(ENTRY_GROUP_COMPARER);
            if (!ConfigObject.getInstance().isItemListAscending())
                Collections.reverse(list);
            allStacks = list;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && !ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            List<EntryStack> list = Lists.newLinkedList();
            boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            for(EntryStack stack : ConfigManager.getInstance().getFavorites()) {
                if (canLastSearchTermsBeAppliedTo(stack)) {
                    if (workingItems != null && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null)
                        continue;
                    list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
                }
            }
            ItemListOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == ItemListOrdering.name)
                list.sort(ENTRY_NAME_COMPARER);
            if (ordering == ItemListOrdering.item_groups)
                list.sort(ENTRY_GROUP_COMPARER);
            if (!ConfigObject.getInstance().isItemListAscending())
                Collections.reverse(list);
            favorites = list;
        } else
            favorites = Collections.emptyList();
        debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null)
            favoritesListWidget.updateSearch(this, searchTerm);
        updateEntriesPosition();
    }
    
    @SuppressWarnings("deprecation")
    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return lastSearchArguments.isEmpty() || canSearchTermsBeAppliedTo(stack, lastSearchArguments);
    }
    
    @SuppressWarnings("deprecation")
    private boolean canSearchTermsBeAppliedTo(EntryStack stack, List<SearchArgument.SearchArguments> searchArguments) {
        if (searchArguments.isEmpty())
            return true;
        String mod = null, name = null, tooltip = null, tags[] = null;
        for(SearchArgument.SearchArguments arguments : searchArguments) {
            boolean applicable = true;
            for(SearchArgument argument : arguments.getArguments()) {
                if (argument.getArgumentType() == SearchArgument.ArgumentType.ALWAYS)
                    return true;
                else if (argument.getArgumentType() == SearchArgument.ArgumentType.MOD) {
                    if (mod == null)
                        mod = stack.getIdentifier().map(class_2960::method_12836).orElse("").replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    if (mod != null && !mod.isEmpty() && argument.getFunction(!argument.isInclude()).apply(mod)) {
                        applicable = false;
                        break;
                    }
                } else if (argument.getArgumentType() == SearchArgument.ArgumentType.TEXT) {
                    if (name == null)
                        name = SearchArgument.tryGetEntryStackName(stack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    if (name != null && !name.isEmpty() && argument.getFunction(!argument.isInclude()).apply(name)) {
                        applicable = false;
                        break;
                    }
                } else if (argument.getArgumentType() == SearchArgument.ArgumentType.TOOLTIP) {
                    if (name == null)
                        name = SearchArgument.tryGetEntryStackTooltip(stack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    if (name != null && !name.isEmpty() && argument.getFunction(!argument.isInclude()).apply(name)) {
                        applicable = false;
                        break;
                    }
                } else if (argument.getArgumentType() == SearchArgument.ArgumentType.TAG) {
                    if (tags == null) {
                        if (stack.getType() == EntryStack.Type.ITEM) {
                            class_2960[] tagsFor = minecraft.method_1562().method_2867().method_15201().method_15191(stack.getItem()).toArray(new class_2960[0]);
                            tags = new String[tagsFor.length];
                            for(int i = 0; i < tagsFor.length; i++)
                                tags[i] = tagsFor[i].toString();
                        } else if (stack.getType() == EntryStack.Type.FLUID) {
                            class_2960[] tagsFor = minecraft.method_1562().method_2867().method_15205().method_15191(stack.getFluid()).toArray(new class_2960[0]);
                            tags = new String[tagsFor.length];
                            for(int i = 0; i < tagsFor.length; i++)
                                tags[i] = tagsFor[i].toString();
                        } else
                            tags = new String[0];
                    }
                    if (tags != null && tags.length > 0) {
                        boolean a = false;
                        for(String tag : tags)
                            if (argument.getFunction(argument.isInclude()).apply(tag))
                                a = true;
                        if (!a) {
                            applicable = false;
                            break;
                        }
                    } else {
                        applicable = false;
                        break;
                    }
                }
            }
            if (applicable)
                return true;
        }
        return false;
    }
    
    @SuppressWarnings("deprecation")
    private List<SearchArgument.SearchArguments> processSearchTerm(String searchTerm) {
        List<SearchArgument.SearchArguments> searchArguments = Lists.newArrayList();
        for(String split : StringUtils.splitByWholeSeparatorPreserveAllTokens(searchTerm.toLowerCase(Locale.ROOT), "|")) {
            String[] terms = StringUtils.split(split);
            if (terms.length == 0)
                searchArguments.add(SearchArgument.SearchArguments.ALWAYS);
            else {
                SearchArgument[] arguments = new SearchArgument[terms.length];
                for(int i = 0; i < terms.length; i++) {
                    String term = terms[i];
                    if (term.startsWith("-@") || term.startsWith("@-")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.MOD, term.substring(2), false);
                    } else if (term.startsWith("@")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.MOD, term.substring(1), true);
                    } else if (term.startsWith("-$") || term.startsWith("$-")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TAG, term.substring(2), false);
                    } else if (term.startsWith("$")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TAG, term.substring(1), true);
                    } else if (term.startsWith("-#") || term.startsWith("#-")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, term.substring(2), false);
                    } else if (term.startsWith("#")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, term.substring(1), true);
                    } else if (term.startsWith("-")) {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TEXT, term.substring(1), false);
                    } else {
                        arguments[i] = new SearchArgument(SearchArgument.ArgumentType.TEXT, term, true);
                    }
                }
                searchArguments.add(new SearchArgument.SearchArguments(arguments));
            }
        }
        return searchArguments;
    }
    
    @Override
    public List<? extends Widget> children() {
        return widgets;
    }
    
    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        double height = getMaxScroll();
        int actualHeight = bounds.height;
        if (height > actualHeight && double_2 >= bounds.y && double_2 <= bounds.getMaxY()) {
            double scrollbarPositionMinX = getScrollbarMinX();
            if (double_1 >= scrollbarPositionMinX - 1 & double_1 <= scrollbarPositionMinX + 8) {
                this.draggingScrollBar = true;
                return true;
            }
        }
        this.draggingScrollBar = false;
        
        if (containsMouse(double_1, double_2)) {
            class_746 player = minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets())
                return false;
            for(Widget widget : children())
                if (widget.mouseClicked(double_1, double_2, int_1))
                    return true;
        }
        return false;
    }
    
    private class EntryListEntry extends EntryWidget {
        private int backupY;
        private boolean isFavorites;
        
        private EntryListEntry(int x, int y) {
            super(x, y);
            this.backupY = y;
        }
        
        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && bounds.contains(mouseX, mouseY);
        }
        
        @Override
        protected void drawHighlighted(int mouseX, int mouseY, float delta) {
            if (getCurrentEntry().getType() != EntryStack.Type.EMPTY)
                super.drawHighlighted(mouseX, mouseY, delta);
        }
        
        private String getLocalizedName(class_3675.class_306 value) {
            String string_1 = value.method_1441();
            int int_1 = value.method_1444();
            String string_2 = null;
            switch (value.method_1442()) {
                case field_1668:
                    string_2 = class_3675.method_15988(int_1);
                    break;
                case field_1671:
                    string_2 = class_3675.method_15982(int_1);
                    break;
                case field_1672:
                    String string_3 = class_1074.method_4662(string_1, new Object[0]);
                    string_2 = Objects.equals(string_3, string_1) ? class_1074.method_4662(class_3675.class_307.field_1672.method_15989(), new Object[]{int_1 + 1}) : string_3;
            }
            
            return string_2 == null ? class_1074.method_4662(string_1, new Object[0]) : string_2;
        }
        
        @Override
        protected void queueTooltip(int mouseX, int mouseY, float delta) {
            if (!ClientHelper.getInstance().isCheating() || minecraft.field_1724.field_7514.method_7399().method_7960()) {
                QueuedTooltip tooltip = getCurrentTooltip(mouseX, mouseY);
                if (tooltip != null) {
                    //                    if (ConfigObject.getInstance().doDisplayFavoritesTooltip()) {
                    if (ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
                        String name = getLocalizedName(ConfigObject.getInstance().getFavoriteKeybind());
                        if (!isFavorites)
                            tooltip.getText().addAll(Arrays.asList(class_1074.method_4662("text.rei.favorites_tooltip", name).split("\n")));
                        else
                            tooltip.getText().addAll(Arrays.asList(class_1074.method_4662("text.rei.remove_favorites_tooltip", name).split("\n")));
                    }
                    ScreenHelper.getLastOverlay().addTooltip(tooltip);
                }
            }
        }
        
        @Override
        public boolean keyPressed(int int_1, int int_2, int int_3) {
            if (interactable && ConfigObject.getInstance().isFavoritesEnabled() && containsMouse(PointHelper.fromMouse()) && !getCurrentEntry().isEmpty()) {
                class_3675.class_306 keyCode = ConfigObject.getInstance().getFavoriteKeybind();
                if (int_1 == class_3675.field_16237.method_1444()) {
                    if (keyCode.method_1442() == class_3675.class_307.field_1671 && keyCode.method_1444() == int_2) {
                        if (!isFavorites) {
                            ConfigManager.getInstance().getFavorites().add(getCurrentEntry().copy());
                            ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                        } else {
                            ConfigManager.getInstance().getFavorites().remove(getCurrentEntry());
                            ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                        }
                        ConfigManager.getInstance().saveConfig();
                        minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                        return true;
                    }
                } else if (keyCode.method_1442() == class_3675.class_307.field_1668 && keyCode.method_1444() == int_1) {
                    if (!isFavorites) {
                        ConfigManager.getInstance().getFavorites().add(getCurrentEntry().copy());
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                    } else {
                        ConfigManager.getInstance().getFavorites().remove(getCurrentEntry());
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                    }
                    ConfigManager.getInstance().saveConfig();
                    minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
                    return true;
                }
            }
            return super.keyPressed(int_1, int_2, int_3);
        }
        
        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!interactable)
                return super.mouseClicked(mouseX, mouseY, button);
            if (containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating()) {
                EntryStack entry = getCurrentEntry().copy();
                if (entry.getType() == EntryStack.Type.ITEM) {
                    if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.REI_LIKE)
                        entry.setAmount(button != 1 ? 1 : entry.getItemStack().method_7914());
                    else if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.JEI_LIKE)
                        entry.setAmount(button != 0 ? 1 : entry.getItemStack().method_7914());
                    else
                        entry.setAmount(1);
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}
