/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.*;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4720;
import net.minecraft.class_4722;
import net.minecraft.class_756;
import net.minecraft.class_809;
import net.minecraft.class_918;
import net.minecraft.client.render.*;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Deprecated
public class ItemEntryStack extends AbstractEntryStack {
    
    private class_1799 itemStack;
    
    public ItemEntryStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }
    
    @Override
    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11142.method_10221(getItem()));
    }
    
    @Override
    public Type getType() {
        return Type.ITEM;
    }
    
    @Override
    public int getAmount() {
        return itemStack.method_7947();
    }
    
    @Override
    public void setAmount(int amount) {
        itemStack.method_7939(amount);
    }
    
    @Override
    public boolean isEmpty() {
        return itemStack.method_7960();
    }
    
    @Override
    public EntryStack copy() {
        EntryStack stack = EntryStack.create(getItemStack().method_7972());
        for(Map.Entry<Settings, Object> entry : getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }
    
    @Override
    public Object getObject() {
        return itemStack;
    }
    
    @Override
    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        return itemStack.method_7909() == stack.getItem();
    }
    
    @Override
    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem() || getAmount() != stack.getAmount())
            return false;
        return class_1799.method_7975(itemStack, stack.getItemStack());
    }
    
    @Override
    public boolean equalsIgnoreAmount(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem())
            return false;
        return class_1799.method_7975(itemStack, stack.getItemStack());
    }
    
    @Override
    public boolean equalsIgnoreTags(EntryStack stack) {
        if (stack.getType() != Type.ITEM)
            return false;
        if (itemStack.method_7909() != stack.getItem())
            return false;
        return getAmount() == stack.getAmount();
    }
    
    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + getType().ordinal();
        result = 31 * result + itemStack.method_7909().hashCode();
        result = 31 * result + itemStack.method_7947();
        result = 31 * result + (itemStack.method_7985() ? itemStack.method_7969().hashCode() : 0);
        return result;
    }
    
    @Nullable
    @Override
    public QueuedTooltip getTooltip(int mouseX, int mouseY) {
        if (isEmpty() || !getSetting(Settings.TOOLTIP_ENABLED).value().get())
            return null;
        List<String> toolTip = Lists.newArrayList(SearchArgument.tryGetItemStackToolTip(getItemStack(), true));
        toolTip.addAll(getSetting(Settings.TOOLTIP_APPEND_EXTRA).value().apply(this));
        if (getSetting(Settings.TOOLTIP_APPEND_MOD).value().get() && ConfigObject.getInstance().shouldAppendModNames()) {
            final String modString = ClientHelper.getInstance().getFormattedModFromItem(getItem());
            boolean alreadyHasMod = false;
            for(String s : toolTip)
                if (s.equalsIgnoreCase(modString)) {
                    alreadyHasMod = true;
                    break;
                }
            if (!alreadyHasMod)
                toolTip.add(modString);
        }
        return QueuedTooltip.create(toolTip);
    }
    
    @Override
    public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!isEmpty() && getSetting(Settings.RENDER).value().get()) {
            class_1799 stack = getItemStack();
            if (ConfigObject.getInstance().doesFastEntryRendering()) {
                class_918 itemRenderer = class_310.method_1551().method_1480();
                class_1087 model = itemRenderer.method_4012().method_3308(stack);
                if (stack.method_7909().method_7845())
                    model = model.method_4710().method_3495(model, stack, null, null);
                if (model != null) {
                    class_4493.method_21926();
                    class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
                    class_4493.method_21920();
                    class_4493.method_21999(bounds.getCenterX(), bounds.getCenterY(), 100.0F + getZ());
                    class_4493.method_21980(16.0F, -16.0F, 16.0F);
                    class_4587 matrices = new class_4587();
                    class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
                    class_1792 item = stack.method_7909();
                    boolean bl = !model.method_4712() || item == class_1802.field_8255 || item == class_1802.field_8547;
                    if (bl)
                        class_4493.method_24221();
                    model.method_4709().method_3503(class_809.class_811.field_4317).method_23075(false, matrices);
                    matrices.method_22904(-0.5D, -0.5D, -0.5D);
                    if (!model.method_4713()) {
                        class_1921 renderLayer = class_4696.method_23678(stack);
                        if (Objects.equals(renderLayer, class_4722.method_24075()))
                            renderLayer = class_4722.method_24076();
                        class_4588 vertexConsumer = stack.method_7958() && getSetting(Settings.Item.RENDER_ENCHANTMENT_GLINT).value().get() ? class_4720.method_24037(immediate.getBuffer(class_1921.method_23590()), immediate.getBuffer(renderLayer)) : immediate.getBuffer(renderLayer);
                        ((ItemRendererHooks) itemRenderer).rei_renderBakedItemModel(model, stack, 15728880, class_4608.field_21444, matrices, vertexConsumer);
                    } else {
                        class_756.field_3986.method_3166(stack, matrices, immediate, 15728880, class_4608.field_21444);
                    }
                    immediate.method_22993();
                    if (bl)
                        class_4493.method_24222();
                    class_4493.method_21922();
                    class_4493.method_21928();
                }
            } else {
                ((ItemStackHook) (Object) stack).rei_setRenderEnchantmentGlint(getSetting(Settings.Item.RENDER_ENCHANTMENT_GLINT).value().get());
                class_918 itemRenderer = class_310.method_1551().method_1480();
                itemRenderer.field_4730 = getZ();
                int i1 = bounds.getCenterX() - 8;
                int i2 = bounds.getCenterY() - 8;
                itemRenderer.method_4010(stack, i1, i2);
                itemRenderer.method_4022(class_310.method_1551().field_1772, stack, i1, i2, getSetting(Settings.RENDER_COUNTS).value().get() ? getSetting(Settings.COUNTS).value().apply(this) : "");
                itemRenderer.field_4730 = 0.0F;
                ((ItemStackHook) (Object) stack).rei_setRenderEnchantmentGlint(true);
            }
        }
    }
}
