/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin.autocrafting;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.AutoTransferHandler;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.TransferRecipeDisplay;
import me.shedaniel.rei.listeners.RecipeBookGuiHooks;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.ContainerInfoHandler;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1074;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_518;
import java.util.List;

public class DefaultCategoryHandler implements AutoTransferHandler {
    
    public static boolean canUseMovePackets() {
        return ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET);
    }
    
    @Override
    public Result handle(Context context) {
        if (!(context.getRecipe() instanceof TransferRecipeDisplay))
            return Result.createNotApplicable();
        TransferRecipeDisplay recipe = (TransferRecipeDisplay) context.getRecipe();
        class_465<?> containerScreen = context.getContainerScreen();
        class_1703 container = containerScreen.method_17577();
        ContainerInfo containerInfo = ContainerInfoHandler.getContainerInfo(recipe.getRecipeCategory(), container.getClass());
        if (containerInfo == null)
            return Result.createNotApplicable();
        if (recipe.getHeight() > containerInfo.getCraftingHeight(container) || recipe.getWidth() > containerInfo.getCraftingWidth(container))
            return Result.createFailed(class_1074.method_4662("error.rei.transfer.too_small", containerInfo.getCraftingWidth(container), containerInfo.getCraftingHeight(container)));
        List<List<EntryStack>> input = recipe.getOrganisedInputEntries(containerInfo, container);
        IntList intList = hasItems(input);
        if (!intList.isEmpty())
            return Result.createFailed("error.rei.not.enough.materials", intList);
        if (!canUseMovePackets())
            return Result.createFailed("error.rei.not.on.server");
        if (!context.isActuallyCrafting())
            return Result.createSuccessful();
        
        context.getMinecraft().method_1507(containerScreen);
        if (containerScreen instanceof class_518)
            ((RecipeBookGuiHooks) ((class_518) containerScreen).method_2659()).rei_getGhostSlots().method_2571();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(recipe.getRecipeCategory());
        buf.writeBoolean(class_437.hasShiftDown());
        
        buf.writeInt(input.size());
        for (List<EntryStack> stacks : input) {
            buf.writeInt(stacks.size());
            for (EntryStack stack : stacks) {
                if (stack.getItemStack() != null)
                    buf.method_10793(stack.getItemStack());
                else
                    buf.method_10793(class_1799.field_8037);
            }
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, buf);
        return Result.createSuccessful();
    }
    
    @Override
    public double getPriority() {
        return -10;
    }
    
    public IntList hasItems(List<List<EntryStack>> inputs) {
        // Create a clone of player's inventory, and count
        class_2371<class_1799> copyMain = class_2371.method_10211();
        for (class_1799 stack : class_310.method_1551().field_1724.field_7514.field_7547) {
            copyMain.add(stack.method_7972());
        }
        IntList intList = new IntArrayList();
        for (int i = 0; i < inputs.size(); i++) {
            List<EntryStack> possibleStacks = inputs.get(i);
            boolean done = possibleStacks.isEmpty();
            for (EntryStack possibleStack : possibleStacks) {
                if (!done) {
                    int invRequiredCount = possibleStack.getAmount();
                    for (class_1799 stack : copyMain) {
                        EntryStack entryStack = EntryStack.create(stack);
                        if (entryStack.equals(possibleStack)) {
                            while (invRequiredCount > 0 && !stack.method_7960()) {
                                invRequiredCount--;
                                stack.method_7934(1);
                            }
                        }
                    }
                    if (invRequiredCount <= 0) {
                        done = true;
                        break;
                    }
                }
            }
            if (!done) {
                intList.add(i);
            }
        }
        return intList;
    }
}
