/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.server;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1703;
import net.minecraft.class_2960;

public class ContainerInfoHandler {
    private static final Map<String, Map<Class<? extends class_1703>, ContainerInfo>> containerInfoMap = Maps.newLinkedHashMap();
    
    public static void registerContainerInfo(class_2960 category, ContainerInfo containerInfo) {
        if (!containerInfoMap.containsKey(category.toString()))
            containerInfoMap.put(category.toString(), Maps.newLinkedHashMap());
        containerInfoMap.get(category.toString()).put(containerInfo.getContainerClass(), containerInfo);
    }
    
    public static boolean isCategoryHandled(class_2960 category) {
        return containerInfoMap.containsKey(category.toString()) && !containerInfoMap.get(category.toString()).isEmpty();
    }
    
    public static ContainerInfo getContainerInfo(class_2960 category, Class<?> containerClass) {
        if (!isCategoryHandled(category))
            return null;
        Map<Class<? extends class_1703>, ContainerInfo> infoMap = containerInfoMap.get(category.toString());
        if (infoMap.containsKey(containerClass))
            return infoMap.get(containerClass);
        for (Map.Entry<Class<? extends class_1703>, ContainerInfo> entry : infoMap.entrySet())
            if (entry.getKey().isAssignableFrom(containerClass))
                return entry.getValue();
        return null;
    }
}
