/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import me.shedaniel.cloth.hooks.ClothClientHooks;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.annotations.Internal;
import me.shedaniel.rei.api.plugins.REIPluginV0;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.ConfigManagerImpl;
import me.shedaniel.rei.impl.DisplayHelperImpl;
import me.shedaniel.rei.impl.EntryRegistryImpl;
import me.shedaniel.rei.impl.RecipeHelperImpl;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.listeners.RecipeBookButtonWidgetHooks;
import me.shedaniel.rei.listeners.RecipeBookGuiHooks;
import me.shedaniel.rei.tests.plugin.REITestPlugin;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_505;
import net.minecraft.class_507;
import net.minecraft.class_518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Internal
public class RoughlyEnoughItemsCore
implements ClientModInitializer {
    @Internal
    public static final Logger LOGGER;
    private static final RecipeHelper RECIPE_HELPER;
    private static final EntryRegistry ENTRY_REGISTRY;
    private static final DisplayHelper DISPLAY_HELPER;
    private static final Map<class_2960, REIPluginEntry> plugins;
    private static final ExecutorService SYNC_RECIPES;
    private static ConfigManager configManager;

    @Deprecated
    public static RecipeHelper getRecipeHelper() {
        return RECIPE_HELPER;
    }

    @Deprecated
    public static ConfigManager getConfigManager() {
        return configManager;
    }

    @Deprecated
    public static EntryRegistry getEntryRegistry() {
        return ENTRY_REGISTRY;
    }

    @Deprecated
    public static DisplayHelper getDisplayHelper() {
        return DISPLAY_HELPER;
    }

    @Deprecated
    public static REIPluginEntry registerPlugin(REIPluginEntry plugin) {
        plugins.put(plugin.getPluginIdentifier(), plugin);
        LOGGER.debug("[REI] Registered plugin %s from %s", (Object)plugin.getPluginIdentifier().toString(), (Object)plugin.getClass().getSimpleName());
        return plugin;
    }

    public static List<REIPluginEntry> getPlugins() {
        return new LinkedList<REIPluginEntry>(plugins.values());
    }

    public static Optional<class_2960> getPluginIdentifier(REIPluginEntry plugin) {
        for (class_2960 identifier : plugins.keySet()) {
            if (identifier == null || !plugins.get(identifier).equals(plugin)) continue;
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    public static boolean hasPermissionToUsePackets() {
        try {
            class_310.method_1551().method_1562().method_2875().method_9259(0);
            return RoughlyEnoughItemsCore.hasOperatorPermission() && RoughlyEnoughItemsCore.canUsePackets();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static boolean hasOperatorPermission() {
        try {
            return class_310.method_1551().method_1562().method_2875().method_9259(1);
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static boolean canUsePackets() {
        return ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET) && ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET);
    }

    @Internal
    @Deprecated
    public static void syncRecipes(AtomicLong lastSync) {
        if (lastSync != null) {
            if (lastSync.get() > 0L && System.currentTimeMillis() - lastSync.get() <= 5000L) {
                LOGGER.warn("[REI] Suppressing Sync Recipes!");
                return;
            }
            lastSync.set(System.currentTimeMillis());
        }
        class_1863 recipeManager = class_310.method_1551().method_1562().method_2877();
        if (ConfigObject.getInstance().doesRegisterRecipesInAnotherThread()) {
            CompletableFuture.runAsync(() -> ((RecipeHelperImpl)RecipeHelper.getInstance()).recipesLoaded(recipeManager), SYNC_RECIPES);
        } else {
            ((RecipeHelperImpl)RecipeHelper.getInstance()).recipesLoaded(recipeManager);
        }
    }

    public void onInitializeClient() {
        configManager = new ConfigManagerImpl();
        this.registerClothEvents();
        this.discoverPluginEntries();
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (!modContainer.getMetadata().containsCustomValue("roughlyenoughitems:plugins")) continue;
            LOGGER.error("[REI] REI plugin from " + modContainer.getMetadata().getId() + " is not loaded because it is too old!");
        }
        ClientSidePacketRegistry.INSTANCE.register(RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (packetContext, packetByteBuf) -> {
            class_1799 stack = packetByteBuf.method_10819();
            String player = packetByteBuf.method_10800(Short.MAX_VALUE);
            packetContext.getPlayer().method_7353((class_2561)new class_2585(class_1074.method_4662((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", SearchArgument.tryGetItemStackName(stack.method_7972())).replaceAll("\\{item_count}", stack.method_7972().method_7947() + "").replaceAll("\\{player_name}", player)), false);
        });
        ClientSidePacketRegistry.INSTANCE.register(RoughlyEnoughItemsNetwork.NOT_ENOUGH_ITEMS_PACKET, (packetContext, packetByteBuf) -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen instanceof class_479) {
                class_507 recipeBookGui = ((class_518)currentScreen).method_2659();
                class_505 ghostSlots = ((RecipeBookGuiHooks)recipeBookGui).rei_getGhostSlots();
                ghostSlots.method_2571();
                ArrayList input = Lists.newArrayList();
                int mapSize = packetByteBuf.readInt();
                for (int i = 0; i < mapSize; ++i) {
                    ArrayList list = Lists.newArrayList();
                    int count = packetByteBuf.readInt();
                    for (int j = 0; j < count; ++j) {
                        list.add(packetByteBuf.method_10819());
                    }
                    input.add(list);
                }
                ghostSlots.method_2569(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20391}), 381203812, 12738291);
                class_1714 container = (class_1714)((class_479)currentScreen).method_17577();
                for (int i = 0; i < input.size(); ++i) {
                    List stacks = (List)input.get(i);
                    if (stacks.isEmpty()) continue;
                    class_1735 slot = container.method_7611(i + container.method_7655() + 1);
                    ghostSlots.method_2569(class_1856.method_8101((class_1799[])stacks.toArray(new class_1799[0])), slot.field_7873, slot.field_7872);
                }
            }
        });
    }

    private void discoverPluginEntries() {
        for (REIPluginEntry reiPlugin : FabricLoader.getInstance().getEntrypoints("rei_plugins", REIPluginEntry.class)) {
            try {
                if (!REIPluginV0.class.isAssignableFrom(reiPlugin.getClass())) {
                    throw new IllegalArgumentException("REI plugin is too old!");
                }
                RoughlyEnoughItemsCore.registerPlugin(reiPlugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("[REI] Can't load REI plugins from %s: %s", reiPlugin.getClass(), (Object)e.getLocalizedMessage());
            }
        }
        for (REIPluginEntry reiPlugin : FabricLoader.getInstance().getEntrypoints("rei_plugins_v0", REIPluginV0.class)) {
            try {
                RoughlyEnoughItemsCore.registerPlugin(reiPlugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("[REI] Can't load REI plugins from %s: %s", reiPlugin.getClass(), (Object)e.getLocalizedMessage());
            }
        }
        this.loadTestPlugins();
    }

    private void loadTestPlugins() {
        if (System.getProperty("rei.test", "false").equals("true")) {
            RoughlyEnoughItemsCore.registerPlugin(new REITestPlugin());
        }
    }

    private void registerClothEvents() {
        class_2960 recipeButtonTex = new class_2960("textures/gui/recipe_button.png");
        AtomicLong lastSync = new AtomicLong(-1L);
        ClothClientHooks.SYNC_RECIPES.register((minecraftClient, recipeManager, synchronizeRecipesS2CPacket) -> RoughlyEnoughItemsCore.syncRecipes(lastSync));
        ClothClientHooks.SCREEN_ADD_BUTTON.register((minecraftClient, screen, abstractButtonWidget) -> {
            if (ConfigObject.getInstance().doesDisableRecipeBook() && screen instanceof class_465 && abstractButtonWidget instanceof class_344 && ((RecipeBookButtonWidgetHooks)abstractButtonWidget).rei_getTexture().equals((Object)recipeButtonTex)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_INIT_POST.register((minecraftClient, screen, screenHooks) -> {
            if (screen instanceof class_465) {
                if (screen instanceof class_490 && minecraftClient.field_1761.method_2914()) {
                    return;
                }
                ScreenHelper.setLastContainerScreen((class_465)screen);
                boolean alreadyAdded = false;
                for (class_364 element : Lists.newArrayList((Iterable)screenHooks.cloth_getInputListeners())) {
                    if (!ContainerScreenOverlay.class.isAssignableFrom(element.getClass())) continue;
                    if (alreadyAdded) {
                        screenHooks.cloth_getInputListeners().remove(element);
                        continue;
                    }
                    alreadyAdded = true;
                }
                if (!alreadyAdded) {
                    screenHooks.cloth_getInputListeners().add(ScreenHelper.getLastOverlay(true, false));
                }
            }
        });
        ClothClientHooks.SCREEN_RENDER_POST.register((minecraftClient, screen, i, i1, v) -> {
            if (screen instanceof class_465) {
                ScreenHelper.getLastOverlay().render(i, i1, v);
            }
        });
        ClothClientHooks.SCREEN_MOUSE_DRAGGED.register((minecraftClient, screen, v, v1, i, v2, v3) -> {
            if (screen instanceof class_465 && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().mouseDragged(v, v1, i, v2, v3)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_MOUSE_CLICKED.register((minecraftClient, screen, v, v1, i) -> {
            if (screen instanceof class_481 && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().mouseClicked(v, v1, i)) {
                screen.setFocused((class_364)ScreenHelper.getLastOverlay());
                if (i == 0) {
                    screen.setDragging(true);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_MOUSE_SCROLLED.register((minecraftClient, screen, v, v1, v2) -> {
            if (screen instanceof class_465 && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().mouseScrolled(v, v1, v2)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_CHAR_TYPED.register((minecraftClient, screen, character, keyCode) -> {
            if (screen instanceof class_465 && ScreenHelper.getLastOverlay().charTyped(character, keyCode)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_LATE_RENDER.register((minecraftClient, screen, i, i1, v) -> {
            if (!ScreenHelper.isOverlayVisible()) {
                return;
            }
            if (screen instanceof class_465) {
                ScreenHelper.getLastOverlay().lateRender(i, i1, v);
            }
        });
        ClothClientHooks.SCREEN_KEY_PRESSED.register((minecraftClient, screen, i, i1, i2) -> {
            if (screen.getFocused() != null && screen.getFocused() instanceof class_342 || screen.getFocused() instanceof class_507 && ((RecipeBookGuiHooks)screen.getFocused()).rei_getSearchField() != null && ((RecipeBookGuiHooks)screen.getFocused()).rei_getSearchField().isFocused()) {
                return class_1269.field_5811;
            }
            if (screen instanceof class_465 && ScreenHelper.getLastOverlay().keyPressed(i, i1, i2)) {
                return class_1269.field_5812;
            }
            if (screen instanceof class_465 && configManager.getConfig().doesDisableRecipeBook() && configManager.getConfig().doesFixTabCloseContainer() && i == 258 && minecraftClient.field_1690.field_1822.method_1417(i, i1)) {
                minecraftClient.field_1724.method_7346();
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    static {
        RECIPE_HELPER = new RecipeHelperImpl();
        ENTRY_REGISTRY = new EntryRegistryImpl();
        DISPLAY_HELPER = new DisplayHelperImpl();
        plugins = Maps.newHashMap();
        SYNC_RECIPES = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "REI-SyncRecipes"));
        LOGGER = LogManager.getFormatterLogger((String)"REI");
    }
}

