/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.annotations.Internal;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;

public class OverlaySearchField
extends TextFieldWidget {
    public static boolean isSearching = false;
    public long keybindFocusTime = -1L;
    public int keybindFocusKey = -1;
    protected long lastClickedTime = -1L;
    private List<String> history = Lists.newArrayListWithCapacity((int)100);

    OverlaySearchField(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setMaxLength(10000);
    }

    @Override
    public void setFocused(boolean boolean_1) {
        if (this.isFocused() != boolean_1) {
            this.addToHistory(this.getText());
        }
        super.setFocused(boolean_1);
    }

    @Deprecated
    @Internal
    public void addToHistory(String text) {
        if (!text.isEmpty()) {
            this.history.removeIf(str -> str.equalsIgnoreCase(text));
            this.history.add(text);
            if (this.history.size() > 100) {
                this.history.remove(0);
            }
        }
    }

    public void laterRender(int int_1, int int_2, float float_1) {
        RenderSystem.disableDepthTest();
        this.setEditableColor(ContainerScreenOverlay.getEntryListWidget().getAllStacks().isEmpty() && !this.getText().isEmpty() ? 0xFF5555 : (isSearching ? -852212 : (this.containsMouse(PointHelper.fromMouse()) || this.isFocused() ? (ScreenHelper.isDarkModeEnabled() ? -17587 : -1) : -6250336)));
        this.setSuggestion(!this.isFocused() && this.getText().isEmpty() ? class_1074.method_4662((String)"text.rei.search.field.suggestion", (Object[])new Object[0]) : null);
        super.render(int_1, int_2, float_1);
        RenderSystem.enableDepthTest();
    }

    @Override
    public void renderBorder() {
        if (!isSearching) {
            super.renderBorder();
        } else if (this.hasBorder()) {
            OverlaySearchField.fill((int)(this.getBounds().x - 1), (int)(this.getBounds().y - 1), (int)(this.getBounds().x + this.getBounds().width + 1), (int)(this.getBounds().y + this.getBounds().height + 1), (int)-852212);
            OverlaySearchField.fill((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + this.getBounds().width), (int)(this.getBounds().y + this.getBounds().height), (int)-16777216);
        }
    }

    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        boolean contains = this.containsMouse(double_1, double_2);
        if (this.isVisible() && contains && int_1 == 1) {
            this.setText("");
        }
        if (contains && int_1 == 0) {
            if (this.lastClickedTime == -1L) {
                this.lastClickedTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.lastClickedTime > 1200L) {
                this.lastClickedTime = -1L;
            } else {
                this.lastClickedTime = -1L;
                isSearching = !isSearching;
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            }
        }
        return super.mouseClicked(double_1, double_2, int_1);
    }

    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.isVisible() && this.isFocused()) {
            int i;
            if (int_1 == 257 || int_1 == 335) {
                this.addToHistory(this.getText());
                this.setFocused(false);
                return true;
            }
            if (int_1 == 265) {
                int i2 = this.history.indexOf(this.getText()) - 1;
                if (i2 < -1 && this.getText().isEmpty()) {
                    i2 = this.history.size() - 1;
                } else if (i2 < -1) {
                    this.addToHistory(this.getText());
                    i2 = this.history.size() - 2;
                }
                if (i2 >= 0) {
                    this.setText(this.history.get(i2));
                    return true;
                }
            } else if (int_1 == 264 && (i = this.history.indexOf(this.getText()) + 1) > 0) {
                this.setText(i < this.history.size() ? this.history.get(i) : "");
                return true;
            }
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    @Override
    public boolean charTyped(char char_1, int int_1) {
        if (System.currentTimeMillis() - this.keybindFocusTime < 1000L && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)this.keybindFocusKey)) {
            this.keybindFocusTime = -1L;
            this.keybindFocusKey = -1;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return ScreenHelper.getLastOverlay().isNotInExclusionZones(mouseX, mouseY) && super.containsMouse(mouseX, mouseY);
    }

    @Override
    public void render(int int_1, int int_2, float float_1) {
    }
}

