/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;

public abstract class ButtonWidget
extends WidgetWithBounds {
    protected static final class_2960 BUTTON_LOCATION = new class_2960("roughlyenoughitems", "textures/gui/button.png");
    protected static final class_2960 BUTTON_LOCATION_DARK = new class_2960("roughlyenoughitems", "textures/gui/button_dark.png");
    public boolean enabled;
    public boolean focused;
    private String text;
    private Rectangle bounds;

    public ButtonWidget(Rectangle rectangle, class_2561 text) {
        this(rectangle, Objects.requireNonNull(text).method_10863());
    }

    public ButtonWidget(Rectangle rectangle, String text) {
        this.bounds = Objects.requireNonNull(rectangle);
        this.enabled = true;
        this.text = Objects.requireNonNull(text);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected int getTextureId(boolean boolean_1) {
        int int_1 = 1;
        if (!this.enabled) {
            int_1 = 0;
        } else if (boolean_1) {
            int_1 = ConfigObject.getInstance().isLighterButtonHover() ? 4 : 3;
        }
        return int_1;
    }

    protected void renderBackground(int x, int y, int width, int height, int textureOffset) {
        this.minecraft.method_1531().method_22813(ScreenHelper.isDarkModeEnabled() ? BUTTON_LOCATION_DARK : BUTTON_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        ButtonWidget.blit((int)x, (int)y, (int)this.getBlitOffset(), (float)0.0f, (float)(textureOffset * 80), (int)4, (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)(x + width - 4), (int)y, (int)this.getBlitOffset(), (float)252.0f, (float)(textureOffset * 80), (int)4, (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)x, (int)(y + height - 4), (int)this.getBlitOffset(), (float)0.0f, (float)(textureOffset * 80 + 76), (int)4, (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)(x + width - 4), (int)(y + height - 4), (int)this.getBlitOffset(), (float)252.0f, (float)(textureOffset * 80 + 76), (int)4, (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)(x + 4), (int)y, (int)this.getBlitOffset(), (float)4.0f, (float)(textureOffset * 80), (int)class_3532.method_15386((float)((float)(width - 8) / 2.0f)), (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)(x + 4), (int)(y + height - 4), (int)this.getBlitOffset(), (float)4.0f, (float)(textureOffset * 80 + 76), (int)class_3532.method_15386((float)((float)(width - 8) / 2.0f)), (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)(x + 4 + class_3532.method_15386((float)((float)(width - 8) / 2.0f))), (int)(y + height - 4), (int)this.getBlitOffset(), (float)(252 - class_3532.method_15375((float)((float)(width - 8) / 2.0f))), (float)(textureOffset * 80 + 76), (int)class_3532.method_15375((float)((float)(width - 8) / 2.0f)), (int)4, (int)512, (int)256);
        ButtonWidget.blit((int)(x + 4 + class_3532.method_15386((float)((float)(width - 8) / 2.0f))), (int)y, (int)this.getBlitOffset(), (float)(252 - class_3532.method_15375((float)((float)(width - 8) / 2.0f))), (float)(textureOffset * 80), (int)class_3532.method_15375((float)((float)(width - 8) / 2.0f)), (int)4, (int)512, (int)256);
        for (int i = y + 4; i < y + height - 4; i += 76) {
            ButtonWidget.blit((int)x, (int)i, (int)this.getBlitOffset(), (float)0.0f, (float)(4 + textureOffset * 80), (int)class_3532.method_15386((float)((float)width / 2.0f)), (int)class_3532.method_15340((int)(y + height - 4 - i), (int)0, (int)76), (int)512, (int)256);
            ButtonWidget.blit((int)(x + class_3532.method_15386((float)((float)width / 2.0f))), (int)i, (int)this.getBlitOffset(), (float)(256 - class_3532.method_15375((float)((float)width / 2.0f))), (float)(4 + textureOffset * 80), (int)class_3532.method_15375((float)((float)width / 2.0f)), (int)class_3532.method_15340((int)(y + height - 4 - i), (int)0, (int)76), (int)512, (int)256);
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        this.renderBackground(x, y, width, height, this.getTextureId(this.isHovered(mouseX, mouseY)));
        int color = 0xE0E0E0;
        if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.isHovered(mouseX, mouseY)) {
            color = 0xFFFFA0;
        }
        this.drawCenteredString(this.font, this.getText(), x + width / 2, y + (height - 8) / 2, color);
        if (this.getTooltips().isPresent()) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
            } else if (this.focused) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(new Point(x + width / 2, y + height / 2), this.getTooltips().get().split("\n")));
            }
        }
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.isMouseOver(mouseX, mouseY) || this.focused;
    }

    public boolean changeFocus(boolean boolean_1) {
        if (!this.enabled) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.enabled && button == 0) {
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            this.onPressed();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.enabled && this.focused) {
            if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
                return false;
            }
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            this.onPressed();
            return true;
        }
        return false;
    }

    public abstract void onPressed();

    public Optional<String> getTooltips() {
        return Optional.empty();
    }
}

