/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.util.Optional;
import me.shedaniel.math.api.Point;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.ScreenHelper;

public abstract class ClickableLabelWidget
extends LabelWidget {
    public boolean focused;
    private boolean clickable = true;
    private int hoveredColor = ScreenHelper.isDarkModeEnabled() ? -1 : -10027060;

    @Deprecated
    public ClickableLabelWidget(int x, int y, String text, boolean clickable) {
        this(new Point(x, y), text, clickable);
    }

    @Deprecated
    public ClickableLabelWidget(int x, int y, String text) {
        this(new Point(x, y), text, true);
    }

    @Deprecated
    public ClickableLabelWidget(Point point, String text, boolean clickable) {
        this(point, text);
        this.clickable(clickable);
    }

    public ClickableLabelWidget(Point point, String text) {
        super(point, text);
    }

    public LabelWidget hoveredColor(int hoveredColor) {
        this.hoveredColor = hoveredColor;
        return this;
    }

    public LabelWidget clickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        int color = this.getDefaultColor();
        if (this.isClickable() && this.isHovered(mouseX, mouseY)) {
            color = this.getHoveredColor();
        }
        Point pos = this.getPosition();
        int width = this.font.method_1727(this.getText());
        if (this.isCentered()) {
            if (this.isHasShadows()) {
                this.font.method_1720(this.getText(), (float)(pos.x - width / 2), (float)pos.y, color);
            } else {
                this.font.method_1729(this.getText(), (float)(pos.x - width / 2), (float)pos.y, color);
            }
        } else if (this.isHasShadows()) {
            this.font.method_1720(this.getText(), (float)pos.x, (float)pos.y, color);
        } else {
            this.font.method_1729(this.getText(), (float)pos.x, (float)pos.y, color);
        }
        if (this.isClickable() && this.getTooltips().isPresent()) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
            } else if (this.focused) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(pos, this.getTooltips().get().split("\n")));
            }
        }
    }

    public int getHoveredColor() {
        return this.hoveredColor;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            this.onLabelClicked();
            return true;
        }
        return false;
    }

    public Optional<String> getTooltips() {
        return Optional.empty();
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.isClickable() || !this.focused) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        this.onLabelClicked();
        return true;
    }

    public boolean changeFocus(boolean boolean_1) {
        if (!this.isClickable()) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.isClickable() && (this.containsMouse(mouseX, mouseY) || this.focused);
    }

    public abstract void onLabelClicked();
}

