/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.EntryRegistry;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.EntryWidget;
import me.shedaniel.rei.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

public class EntryListWidget
extends WidgetWithBounds {
    static final Supplier<Boolean> RENDER_ENCHANTMENT_GLINT = ConfigObject.getInstance()::doesRenderEntryEnchantmentGlint;
    static final Comparator<? super EntryStack> ENTRY_NAME_COMPARER = Comparator.comparing(SearchArgument::tryGetEntryStackName);
    static final Comparator<? super EntryStack> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        class_1761 group;
        if (stack.getType() == EntryStack.Type.ITEM && (group = stack.getItem().method_7859()) != null) {
            return group.method_7741();
        }
        return Integer.MAX_VALUE;
    });
    private static final boolean LAZY = true;
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static int page;
    protected double target;
    protected double scroll;
    protected long start;
    protected long duration;
    protected int blockedCount;
    private boolean debugTime;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack> allStacks = null;
    private List<EntryStack> favorites = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    private List<SearchArgument.SearchArguments> lastSearchArguments = Collections.emptyList();
    private boolean draggingScrollBar = false;

    static boolean notSteppingOnExclusionZones(int left, int top, Rectangle listArea) {
        class_310 instance = class_310.method_1551();
        for (DisplayHelper.DisplayBoundsHandler<?> sortedBoundsHandler : DisplayHelper.getInstance().getSortedBoundsHandlers(instance.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(left, top, instance.field_1755, listArea);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2 - 6) / 18.0f)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle(bounds.getCenterX() - width * 9 + 3, bounds.y, width * 18, bounds.height);
            }
            return new Rectangle(bounds.getCenterX() - width * 9 - 3, bounds.y, width * 18, bounds.height);
        }
        int width = Math.max(class_3532.method_15375((float)((float)(bounds.width - 2) / 18.0f)), 1);
        int height = Math.max(class_3532.method_15375((float)((float)(bounds.height - 2) / 18.0f)), 1);
        return new Rectangle(bounds.getCenterX() - width * 9, bounds.getCenterY() - height * 9, width * 18, height * 18);
    }

    protected final int getSlotsHeightNumberForFavorites() {
        if (this.favorites.isEmpty()) {
            return 0;
        }
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return class_3532.method_15386((float)(2.0f + (float)this.favorites.size() / ((float)this.innerBounds.width / 18.0f)));
        }
        int height = class_3532.method_15386((float)((float)this.favorites.size() / ((float)this.innerBounds.width / 18.0f)));
        int pagesToFit = class_3532.method_15386((float)((float)height / ((float)this.innerBounds.height / 18.0f - 1.0f)));
        if (height > this.innerBounds.height / 18 - 1 && height % (this.innerBounds.height / 18) == this.innerBounds.height / 18 - 2) {
            --height;
        }
        return height + pagesToFit + 1;
    }

    protected final int getScrollNumberForFavorites() {
        if (this.favorites.isEmpty()) {
            return 0;
        }
        return this.innerBounds.width / 18 * this.getSlotsHeightNumberForFavorites();
    }

    protected final int getMaxScrollPosition() {
        if (this.favorites.isEmpty()) {
            return class_3532.method_15386((float)((float)(this.allStacks.size() + this.blockedCount) / ((float)this.innerBounds.width / 18.0f))) * 18;
        }
        return class_3532.method_15386((float)((float)(this.allStacks.size() + this.blockedCount + this.getScrollNumberForFavorites()) / ((float)this.innerBounds.width / 18.0f))) * 18 - 12;
    }

    protected final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - this.innerBounds.height);
    }

    protected final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    protected final double clamp(double v, double clampExtension) {
        return class_3532.method_15350((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    protected final void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    protected final void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    protected final void scrollTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.bounds.contains(double_1, double_2)) {
            this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        EntryListWidget.page = page;
    }

    public void previousPage() {
        --page;
    }

    public void nextPage() {
        ++page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return class_3532.method_15386((float)((float)(this.allStacks.size() + this.getScrollNumberForFavorites()) / (float)this.entries.size()));
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int nextIndex;
            for (EntryListEntry entry : this.entries) {
                entry.clearStacks();
            }
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int sizeForFavorites = this.getSlotsHeightNumberForFavorites();
            int skip = Math.max(0, class_3532.method_15357((double)(this.scroll / 18.0)) - sizeForFavorites);
            int i = nextIndex = skip * this.innerBounds.width / 18;
            this.blockedCount = 0;
            if (this.debugTime) {
                int offset;
                long l;
                EntryListEntry entry;
                EntryStack stack;
                int size = 0;
                long time = 0L;
                if (sizeForFavorites > 0) {
                    this.drawString(this.font, class_1074.method_4662((String)"text.rei.favorites", (Object[])new Object[0]), this.innerBounds.x + 2, (int)((double)(this.innerBounds.y + 8) - this.scroll), -1);
                    nextIndex += this.innerBounds.width / 18;
                    block1: for (int i1 = 0; i1 < this.favorites.size(); ++i1) {
                        stack = this.favorites.get(i1);
                        while (true) {
                            entry = this.entries.get(nextIndex);
                            entry.getBounds().y = (int)((double)entry.backupY - this.scroll);
                            if (entry.getBounds().y > this.bounds.getMaxY()) continue block1;
                            if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                                entry.entry(stack);
                                entry.isFavorites = true;
                                ++size;
                                l = System.currentTimeMillis();
                                entry.render(mouseX, mouseY, delta);
                                time += System.currentTimeMillis() - l;
                                ++nextIndex;
                                continue block1;
                            }
                            ++this.blockedCount;
                            ++nextIndex;
                        }
                    }
                    nextIndex += this.innerBounds.width / -18 + this.getScrollNumberForFavorites() - this.favorites.size();
                }
                int n = offset = sizeForFavorites > 0 ? -12 : 0;
                block3: while (i < this.allStacks.size()) {
                    stack = this.allStacks.get(i);
                    while (true) {
                        entry = this.entries.get(nextIndex);
                        entry.getBounds().y = (int)((double)entry.backupY - this.scroll + (double)offset);
                        if (entry.getBounds().y > this.bounds.getMaxY()) break block3;
                        if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                            entry.entry(stack);
                            entry.isFavorites = false;
                            ++size;
                            l = System.currentTimeMillis();
                            entry.render(mouseX, mouseY, delta);
                            time += System.currentTimeMillis() - l;
                            ++nextIndex;
                            break;
                        }
                        ++this.blockedCount;
                        ++nextIndex;
                    }
                    ++i;
                }
                int z = this.getZ();
                this.setZ(500);
                String str = String.format("%d entries, avg. %.2fms, %s fps", size, (double)time / (double)size, this.minecraft.field_1770.split(SPACE)[0]);
                int n2 = this.bounds.x;
                int n3 = this.bounds.y;
                int n4 = this.bounds.x + this.font.method_1727(str) + 2;
                int n5 = this.bounds.y;
                this.font.getClass();
                this.fillGradient(n2, n3, n4, n5 + 9 + 2, -16777216, -16777216);
                class_4587 matrixStack_1 = new class_4587();
                class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                matrixStack_1.method_22904(0.0, 0.0, (double)this.getZ());
                class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
                this.font.method_22942(str, (float)(this.bounds.x + 2), (float)(this.bounds.y + 2), -1, false, matrix4f_1, (class_4597)immediate, false, 0, 0xF000F0);
                immediate.method_22993();
                this.setZ(z);
            } else {
                int offset;
                EntryListEntry entry;
                EntryStack stack;
                if (sizeForFavorites > 0) {
                    this.drawString(this.font, class_1074.method_4662((String)"text.rei.favorites", (Object[])new Object[0]), this.innerBounds.x + 2, (int)((double)(this.innerBounds.y + 8) - this.scroll), -1);
                    nextIndex += this.innerBounds.width / 18;
                    block5: for (int i1 = 0; i1 < this.favorites.size(); ++i1) {
                        stack = this.favorites.get(i1);
                        while (true) {
                            entry = this.entries.get(nextIndex);
                            entry.getBounds().y = (int)((double)entry.backupY - this.scroll);
                            if (entry.getBounds().y > this.bounds.getMaxY()) continue block5;
                            if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                                entry.entry(stack);
                                entry.isFavorites = true;
                                entry.render(mouseX, mouseY, delta);
                                ++nextIndex;
                                continue block5;
                            }
                            ++this.blockedCount;
                            ++nextIndex;
                        }
                    }
                    nextIndex += this.innerBounds.width / -18 + this.getScrollNumberForFavorites() - this.favorites.size();
                }
                int n = offset = sizeForFavorites > 0 ? -12 : 0;
                block7: while (i < this.allStacks.size()) {
                    stack = this.allStacks.get(i);
                    while (true) {
                        entry = this.entries.get(nextIndex);
                        entry.getBounds().y = (int)((double)entry.backupY - this.scroll + (double)offset);
                        if (entry.getBounds().y > this.bounds.getMaxY()) break block7;
                        if (EntryListWidget.notSteppingOnExclusionZones(entry.getBounds().x, entry.getBounds().y, this.innerBounds)) {
                            entry.entry(stack);
                            entry.isFavorites = false;
                            entry.render(mouseX, mouseY, delta);
                            ++nextIndex;
                            break;
                        }
                        ++this.blockedCount;
                        ++nextIndex;
                    }
                    ++i;
                }
            }
            this.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.renderScrollbar();
        } else if (this.debugTime) {
            int size = 0;
            long time = 0L;
            for (Widget widget : this.widgets) {
                if (widget instanceof EntryListEntry) {
                    ++size;
                    long l = System.currentTimeMillis();
                    widget.render(mouseX, mouseY, delta);
                    time += System.currentTimeMillis() - l;
                    continue;
                }
                widget.render(mouseX, mouseY, delta);
            }
            int z = this.getZ();
            this.setZ(500);
            String str = String.format("%d entries, avg. %.2fms, %s fps", size, (double)time / (double)size, this.minecraft.field_1770.split(SPACE)[0]);
            int n = this.bounds.x;
            int n6 = this.bounds.y;
            int n7 = this.bounds.x + this.font.method_1727(str) + 2;
            int n8 = this.bounds.y;
            this.font.getClass();
            this.fillGradient(n, n6, n7, n8 + 9 + 2, -16777216, -16777216);
            class_4587 matrixStack_1 = new class_4587();
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            matrixStack_1.method_22904(0.0, 0.0, (double)this.getZ());
            class_1159 matrix4f_1 = matrixStack_1.method_23760().method_23761();
            this.font.method_22942(str, (float)(this.bounds.x + 2), (float)(this.bounds.y + 2), -1, false, matrix4f_1, (class_4597)immediate, false, 0, 0xF000F0);
            immediate.method_22993();
            this.setZ(z);
        } else {
            for (Widget widget : this.widgets) {
                widget.render(mouseX, mouseY, delta);
            }
        }
    }

    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        float height;
        if (int_1 == 0 && this.draggingScrollBar && (height = (float)this.getMaxScrollPosition()) > (float)(actualHeight = this.innerBounds.height) && mouseY >= (double)this.innerBounds.y && mouseY <= (double)this.innerBounds.getMaxY()) {
            double double_5 = Math.max(1, this.getMaxScroll());
            int int_2 = this.innerBounds.height;
            int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
            double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
            float to = class_3532.method_15363((float)((float)(this.scroll + double_4 * double_6)), (float)0.0f, (float)(height - (float)this.innerBounds.height));
            if (ConfigObject.getInstance().doesSnapToRows()) {
                double nearestRow = (double)Math.round((double)to / 18.0) * 18.0;
                this.scrollTo(nearestRow, false);
            } else {
                this.scrollTo(to, false);
            }
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    private void renderScrollbar() {
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int height = this.innerBounds.height * this.innerBounds.height / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.innerBounds.height - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)maxScroll ? (int)this.scroll - maxScroll : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scroll * (this.innerBounds.height - height) / maxScroll + this.innerBounds.y, this.innerBounds.y), this.innerBounds.getMaxY() - height);
            int scrollbarPositionMinX = this.getScrollbarMinX();
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            float topC = (hovered ? 0.87f : 0.67f) * (ScreenHelper.isDarkModeEnabled() ? 0.8f : 1.0f);
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(bottomC, bottomC, bottomC, 1.0f).method_1344();
            tessellator.method_1350();
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_22915(topC, topC, topC, 1.0f).method_1344();
            tessellator.method_1350();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
    }

    private void updatePosition(float delta) {
        this.target = this.clamp(this.target);
        if (this.target < 0.0) {
            this.target -= this.target * (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0;
        } else if (this.target > (double)this.getMaxScroll()) {
            this.target = (this.target - (double)this.getMaxScroll()) * (1.0 - (1.0 - ClothConfigInitializer.getBounceBackMultiplier()) * (double)delta / 3.0) + (double)this.getMaxScroll();
        } else if (ConfigObject.getInstance().doesSnapToRows()) {
            double nearestRow = (double)Math.round(this.target / 18.0) * 18.0;
            this.target = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.target, (double)nearestRow, (double)0.001f) ? (this.target += (nearestRow - this.target) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scroll = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scroll, (double)this.target, (double)0.001f) ? (double)((float)DynamicNewSmoothScrollingEntryListWidget.Interpolation.expoEase((double)this.scroll, (double)this.target, (double)Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration, 1.0))) : this.target;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.fromMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(DisplayHelper.DisplayBoundsHandler<?> boundsHandler, @Nullable String searchTerm) {
        this.bounds = boundsHandler.getItemListArea(ScreenHelper.getLastOverlay().getBounds());
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(boundsHandler, searchTerm);
        }
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.allStacks == null || this.favorites == null || favoritesListWidget != null && favoritesListWidget.favorites == null) {
            this.updateSearch(EMPTY);
        } else {
            this.updateEntriesPosition();
        }
    }

    public void updateEntriesPosition() {
        FavoritesListWidget favoritesListWidget;
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            page = Math.max(page, 0);
            LinkedList entries = Lists.newLinkedList();
            int width = this.innerBounds.width / 18;
            int height = this.innerBounds.height / 18;
            for (int currentY = 0; currentY < height; ++currentY) {
                for (int currentX = 0; currentX < width; ++currentX) {
                    if (!EntryListWidget.notSteppingOnExclusionZones(currentX * 18 + this.innerBounds.x, currentY * 18 + this.innerBounds.y, this.innerBounds)) continue;
                    entries.add((EntryListEntry)new EntryListEntry(currentX * 18 + this.innerBounds.x, currentY * 18 + this.innerBounds.y).noBackground());
                }
            }
            page = Math.max(Math.min(page, this.getTotalPages() - 1), 0);
            int numberForFavorites = this.getScrollNumberForFavorites();
            List subList = this.allStacks.stream().skip(Math.max(0, page * entries.size() - numberForFavorites)).limit(Math.max(0, entries.size() - Math.max(0, numberForFavorites - page * entries.size()))).collect(Collectors.toList());
            for (int i = 0; i < subList.size(); ++i) {
                EntryStack stack = (EntryStack)subList.get(i);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, numberForFavorites - page * entries.size())))).clearStacks().entry(stack);
                ((EntryListEntry)((Object)entries.get(i + Math.max(0, numberForFavorites - page * entries.size())))).isFavorites = false;
            }
            this.entries = entries;
            this.widgets = Lists.newLinkedList((Iterable)entries);
            if (numberForFavorites > 0) {
                int skippedFavorites = page * (entries.size() - width);
                int j = 0;
                if (skippedFavorites < this.favorites.size()) {
                    this.widgets.add(new LabelWidget(new Point(this.innerBounds.x + 2, this.innerBounds.y + 6), class_1074.method_4662((String)"text.rei.favorites", (Object[])new Object[0])).leftAligned());
                    j += width;
                }
                List subFavoritesList = this.favorites.stream().skip(skippedFavorites).limit(Math.max(0, entries.size() - width)).collect(Collectors.toList());
                for (int i = 0; i < subFavoritesList.size(); ++i) {
                    EntryStack stack = (EntryStack)subFavoritesList.get(i);
                    ((EntryListEntry)((Object)entries.get(j))).clearStacks().entry(stack);
                    ((EntryListEntry)((Object)entries.get(j))).isFavorites = true;
                    ++j;
                }
            }
        } else {
            page = 0;
            int width = this.innerBounds.width / 18;
            int pageHeight = this.innerBounds.height / 18;
            int sizeForFavorites = this.getScrollNumberForFavorites();
            int slotsToPrepare = this.allStacks.size() * 3 + sizeForFavorites * 3;
            int currentX = 0;
            int currentY = 0;
            LinkedList entries = Lists.newLinkedList();
            for (int i = 0; i < slotsToPrepare; ++i) {
                int xPos = currentX * 18 + this.innerBounds.x;
                int yPos = currentY * 18 + this.innerBounds.y;
                entries.add((EntryListEntry)new EntryListEntry(xPos, yPos).noBackground());
                if (++currentX < width) continue;
                currentX = 0;
                ++currentY;
            }
            this.entries = entries;
            this.widgets = Collections.unmodifiableList(entries);
        }
        if ((favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget()) != null) {
            favoritesListWidget.updateEntriesPosition();
        }
    }

    @Deprecated
    public List<EntryStack> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm) {
        this.lastSearchArguments = this.processSearchTerm(searchTerm);
        LinkedList list = Lists.newLinkedList();
        boolean checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
        List<EntryStack> workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
        for (EntryStack stack : EntryRegistry.getInstance().getStacksList()) {
            if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null) continue;
            list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
        }
        Object ordering = ConfigObject.getInstance().getItemListOrdering();
        if (ordering == ItemListOrdering.name) {
            list.sort(ENTRY_NAME_COMPARER);
        }
        if (ordering == ItemListOrdering.item_groups) {
            list.sort(ENTRY_GROUP_COMPARER);
        }
        if (!ConfigObject.getInstance().isItemListAscending()) {
            Collections.reverse(list);
        }
        this.allStacks = list;
        if (ConfigObject.getInstance().isFavoritesEnabled() && !ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
            list = Lists.newLinkedList();
            checkCraftable = ConfigManager.getInstance().isCraftableOnlyEnabled() && !ScreenHelper.inventoryStacks.isEmpty();
            workingItems = checkCraftable ? RecipeHelper.getInstance().findCraftableEntriesByItems(CollectionUtils.map(ScreenHelper.inventoryStacks, EntryStack::create)) : null;
            for (EntryStack stack : ConfigManager.getInstance().getFavorites()) {
                if (!this.canLastSearchTermsBeAppliedTo(stack) || workingItems != null && CollectionUtils.findFirstOrNullEquals(workingItems, stack) == null) continue;
                list.add(stack.copy().setting(EntryStack.Settings.RENDER_COUNTS, EntryStack.Settings.FALSE).setting(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT, RENDER_ENCHANTMENT_GLINT));
            }
            ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == ItemListOrdering.name) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == ItemListOrdering.item_groups) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.favorites = list;
        } else {
            this.favorites = Collections.emptyList();
        }
        this.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favoritesListWidget = ContainerScreenOverlay.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateSearch(this, searchTerm);
        }
        this.updateEntriesPosition();
    }

    public boolean canLastSearchTermsBeAppliedTo(EntryStack stack) {
        return this.lastSearchArguments.isEmpty() || this.canSearchTermsBeAppliedTo(stack, this.lastSearchArguments);
    }

    private boolean canSearchTermsBeAppliedTo(EntryStack stack, List<SearchArgument.SearchArguments> searchArguments) {
        if (searchArguments.isEmpty()) {
            return true;
        }
        String mod = null;
        String name = null;
        Object tooltip = null;
        String[] tags = null;
        for (SearchArgument.SearchArguments arguments : searchArguments) {
            boolean applicable = true;
            for (SearchArgument argument : arguments.getArguments()) {
                if (argument.getArgumentType() == SearchArgument.ArgumentType.ALWAYS) {
                    return true;
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.MOD) {
                    if (mod == null) {
                        mod = stack.getIdentifier().map(class_2960::method_12836).orElse(EMPTY).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (mod == null || mod.isEmpty() || !argument.getFunction(!argument.isInclude()).apply(mod).booleanValue()) continue;
                    applicable = false;
                    break;
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.TEXT) {
                    if (name == null) {
                        name = SearchArgument.tryGetEntryStackName(stack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (name == null || name.isEmpty() || !argument.getFunction(!argument.isInclude()).apply(name).booleanValue()) continue;
                    applicable = false;
                    break;
                }
                if (argument.getArgumentType() == SearchArgument.ArgumentType.TOOLTIP) {
                    if (name == null) {
                        name = SearchArgument.tryGetEntryStackTooltip(stack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT);
                    }
                    if (name == null || name.isEmpty() || !argument.getFunction(!argument.isInclude()).apply(name).booleanValue()) continue;
                    applicable = false;
                    break;
                }
                if (argument.getArgumentType() != SearchArgument.ArgumentType.TAG) continue;
                if (tags == null) {
                    if (stack.getType() == EntryStack.Type.ITEM) {
                        class_2960[] tagsFor = this.minecraft.method_1562().method_2867().method_15201().method_15191((Object)stack.getItem()).toArray(new class_2960[0]);
                        tags = new String[tagsFor.length];
                        for (int i = 0; i < tagsFor.length; ++i) {
                            tags[i] = tagsFor[i].toString();
                        }
                    } else if (stack.getType() == EntryStack.Type.FLUID) {
                        class_2960[] tagsFor = this.minecraft.method_1562().method_2867().method_15205().method_15191((Object)stack.getFluid()).toArray(new class_2960[0]);
                        tags = new String[tagsFor.length];
                        for (int i = 0; i < tagsFor.length; ++i) {
                            tags[i] = tagsFor[i].toString();
                        }
                    } else {
                        tags = new String[]{};
                    }
                }
                if (tags != null && tags.length > 0) {
                    boolean a = false;
                    for (String tag : tags) {
                        if (!argument.getFunction(argument.isInclude()).apply(tag).booleanValue()) continue;
                        a = true;
                    }
                    if (a) continue;
                    applicable = false;
                    break;
                }
                applicable = false;
                break;
            }
            if (!applicable) continue;
            return true;
        }
        return false;
    }

    private List<SearchArgument.SearchArguments> processSearchTerm(String searchTerm) {
        ArrayList searchArguments = Lists.newArrayList();
        for (String split : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm.toLowerCase(Locale.ROOT), (String)"|")) {
            String[] terms = StringUtils.split((String)split);
            if (terms.length == 0) {
                searchArguments.add(SearchArgument.SearchArguments.ALWAYS);
                continue;
            }
            SearchArgument[] arguments = new SearchArgument[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                String term = terms[i];
                arguments[i] = term.startsWith("-@") || term.startsWith("@-") ? new SearchArgument(SearchArgument.ArgumentType.MOD, term.substring(2), false) : (term.startsWith("@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, term.substring(1), true) : (term.startsWith("-$") || term.startsWith("$-") ? new SearchArgument(SearchArgument.ArgumentType.TAG, term.substring(2), false) : (term.startsWith("$") ? new SearchArgument(SearchArgument.ArgumentType.TAG, term.substring(1), true) : (term.startsWith("-#") || term.startsWith("#-") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, term.substring(2), false) : (term.startsWith("#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, term.substring(1), true) : (term.startsWith("-") ? new SearchArgument(SearchArgument.ArgumentType.TEXT, term.substring(1), false) : new SearchArgument(SearchArgument.ArgumentType.TEXT, term, true)))))));
            }
            searchArguments.add(new SearchArgument.SearchArguments(arguments));
        }
        return searchArguments;
    }

    public List<? extends Widget> children() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.getMaxScroll();
        if (height > (double)(actualHeight = this.bounds.height) && double_2 >= (double)this.bounds.y && double_2 <= (double)this.bounds.getMaxY() && double_1 >= (scrollbarPositionMinX = (double)this.getScrollbarMinX()) - 1.0 & double_1 <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            return true;
        }
        this.draggingScrollBar = false;
        if (this.containsMouse(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    private class EntryListEntry
    extends EntryWidget {
        private int backupY;
        private boolean isFavorites;

        private EntryListEntry(int x, int y) {
            super(x, y);
            this.backupY = y;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.bounds.contains(mouseX, mouseY);
        }

        @Override
        protected void drawHighlighted(int mouseX, int mouseY, float delta) {
            if (this.getCurrentEntry().getType() != EntryStack.Type.EMPTY) {
                super.drawHighlighted(mouseX, mouseY, delta);
            }
        }

        private String getLocalizedName(class_3675.class_306 value) {
            String string_1 = value.method_1441();
            int int_1 = value.method_1444();
            String string_2 = null;
            switch (value.method_1442()) {
                case field_1668: {
                    string_2 = class_3675.method_15988((int)int_1);
                    break;
                }
                case field_1671: {
                    string_2 = class_3675.method_15982((int)int_1);
                    break;
                }
                case field_1672: {
                    String string_3 = class_1074.method_4662((String)string_1, (Object[])new Object[0]);
                    string_2 = Objects.equals(string_3, string_1) ? class_1074.method_4662((String)class_3675.class_307.field_1672.method_15989(), (Object[])new Object[]{int_1 + 1}) : string_3;
                }
            }
            return string_2 == null ? class_1074.method_4662((String)string_1, (Object[])new Object[0]) : string_2;
        }

        @Override
        protected void queueTooltip(int mouseX, int mouseY, float delta) {
            QueuedTooltip tooltip;
            if ((!ClientHelper.getInstance().isCheating() || this.minecraft.field_1724.field_7514.method_7399().method_7960()) && (tooltip = this.getCurrentTooltip(mouseX, mouseY)) != null) {
                if (ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().doDisplayFavoritesOnTheLeft()) {
                    String name = this.getLocalizedName(ConfigObject.getInstance().getFavoriteKeybind());
                    if (!this.isFavorites) {
                        tooltip.getText().addAll(Arrays.asList(class_1074.method_4662((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")));
                    } else {
                        tooltip.getText().addAll(Arrays.asList(class_1074.method_4662((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")));
                    }
                }
                ScreenHelper.getLastOverlay().addTooltip(tooltip);
            }
        }

        @Override
        public boolean keyPressed(int int_1, int int_2, int int_3) {
            if (this.interactable && ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(PointHelper.fromMouse()) && !this.getCurrentEntry().isEmpty()) {
                class_3675.class_306 keyCode = ConfigObject.getInstance().getFavoriteKeybind();
                if (int_1 == class_3675.field_16237.method_1444()) {
                    if (keyCode.method_1442() == class_3675.class_307.field_1671 && keyCode.method_1444() == int_2) {
                        if (!this.isFavorites) {
                            ConfigManager.getInstance().getFavorites().add(this.getCurrentEntry().copy());
                            ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                        } else {
                            ConfigManager.getInstance().getFavorites().remove(this.getCurrentEntry());
                            ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                        }
                        ConfigManager.getInstance().saveConfig();
                        this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        return true;
                    }
                } else if (keyCode.method_1442() == class_3675.class_307.field_1668 && keyCode.method_1444() == int_1) {
                    if (!this.isFavorites) {
                        ConfigManager.getInstance().getFavorites().add(this.getCurrentEntry().copy());
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                    } else {
                        ConfigManager.getInstance().getFavorites().remove(this.getCurrentEntry());
                        ContainerScreenOverlay.getEntryListWidget().updateSearch(ScreenHelper.getSearchField().getText());
                    }
                    ConfigManager.getInstance().saveConfig();
                    this.minecraft.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                    return true;
                }
            }
            return super.keyPressed(int_1, int_2, int_3);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.interactable) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating()) {
                EntryStack entry = this.getCurrentEntry().copy();
                if (entry.getType() == EntryStack.Type.ITEM) {
                    if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.REI_LIKE) {
                        entry.setAmount(button != 1 ? 1 : entry.getItemStack().method_7914());
                    } else if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.JEI_LIKE) {
                        entry.setAmount(button != 0 ? 1 : entry.getItemStack().method_7914());
                    } else {
                        entry.setAmount(1);
                    }
                }
                ClientHelper.getInstance().tryCheatingEntry(entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

